/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.mathml.WmiMathMLTag;

public class WmiMathMLContentFenceImportAction
extends WmiMathMLImportAction {
    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathFencedModel m = null;
        try {
            WmiMathContext context = new WmiMathContext(new WmiMathAttributeSet());
            m = new WmiMathFencedModel(doc, new WmiModel[0], context);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return m;
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathFencedModel active = (WmiMathFencedModel)((WmiMathMLImportParser)parser).getActiveModel();
        WmiMathModel parent = (WmiMathModel)((Object)active.getParent());
        String function = inputSource.toString();
        ((WmiMathMLImportParser)parser).pushApplyFunction(function);
        if (function.equals(WmiMathMLTag.ABS.getName())) {
            parent.addAttribute("Typesetting:-msemantics", "abs");
            active.addAttribute("open", "&verbar;");
            active.addAttribute("close", "&verbar;");
        } else if (function.equals(WmiMathMLTag.CARD.getName())) {
            parent.addAttribute("Typesetting:-msemantics", "card");
            active.addAttribute("open", "&verbar;");
            active.addAttribute("close", "&verbar;");
        } else if (function.equals(WmiMathMLTag.FLOOR.getName())) {
            parent.addAttribute("Typesetting:-msemantics", "floor");
            active.addAttribute("open", "&lfloor;");
            active.addAttribute("close", "&rfloor;");
        } else if (function.equals(WmiMathMLTag.QUOTIENT.getName())) {
            parent.addAttribute("Typesetting:-msemantics", "quotient");
            active.addAttribute("open", "&lfloor;");
            active.addAttribute("close", "&rfloor;");
        } else if (function.equals(WmiMathMLTag.CEILING.getName())) {
            parent.addAttribute("Typesetting:-msemantics", "ceiling");
            active.addAttribute("open", "&lceil;");
            active.addAttribute("close", "&rceil;");
        }
        super.endAction(parser, inputSource);
    }
}

