/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import org.xml.sax.Attributes;

public class WmiMathMLContentIntervalImportAction
extends WmiMathMLImportAction {
    private static final String CLOSURE = "closure";
    private static final String OPEN = "open";
    private static final String CLOSED = "closed";
    private static final String OPEN_CLOSED = "open-closed";
    private static final String CLOSED_OPEN = "closed-open";
    private String closure = "closed";

    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathFencedModel m = null;
        try {
            WmiMathContext context = new WmiMathContext(new WmiMathAttributeSet());
            m = new WmiMathFencedModel(doc, new WmiModel[0], context);
            m.addAttribute("Typesetting:-msemantics", "interval");
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        return m;
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String closureString = source.getValue(CLOSURE);
        if (closureString != null) {
            this.closure = closureString;
        }
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathFencedModel active = (WmiMathFencedModel)((WmiMathMLImportParser)parser).getActiveModel();
        if (this.closure.equals(OPEN)) {
            active.addAttribute(OPEN, "(");
            active.addAttribute("close", ")");
        } else if (this.closure.equals(OPEN_CLOSED)) {
            active.addAttribute(OPEN, "(");
            active.addAttribute("close", "]");
        } else if (this.closure.equals(CLOSED_OPEN)) {
            active.addAttribute(OPEN, "[");
            active.addAttribute("close", ")");
        } else {
            active.addAttribute(OPEN, "[");
            active.addAttribute("close", "]");
        }
        super.endAction(parser, inputSource);
    }
}

