/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;

public class WmiMathMLContentMatrixImportAction
extends WmiMathMLImportAction {
    private static final String VECTOR = "vector";

    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathFencedModel m = null;
        try {
            WmiMathTableModel table = new WmiMathTableModel(doc);
            WmiModel[] kids = new WmiModel[]{table};
            WmiMathContext context = new WmiMathContext(new WmiMathAttributeSet());
            m = new WmiMathFencedModel(doc, kids, context);
            m.addAttribute("open", "[");
            m.addAttribute("close", "]");
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return m;
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (parser != null) {
            if (inputSource != null && inputSource.equals(VECTOR)) {
                ((WmiMathMLImportParser)parser).updateVectorModel();
            } else {
                ((WmiMathMLImportParser)parser).updateMatrixModel();
            }
            super.endAction(parser, inputSource);
        }
    }
}

