/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLEntityResolver;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLModelBuilder;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLParserModelBuilder;
import com.maplesoft.mathdoc.io.xml.WmiXMLImportParser;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMathMLParagraphModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiParagraphModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAlignGroupModel;
import com.maplesoft.mathdoc.model.math.WmiMathAlignMarkModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathEncloseModel;
import com.maplesoft.mathdoc.model.math.WmiMathErrorModel;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathGlyphModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathPaddedModel;
import com.maplesoft.mathdoc.model.math.WmiMathPhantomModel;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiNumericModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.mathdoc.model.mathml.WmiMathMLTag;
import com.maplesoft.util.WmiMathEntityNameMapper;
import com.maplesoft.util.WmiXMLParserImplementation;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WmiMathMLImportParser
extends WmiXMLImportParser {
    private static final int DEFAULT_FONT_SIZE = 12;
    private static final Color DEFAULT_FOREGROUND_COLOR = Color.BLACK;
    public boolean captureApplyFunction = false;
    private Stack applyStack = new Stack();
    private HashMap declarationMap = new HashMap();
    public static String[][] functionNameList = new String[][]{{"lambda", "lambda"}, {"max", "max"}, {"min", "min"}, {"gcd", "gcd"}, {"arg", "arg"}, {"real", "&real;"}, {"imaginary", "imaginary"}, {"lcm", "lcm"}, {"sin", "sin"}, {"cos", "cos"}, {"tan", "tan"}, {"sec", "sec"}, {"csc", "csc"}, {"cot", "cot"}, {"sinh", "sinh"}, {"cosh", "cosh"}, {"tanh", "tanh"}, {"sech", "sech"}, {"csch", "csch"}, {"coth", "coth"}, {"arcsin", "arcsin"}, {"arccos", "arccos"}, {"arctan", "arctan"}, {"arccosh", "arccosh"}, {"arccot", "arccot"}, {"arccoth", "arccoth"}, {"arccsc", "arccsc"}, {"arccsch", "arccsch"}, {"arcsec", "arcsec"}, {"arcsech", "arcsech"}, {"arcsinh", "arcsinh"}, {"arctanh", "arctanh"}, {"ln", "ln"}, {"mean", "mean"}, {"median", "median"}, {"mode", "model"}, {"sdev", "sdev"}, {"variance", "variance"}};
    public static String[][] infixOperatorList = new String[][]{{"compose", "&compfn;"}, {"minus", "&minus;"}, {"plus", "&plus;"}, {"times", "&InvisibleTimes;"}, {"and", "&and;"}, {"or", "&or;"}, {"implies", "&Implies;"}, {"eq", "&equals;"}, {"neq", "&NotEqual;"}, {"gt", "&gt;"}, {"lt", "&lt;"}, {"geq", "&geq;"}, {"leq", "&leq;"}, {"equivalent", "&equiv;"}, {"approx", "&approx;"}, {"factorof", "&verbar;"}, {"union", "&Union;"}, {"intersect", "&Intersection;"}, {"in", "&in;"}, {"notin", "&notin;"}, {"subset", "&subseteq;"}, {"prsubset", "&subset;"}, {"notsubset", "&NotSubsetEqual;"}, {"notprsubset", "&nsub;"}, {"setdiff", "&Backslash;"}, {"cartesianproduct", "&times;"}, {"vectorproduct", "&times;"}, {"scalarproduct", "&period;"}, {"outerproduct", "&CircleTimes;"}, {"rem", "mod"}, {"xor", "xor"}};
    public static String[][] postfixOperatorList = new String[][]{{"factorial", "!"}};
    public static String[][] prefixOperatorList = new String[][]{{"not", "&not;"}, {"minus", "&minus;"}, {"grad", "&Del;"}};
    public static String[][] constantList = new String[][]{{"ident", "id"}, {"integers", "&integers;"}, {"reals", "&reals;"}, {"rationals", "&rationals;"}, {"naturalnumbers", "&naturals;"}, {"complexes", "&complexes;"}, {"primes", "&primes;"}, {"exponentiale", "&ExponentialE;"}, {"imaginaryi", "&ImaginaryI;"}, {"notanumber", "NaN"}, {"true", "true"}, {"false", "false"}, {"emptyset", "&empty;"}, {"pi", "&pi;"}, {"eulergamma", "&Gamma;"}, {"infinity", "&infin;"}};
    private static HashMap modelFactoryMap = new HashMap();

    static {
        modelFactoryMap.put(WmiMathMLTag.ABS.getName(), new MathFencedBuilder());
        modelFactoryMap.put(WmiMathMLTag.FLOOR.getName(), new MathFencedBuilder());
        modelFactoryMap.put(WmiMathMLTag.CEILING.getName(), new MathFencedBuilder());
        modelFactoryMap.put(WmiMathMLTag.CARD.getName(), new MathFencedBuilder());
        modelFactoryMap.put(WmiMathMLTag.INVERSE.getName(), new MathInverseBuilder());
        modelFactoryMap.put(WmiMathMLTag.EXP.getName(), new MathExpBuilder());
        modelFactoryMap.put(WmiMathMLTag.TRANSPOSE.getName(), new MathTransposeBuilder());
        modelFactoryMap.put(WmiMathMLTag.POWER.getName(), new MathPowerBuilder());
        modelFactoryMap.put(WmiMathMLTag.DIVIDE.getName(), new MathDivideBuilder());
        modelFactoryMap.put(WmiMathMLTag.ROOT.getName(), new MathRootBuilder());
        modelFactoryMap.put(WmiMathMLTag.CONJUGATE.getName(), new MathConjugateBuilder());
        modelFactoryMap.put(WmiMathMLTag.DIFF.getName(), new MathDiffBuilder());
        modelFactoryMap.put(WmiMathMLTag.PARTIALDIFF.getName(), new MathPartialDiffBuilder());
        modelFactoryMap.put(WmiMathMLTag.LIMIT.getName(), new MathLargeOpBuilder());
        modelFactoryMap.put(WmiMathMLTag.PRODUCT.getName(), new MathLargeOpBuilder());
        modelFactoryMap.put(WmiMathMLTag.SUM.getName(), new MathLargeOpBuilder());
        modelFactoryMap.put(WmiMathMLTag.TENDSTO.getName(), new MathTendsToBuilder());
        modelFactoryMap.put(WmiMathMLTag.LOG.getName(), new MathLogBuilder());
        modelFactoryMap.put(WmiMathMLTag.MEAN.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.SDEV.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.VARIANCE.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.MEDIAN.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.MODE.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.MOMENT.getName(), new MathStatisticsBuilder());
        modelFactoryMap.put(WmiMathMLTag.DETERMINANT.getName(), new MathDeterminantBuilder());
        modelFactoryMap.put(WmiMathMLTag.SELECTOR.getName(), new MathSelectorBuilder());
        modelFactoryMap.put(WmiMathMLTag.FORALL.getName(), new MathForAllBuilder());
        modelFactoryMap.put(WmiMathMLTag.EXISTS.getName(), new MathExistsBuilder());
        modelFactoryMap.put(WmiMathMLTag.QUOTIENT.getName(), new MathQuotientBuilder());
        modelFactoryMap.put(WmiMathMLTag.INT.getName(), new MathIntegralBuilder());
        modelFactoryMap.put(WmiMathMLTag.CURL.getName(), new MathCurlBuilder());
        modelFactoryMap.put(WmiMathMLTag.DIVERGENCE.getName(), new MathDivergenceBuilder());
        modelFactoryMap.put(WmiMathMLTag.LAPLACIAN.getName(), new MathLaplacianBuilder());
    }

    public WmiMathMLImportParser() {
        this.xmlContentHandler = new WmiMathMLModelBuilder(this);
        this.parser = new WmiXMLParserImplementation(this.xmlContentHandler);
        this.parser.getXMLReader().setEntityResolver(new WmiMathMLEntityResolver());
    }

    @Override
    protected void hashActions() {
        String mathmlP = "com.maplesoft.mathdoc.io.mathml";
        this.addAction(WmiMathMLTag.MATH, mathmlP, "WmiMathMLPresentationMathImportAction");
        this.addAction(WmiMathMLTag.MI, mathmlP, "WmiMathMLPresentationMiImportAction");
        this.addAction(WmiMathMLTag.MN, mathmlP, "WmiMathMLPresentationMnImportAction");
        this.addAction(WmiMathMLTag.MO, mathmlP, "WmiMathMLPresentationMoImportAction");
        this.addAction(WmiMathMLTag.MTEXT, mathmlP, "WmiMathMLPresentationMtextImportAction");
        this.addAction(WmiMathMLTag.MSPACE, mathmlP, "WmiMathMLPresentationMspaceImportAction");
        this.addAction(WmiMathMLTag.MS, mathmlP, "WmiMathMLPresentationMsImportAction");
        this.addAction(WmiMathMLTag.MGLYPH, mathmlP, "WmiMathMLPresentationMglyphImportAction");
        this.addAction(WmiMathMLTag.MROW, mathmlP, "WmiMathMLPresentationMrowImportAction");
        this.addAction(WmiMathMLTag.MENCLOSE, mathmlP, "WmiMathMLPresentationMencloseImportAction");
        this.addAction(WmiMathMLTag.MFRAC, mathmlP, "WmiMathMLPresentationMfracImportAction");
        this.addAction(WmiMathMLTag.MSQRT, mathmlP, "WmiMathMLPresentationMsqrtImportAction");
        this.addAction(WmiMathMLTag.MROOT, mathmlP, "WmiMathMLPresentationMrootImportAction");
        this.addAction(WmiMathMLTag.MSTYLE, mathmlP, "WmiMathMLPresentationMstyleImportAction");
        this.addAction(WmiMathMLTag.MERROR, mathmlP, "WmiMathMLPresentationMerrorImportAction");
        this.addAction(WmiMathMLTag.MPADDED, mathmlP, "WmiMathMLPresentationMpaddedImportAction");
        this.addAction(WmiMathMLTag.MPHANTOM, mathmlP, "WmiMathMLPresentationMphantomImportAction");
        this.addAction(WmiMathMLTag.MFENCED, mathmlP, "WmiMathMLPresentationMfencedImportAction");
        this.addAction(WmiMathMLTag.MSUB, mathmlP, "WmiMathMLPresentationMsubImportAction");
        this.addAction(WmiMathMLTag.MSUP, mathmlP, "WmiMathMLPresentationMsupImportAction");
        this.addAction(WmiMathMLTag.MSUBSUP, mathmlP, "WmiMathMLPresentationMsubsupImportAction");
        this.addAction(WmiMathMLTag.MUNDER, mathmlP, "WmiMathMLPresentationMunderImportAction");
        this.addAction(WmiMathMLTag.MOVER, mathmlP, "WmiMathMLPresentationMoverImportAction");
        this.addAction(WmiMathMLTag.MUNDEROVER, mathmlP, "WmiMathMLPresentationMunderoverImportAction");
        this.addAction(WmiMathMLTag.MMULTISCRIPTS, mathmlP, "WmiMathMLPresentationMmultiscriptsImportAction");
        this.addAction(WmiMathMLTag.MSCRIPTS, mathmlP, "WmiMathMLPresentationMmultiscriptsImportAction");
        this.addAction(WmiMathMLTag.MPRESCRIPTS, mathmlP, "WmiMathMLPresentationMmultiscriptsImportAction$WmiMathMLPresentationMprescriptsImportAction");
        this.addAction(WmiMathMLTag.MNONE, mathmlP, "WmiMathMLPresentationMmultiscriptsImportAction$WmiMathMLPresentationMnoneImportAction");
        this.addAction(WmiMathMLTag.MTABLE, mathmlP, "WmiMathMLPresentationMtableImportAction");
        this.addAction(WmiMathMLTag.MTR, mathmlP, "WmiMathMLPresentationMtableImportAction$WmiMathMLPresentationMtrImportAction");
        this.addAction(WmiMathMLTag.MLABELEDTR, mathmlP, "WmiMathMLPresentationMtableImportAction$WmiMathMLPresentationMlabeledtrImportAction");
        this.addAction(WmiMathMLTag.MTD, mathmlP, "WmiMathMLPresentationMtableImportAction$WmiMathMLPresentationMtdImportAction");
        this.addAction(WmiMathMLTag.MALIGNGROUP, mathmlP, "WmiMathMLPresentationMaligngroupImportAction");
        this.addAction(WmiMathMLTag.MALIGNMARK, mathmlP, "WmiMathMLPresentationMalignmarkImportAction");
        this.addAction(WmiMathMLTag.MACTION, mathmlP, "WmiMathMLPresentationMactionImportAction");
        this.addAction(WmiMathMLTag.CN, mathmlP, "WmiMathMLContentCnImportAction");
        this.addAction(WmiMathMLTag.SEP, mathmlP, "WmiMathMLContentSepImportAction");
        this.addAction(WmiMathMLTag.CI, mathmlP, "WmiMathMLContentCiImportAction");
        this.addAction(WmiMathMLTag.CSYMBOL, mathmlP, "WmiMathMLContentCsymbolImportAction");
        this.addAction(WmiMathMLTag.DECLARE, mathmlP, "WmiMathMLContentDeclareImportAction");
        this.addAction(WmiMathMLTag.APPLY, mathmlP, "WmiMathMLContentApplyImportAction");
        this.addAction(WmiMathMLTag.RELN, mathmlP, "WmiMathMLContentApplyImportAction");
        this.addAction(WmiMathMLTag.LAMBDA, mathmlP, "WmiMathMLContentLambdaImportAction");
        this.addAction(WmiMathMLTag.BVAR, mathmlP, "WmiMathMLContentBvarImportAction");
        this.addAction(WmiMathMLTag.DEGREE, mathmlP, "WmiMathMLContentDegreeImportAction");
        this.addAction("GenericFunction", mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MAX, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MIN, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.REM, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.GCD, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARG, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.REAL, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.IMAGINARY, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.LCM, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.INT, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SIN, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.COS, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.TAN, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SEC, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.CSC, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.COT, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SINH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.COSH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.TANH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SECH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.CSCH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.COTH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCSIN, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCOS, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCTAN, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCOSH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCOT, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCOTH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCSC, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCCSCH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCSEC, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCSECH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCSINH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.ARCTANH, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.LN, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.CURL, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.DIVERGENCE, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.GRAD, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.LAPLACIAN, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.PLUS, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.COMPOSE, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.MINUS, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.PLUS, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.TIMES, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.AND, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.OR, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.XOR, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.IMPLIES, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.EQ, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.NEQ, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.GT, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.LT, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.GEQ, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.LEQ, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.EQUIVALENT, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.APPROX, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.FACTOROF, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.UNION, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.INTERSECT, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.IN, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.NOTIN, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.SUBSET, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.PRSUBSET, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.NOTSUBSET, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.NOTPRSUBSET, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.SETDIFF, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.CARTESIANPRODUCT, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.FACTORIAL, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.IDENTITY, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.INTEGERS, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.REALS, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.RATIONALS, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.NATURALNUMBERS, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.COMPLEXES, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.PRIMES, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.EXPONENTIALE, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.IMAGINARYI, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.NOTANUMBER, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.TRUE, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.FALSE, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.EMPTYSET, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.PI, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.EULERGAMMA, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.INFINITY, mathmlP, "WmiMathMLContentConstantImportAction");
        this.addAction(WmiMathMLTag.INTERVAL, mathmlP, "WmiMathMLContentIntervalImportAction");
        this.addAction(WmiMathMLTag.LIST, mathmlP, "WmiMathMLContentListImportAction");
        this.addAction(WmiMathMLTag.SET, mathmlP, "WmiMathMLContentSetImportAction");
        this.addAction(WmiMathMLTag.ABS, mathmlP, "WmiMathMLContentFenceImportAction");
        this.addAction(WmiMathMLTag.CARD, mathmlP, "WmiMathMLContentFenceImportAction");
        this.addAction(WmiMathMLTag.FLOOR, mathmlP, "WmiMathMLContentFenceImportAction");
        this.addAction(WmiMathMLTag.CEILING, mathmlP, "WmiMathMLContentFenceImportAction");
        this.addAction(WmiMathMLTag.QUOTIENT, mathmlP, "WmiMathMLContentFenceImportAction");
        this.addAction(WmiMathMLTag.INVERSE, mathmlP, "WmiMathMLContentSuperscriptImportAction");
        this.addAction(WmiMathMLTag.POWER, mathmlP, "WmiMathMLContentSuperscriptImportAction");
        this.addAction(WmiMathMLTag.EXP, mathmlP, "WmiMathMLContentSuperscriptImportAction");
        this.addAction(WmiMathMLTag.TRANSPOSE, mathmlP, "WmiMathMLContentSuperscriptImportAction");
        this.addAction(WmiMathMLTag.CONDITION, mathmlP, "WmiMathMLContentConditionImportAction");
        this.addAction(WmiMathMLTag.DIVIDE, mathmlP, "WmiMathMLContentDivideImportAction");
        this.addAction(WmiMathMLTag.ROOT, mathmlP, "WmiMathMLContentRootImportAction");
        this.addAction(WmiMathMLTag.EXISTS, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.FORALL, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.NOT, mathmlP, "WmiMathMLContentOperatorImportAction");
        this.addAction(WmiMathMLTag.CONJUGATE, mathmlP, "WmiMathMLContentConjugateImportAction");
        this.addAction(WmiMathMLTag.DIFF, mathmlP, "WmiMathMLContentDiffImportAction");
        this.addAction(WmiMathMLTag.PARTIALDIFF, mathmlP, "WmiMathMLContentDiffImportAction");
        this.addAction(WmiMathMLTag.LOWLIMIT, mathmlP, "WmiMathMLContentLowLimitImportAction");
        this.addAction(WmiMathMLTag.UPLIMIT, mathmlP, "WmiMathMLContentUpLimitImportAction");
        this.addAction(WmiMathMLTag.LIMIT, mathmlP, "WmiMathMLContentLargeOpImportAction");
        this.addAction(WmiMathMLTag.TENDSTO, mathmlP, "WmiMathMLContentTendsToImportAction");
        this.addAction(WmiMathMLTag.PRODUCT, mathmlP, "WmiMathMLContentLargeOpImportAction");
        this.addAction(WmiMathMLTag.SUM, mathmlP, "WmiMathMLContentLargeOpImportAction");
        this.addAction(WmiMathMLTag.LOG, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.LOGBASE, mathmlP, "WmiMathMLContentLogbaseImportAction");
        this.addAction(WmiMathMLTag.MEAN, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SDEV, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.VARIANCE, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MEDIAN, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MODE, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MOMENT, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.MOMENTABOUT, mathmlP, "WmiMathMLContentMomentAboutImportAction");
        this.addAction(WmiMathMLTag.VECTOR, mathmlP, "WmiMathMLContentMatrixImportAction");
        this.addAction(WmiMathMLTag.MATRIX, mathmlP, "WmiMathMLContentMatrixImportAction");
        this.addAction(WmiMathMLTag.MATRIXROW, mathmlP, "WmiMathMLContentMatrixRowImportAction");
        this.addAction(WmiMathMLTag.DETERMINANT, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.VECTORPRODUCT, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SCALARPRODUCT, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.OUTERPRODUCT, mathmlP, "WmiMathMLContentFunctionImportAction");
        this.addAction(WmiMathMLTag.SELECTOR, mathmlP, "WmiMathMLContentSelectorImportAction");
        this.addAction(WmiMathMLTag.FN, mathmlP, "WmiMathMLContentFnImportAction");
        this.addAction(WmiMathMLTag.SEMANTICS, mathmlP, "WmiMathMLContentSemanticsImportAction");
        this.addAction(WmiMathMLTag.ANNOTATION, mathmlP, "WmiMathMLContentAnnotationImportAction");
        this.addAction(WmiMathMLTag.ANNOTATION_XML, mathmlP, "WmiMathMLContentAnnotationImportAction");
    }

    public static String formatInput(String inputMathML, Color foreground, int fontSize) {
        StringBuffer formattedMathML = new StringBuffer(inputMathML);
        int mathIndex = formattedMathML.indexOf("<math");
        int endIndex = -1;
        while (mathIndex != -1) {
            if ((mathIndex = formattedMathML.indexOf("<math", mathIndex + "<math".length())) == -1) continue;
            int closeBracketIndex = formattedMathML.indexOf(">", mathIndex);
            formattedMathML.delete(mathIndex, closeBracketIndex + 1);
            endIndex = formattedMathML.indexOf("</math>", mathIndex);
            if (endIndex == -1) continue;
            formattedMathML.delete(endIndex, endIndex + "</math>".length());
        }
        int insertIndex = -1;
        Pattern p = Pattern.compile("<math[^>]*> *<semantics>");
        Matcher m = p.matcher(formattedMathML.toString());
        if (m.find()) {
            insertIndex = m.end();
        } else {
            p = Pattern.compile("<math[^>]*>");
            m = p.matcher(formattedMathML.toString());
            if (m.find()) {
                insertIndex = m.end();
            }
        }
        if ((foreground != null && foreground != DEFAULT_FOREGROUND_COLOR || fontSize != 0 && fontSize != 12) && insertIndex != -1) {
            formattedMathML.insert(insertIndex, "<mstyle mathcolor='#" + Integer.toHexString(foreground.getRGB()).substring(2) + "' mathsize='" + fontSize + "'>");
            int lastIndex = -1;
            p = Pattern.compile("</semantics> *</math>");
            m = p.matcher(formattedMathML.toString());
            if (m.find()) {
                lastIndex = m.start();
            } else {
                p = Pattern.compile("</math>");
                m = p.matcher(formattedMathML.toString());
                if (m.find()) {
                    lastIndex = m.start();
                }
            }
            if (lastIndex != -1) {
                formattedMathML.insert(lastIndex, "</mstyle>");
            }
        }
        formattedMathML.insert(0, "<?xml version=\"1.0\" standalone=\"no\" ?>");
        return formattedMathML.toString();
    }

    public static boolean isOperator(String[][] operatorList, String op) {
        int i = 0;
        while (i < operatorList.length) {
            String[] l = operatorList[i];
            if (l[0].equals(op)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getOperatorEntity(String[][] operatorList, String name) {
        int i = 0;
        while (i < operatorList.length) {
            String[] l = operatorList[i];
            if (l[0].equals(name)) {
                return l[1];
            }
            ++i;
        }
        return null;
    }

    public static String getOperatorName(String[][] operatorList, String entity) {
        int i = 0;
        while (i < operatorList.length) {
            String[] l = operatorList[i];
            if (l[1].equals(entity)) {
                return l[0];
            }
            ++i;
        }
        return null;
    }

    public void addDeclaration(String name, WmiMathMLDeclaration declaration) {
        this.declarationMap.put(name, declaration);
    }

    public void startApply() {
        this.captureApplyFunction = true;
    }

    public void pushApplyFunction(Object function) {
        if (this.captureApplyFunction) {
            this.applyStack.push(function);
            this.captureApplyFunction = false;
        }
    }

    public Object popApplyFunction() {
        return this.applyStack.pop();
    }

    @Override
    public void openModel(WmiModel newModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (newModel != null) {
            WmiModel active = this.getActiveModel();
            if (active instanceof WmiCompositeModel) {
                newModel.setParent((WmiCompositeModel)active);
                this.setActiveModel(newModel);
            } else if (newModel.getTag() == WmiMathMLTag.MATH_GLYPH && active instanceof WmiAbstractMathTokenModel) {
                ((WmiMathGlyphModel)newModel).setGlyphParent((WmiAbstractMathTokenModel)active);
                this.setActiveModel(newModel);
                ((WmiAbstractMathTokenModel)active).addGlyph((WmiMathGlyphModel)newModel);
            } else {
                this.reportObjectError(newModel.toString(), null, active, "Active model is not a valid parent.");
            }
        }
    }

    @Override
    public void closeModel(WmiModel newModel) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModel active = this.getActiveModel();
        super.closeModel(newModel);
        if (active.getTag() == WmiMathMLTag.MATH_GLYPH && ((WmiMathGlyphModel)active).getGlyphParent() != null) {
            this.setActiveModel(((WmiMathGlyphModel)active).getGlyphParent());
        }
    }

    private void updateTokenElement(String contents, WmiModel active, WmiModelTag tag) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel model = null;
        WmiCompositeModel parent = active.getParent();
        ArrayList<WmiMathModel> newChildList = new ArrayList<WmiMathModel>();
        WmiAttributeSet attributes = active.getAttributes();
        WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)attributes);
        StringBuffer convertedContents = new StringBuffer(contents);
        int beginIndex = 0;
        while (convertedContents.indexOf("ent_", beginIndex) != -1) {
            beginIndex = convertedContents.indexOf("ent_");
            convertedContents.replace(beginIndex, beginIndex + 4, "&");
        }
        contents = convertedContents.toString();
        String entity = "";
        String nonEntity = "";
        String[] tokens = contents.trim().split("&");
        ArrayList<String> newTokens = new ArrayList<String>();
        StringBuffer token = new StringBuffer();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i].indexOf(";") != -1 && !tokens[i].equals(";")) {
                entity = tokens[i].substring(0, tokens[i].indexOf(";"));
                if (!WmiMathEntityNameMapper.isNonMarkingEntity(entity)) {
                    token.append("&" + tokens[i]);
                } else {
                    if (token.length() > 0) {
                        newTokens.add(token.toString());
                    }
                    if (entity.length() > 0) {
                        newTokens.add("&" + entity + ";");
                    }
                    if (entity.length() + 1 < tokens[i].length()) {
                        newTokens.add(tokens[i].substring(entity.length() + 1));
                    }
                    token = new StringBuffer();
                }
            } else {
                if (i > 0) {
                    token.append("&");
                }
                token.append(tokens[i]);
            }
            ++i;
        }
        if (token.length() > 0) {
            newTokens.add(token.toString());
        }
        tokens = newTokens.toArray(new String[newTokens.size()]);
        i = 0;
        while (i < tokens.length) {
            String e;
            String string = e = tokens[i].length() > 2 && tokens[i].indexOf(";") > 2 ? tokens[i].substring(1, tokens[i].indexOf(";")) : tokens[i];
            if (WmiMathEntityNameMapper.isNonMarkingEntity(e)) {
                entity = tokens[i];
                WmiMathSpaceModel.WmiMathSpaceAttributeSet attr = new WmiMathSpaceModel.WmiMathSpaceAttributeSet();
                ArrayList attrList = this.getMSpaceAttribute(e);
                int a = 0;
                while (a < attrList.size()) {
                    attr.addAttribute(attrList.get(a), attrList.get(a + 1));
                    a += 2;
                }
                WmiMathSpaceModel space = new WmiMathSpaceModel(active.getDocument(), "", (WmiAttributeSet)attr);
                newChildList.add(space);
            } else {
                WmiAttributeSet modelAttributes;
                nonEntity = tokens[i];
                if (WmiModelTag.MATH_IDENTIFIER.equals(tag)) {
                    model = WmiMathFactory.createMathIdentifierToken(active.getDocument(), nonEntity, context);
                } else if (WmiModelTag.MATH_NUMERIC.equals(tag)) {
                    model = WmiMathFactory.createMathNumericToken(active.getDocument(), nonEntity, context);
                } else if (WmiModelTag.MATH_TEXT.equals(tag)) {
                    model = WmiMathFactory.createMathTextToken(active.getDocument(), nonEntity, context);
                } else if (WmiModelTag.MATH_OPERATOR.equals(tag)) {
                    int next = 0;
                    String opName = "";
                    int ampIndex = -1;
                    int semiIndex = -1;
                    while (next < nonEntity.length()) {
                        if (nonEntity.charAt(next) == '&') {
                            ampIndex = nonEntity.indexOf("&", next + 1);
                            semiIndex = nonEntity.indexOf(";", next);
                            if (semiIndex != -1) {
                                if (ampIndex == -1 || ampIndex > semiIndex) {
                                    opName = nonEntity.substring(next, semiIndex + 1);
                                    next = semiIndex + 1;
                                } else {
                                    opName = nonEntity.substring(next, ampIndex);
                                    next = ampIndex;
                                }
                            } else if (ampIndex == next + 1) {
                                opName = nonEntity.substring(next, next + 1);
                                ++next;
                            } else {
                                opName = nonEntity.substring(next);
                                next = nonEntity.length();
                            }
                        } else {
                            ampIndex = nonEntity.indexOf("&", next);
                            if (ampIndex == -1) {
                                opName = nonEntity.substring(next);
                                next = nonEntity.length();
                            } else {
                                semiIndex = nonEntity.indexOf(";", ampIndex);
                                if (semiIndex == -1) {
                                    opName = nonEntity.substring(next);
                                    next = nonEntity.length();
                                } else {
                                    opName = nonEntity.substring(next, ampIndex);
                                    next = ampIndex;
                                }
                            }
                        }
                        model = WmiMathFactory.createMathOperatorToken(active.getDocument(), opName, context);
                        model.addAttributes(attributes);
                        if (next < nonEntity.length()) {
                            newChildList.add(model);
                        }
                        if (!WmiModelLock.updateLock(model, true)) continue;
                        try {
                            try {
                                model.update(null);
                            }
                            catch (WmiNoUpdateAccessException nuae) {
                                WmiErrorLog.log(nuae);
                                WmiModelLock.updateUnlock(model);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            WmiModelLock.updateUnlock(model);
                            throw throwable;
                        }
                        WmiModelLock.updateUnlock(model);
                    }
                } else if (WmiModelTag.MATH_SPACE.equals(tag)) {
                    model = new WmiMathSpaceModel(active.getDocument(), nonEntity, attributes);
                } else if (WmiModelTag.MATH_STRING.equals(tag)) {
                    model = new WmiMathStringModel(active.getDocument(), nonEntity, context);
                } else if (WmiModelTag.MATH_ERROR.equals(tag)) {
                    model = new WmiMathErrorModel(active.getDocument(), nonEntity);
                }
                if (model instanceof WmiAbstractMathTokenModel) {
                    ((WmiAbstractMathTokenModel)model).setModified(((WmiAbstractMathTokenModel)this.getActiveModel()).getModified());
                }
                if ((modelAttributes = model.getAttributes()) instanceof WmiFontAttributeSet) {
                    ((WmiFontAttributeSet)modelAttributes).setExtendedStyle(context.getStyle().getExtendedStyle());
                }
                model.setAttributes(modelAttributes);
                newChildList.add(model);
            }
            ++i;
        }
        try {
            if (newChildList.size() > 1) {
                WmiModel[] childArray = newChildList.toArray(new WmiModel[newChildList.size()]);
                WmiModel[] smallerChildArray = new WmiModel[newChildList.size() - 1];
                System.arraycopy(childArray, 0, smallerChildArray, 0, childArray.length - 1);
                parent.addChildren(smallerChildArray, parent.getChildCount());
            }
            if (newChildList.size() > 0) {
                this.cancelActiveModel();
                this.openModel((WmiModel)newChildList.get(newChildList.size() - 1));
            }
        }
        catch (WmiModelIndexOutOfBoundsException miobe) {
            WmiErrorLog.log(miobe);
        }
    }

    @Override
    public void defineTextContent(String contents) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelTag tag;
        WmiModel active;
        if (contents.equals("&")) {
            contents = "&amp;";
        }
        if ((active = this.getActiveModel()) != null && (WmiModelTag.MATH_IDENTIFIER.equals(tag = active.getTag()) || WmiModelTag.MATH_NUMERIC.equals(tag) || WmiModelTag.MATH_TEXT.equals(tag) || WmiModelTag.MATH_OPERATOR.equals(tag) || WmiModelTag.MATH_SPACE.equals(tag) || WmiModelTag.MATH_STRING.equals(tag) || WmiModelTag.MATH_ERROR.equals(tag))) {
            this.updateTokenElement(contents, active, tag);
        }
    }

    @Override
    protected void commitChild(WmiModel child) throws WmiNoWriteAccessException {
        try {
            WmiMathAlignMarkModel.WmiMathAlignMarkAttributeSet attrs;
            WmiAttributeSet childAttrs = child.getAttributesForRead();
            if (childAttrs.getAttribute("Typesetting:-msemantics") == "declare" || child instanceof WmiMathDocumentModel || child instanceof WmiMathGlyphModel && this.getActiveModel() == null) {
                return;
            }
            boolean mergeRight = false;
            boolean mergeLeft = false;
            boolean ignore = false;
            WmiCompositeModel parent = child.getParent();
            int childCount = parent.getChildCount();
            WmiModel lastChild = null;
            if (childCount > 0 && (lastChild = parent.getChild(childCount - 1)) != null) {
                if (lastChild.getTag() == WmiModelTag.MATH_ALIGN_GROUP) {
                    mergeRight = true;
                } else if (lastChild.getTag() == WmiModelTag.MATH_ALIGN_MARK && (attrs = (WmiMathAlignMarkModel.WmiMathAlignMarkAttributeSet)lastChild.getAttributesForRead()).getEdge().equals("left")) {
                    mergeRight = true;
                }
            }
            if (!mergeRight && child.getTag() == WmiModelTag.MATH_ALIGN_MARK && (attrs = (WmiMathAlignMarkModel.WmiMathAlignMarkAttributeSet)child.getAttributesForRead()).getEdge().equals("right") && childCount > 1) {
                WmiModel[] children = new WmiModel[]{lastChild, child};
                WmiInlineMathModel row = new WmiInlineMathModel(lastChild.getDocument(), children);
                WmiModel[] replace = new WmiModel[]{row};
                parent.replaceChildren(replace, parent.indexOf(lastChild), 1);
                mergeLeft = true;
            }
            if (mergeRight) {
                WmiModel[] children = new WmiModel[]{lastChild, child};
                WmiInlineMathModel row = new WmiInlineMathModel(lastChild.getDocument(), children);
                WmiModel[] replace = new WmiModel[]{row};
                parent.replaceChildren(replace, parent.indexOf(lastChild), 1);
            } else {
                WmiModel lastLeaf;
                if (child instanceof WmiCompositeModel && (lastLeaf = WmiModelUtil.findLastDescendantLeaf((WmiCompositeModel)child)) != null && lastLeaf.getTag() == WmiModelTag.MATH_ALIGN_GROUP) {
                    lastLeaf.getParent().removeChild(lastLeaf);
                }
                if (!mergeLeft && !ignore) {
                    super.commitChild(child);
                }
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
    }

    private void processOperatorChildren(WmiCompositeModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathOperatorModel op = (WmiMathOperatorModel)WmiModelUtil.findFirstDescendantOfTag((WmiModel)model, WmiModelTag.MATH_OPERATOR);
        while (op != null) {
            WmiCompositeModel parent = op.getParent();
            if (parent.getChildCount() == 2 && (parent.getChild(0) instanceof WmiMathAlignGroupModel || parent.getChild(0) instanceof WmiMathAlignMarkModel)) {
                parent = parent.getParent();
            }
            this.updateOperatorModelAttributes(op, parent);
            op = (WmiMathOperatorModel)WmiModelUtil.findNextModel((WmiModel)model, (WmiModel)op, WmiModelTag.MATH_OPERATOR);
        }
    }

    public void updateMathModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiParagraphModel paragraph = this.getActiveModel() instanceof WmiParagraphModel ? (WmiParagraphModel)this.getActiveModel() : (WmiParagraphModel)WmiModelUtil.findFirstDescendantOfClass(this.getActiveModel(), WmiMathMLParagraphModel.class);
            WmiMathWrapperModel wrapper = (WmiMathWrapperModel)paragraph.getChild(0);
            int i = 1;
            while (i < paragraph.getChildCount()) {
                WmiModel sibling = paragraph.getChild(i);
                wrapper.appendChild(sibling);
                ++i;
            }
            paragraph.removeChildren(1, paragraph.getChildCount() - 1);
            this.processOperatorChildren(wrapper);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateRowModel() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            WmiInlineMathModel active = (WmiInlineMathModel)this.getActiveModel();
            this.processOperatorChildren(active);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateEncloseModel() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            WmiMathEncloseModel active = (WmiMathEncloseModel)this.getActiveModel();
            WmiMathEncloseModel.WmiMathEncloseAttributeSet attrs = (WmiMathEncloseModel.WmiMathEncloseAttributeSet)active.getAttributesForRead();
            if (attrs.isRadical()) {
                WmiCompositeModel parent = active.getParent();
                WmiMathContext context = new WmiMathContext(new WmiMathAttributeSet());
                WmiMathDocumentModel doc = active.getDocument();
                WmiRootModel root = new WmiRootModel(doc, active, new WmiIdentifierModel(doc, "", "", context, false), context);
                this.openModel(root);
                root.setParent(parent);
            }
            this.processOperatorChildren(active);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateStyleModel() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathStyleModel active = (WmiMathStyleModel)this.getActiveModel();
        try {
            WmiModelUtil.visitModels(active, new WmiMathStyleModel.WmiApplyStyleVisitor(active, active.getAttributes(), false));
        }
        catch (WmiNoReadAccessException nra) {
            WmiErrorLog.log(nra);
        }
    }

    public void updateFractionModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiFractionModel active = (WmiFractionModel)this.getActiveModel();
            WmiModel[] newChildren = new WmiModel[]{active.getChild(2), active.getChild(3)};
            active.replaceChildren(newChildren, 0, 2);
            active.replaceChildren(new WmiModel[0], 2, 2);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateSquareRootModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiRootModel.WmiSquareRootModel active = (WmiRootModel.WmiSquareRootModel)this.getActiveModel();
            WmiInlineMathModel inline = (WmiInlineMathModel)active.getChild(0);
            int childCount = active.getChildCountForParsing();
            int i = childCount - 2;
            while (i >= 1) {
                inline.addChild(active.getChild(i), childCount - 2 - i);
                --i;
            }
            active.removeChildren(1, childCount - 1);
            this.processOperatorChildren(inline);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateRootModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiRootModel active = (WmiRootModel)this.getActiveModel();
            if (active.getChildCount() == 4) {
                WmiModel[] newChildren = new WmiModel[]{active.getChild(2), active.getChild(3)};
                active.replaceChildren(newChildren, 0, 2);
                active.replaceChildren(new WmiModel[0], 2, 2);
            } else {
                WmiMathErrorModel error = new WmiMathErrorModel(active.getDocument(), "<mroot> must have two children");
                this.cancelActiveModel();
                this.openModel(error);
            }
            this.processOperatorChildren(active);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updatePaddedModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiMathPaddedModel active = (WmiMathPaddedModel)this.getActiveModel();
            WmiInlineMathModel inline = (WmiInlineMathModel)active.getChild(0);
            int childCount = active.getChildCount();
            int i = 1;
            while (i < childCount) {
                inline.addChild(active.getChild(i), i - 1);
                ++i;
            }
            active.removeChildren(1, childCount - 1);
            this.processOperatorChildren(inline);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updatePhantomModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiMathPhantomModel active = (WmiMathPhantomModel)this.getActiveModel();
            WmiInlineMathModel inline = (WmiInlineMathModel)active.getChild(0);
            int childCount = active.getChildCount();
            int i = 1;
            while (i < childCount) {
                inline.addChild(active.getChild(i), i - 1);
                ++i;
            }
            active.removeChildren(1, childCount - 1);
            this.processOperatorChildren(inline);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateSubscriptModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiSubscriptModel active = (WmiSubscriptModel)this.getActiveModel();
            WmiModel[] newChildren = new WmiModel[]{active.getChild(2), active.getChild(3)};
            active.replaceChildren(newChildren, 0, 2);
            active.replaceChildren(new WmiModel[0], 2, 2);
            this.processOperatorChildren(active);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateSuperscriptModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiSuperscriptModel active = (WmiSuperscriptModel)this.getActiveModel();
            WmiModel[] newChildren = new WmiModel[2];
            if (active.getChild(2) != null && active.getChild(3) != null) {
                newChildren[0] = active.getChild(2);
                newChildren[1] = active.getChild(3);
                active.replaceChildren(newChildren, 0, 2);
                active.replaceChildren(new WmiModel[0], 2, 2);
            }
            this.processOperatorChildren(active);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateSubSuperscriptModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiSubSupModel active = (WmiSubSupModel)this.getActiveModel();
            WmiModel[] newChildren = new WmiModel[]{active.getChild(3), active.getChild(4), active.getChild(5)};
            active.replaceChildren(newChildren, 0, 3);
            active.replaceChildren(new WmiModel[0], 3, 3);
            this.processOperatorChildren(active);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateUnderModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiUnderModel active = (WmiUnderModel)this.getActiveModel();
            WmiModel[] newChildren = new WmiModel[]{active.getChild(2), active.getChild(3)};
            active.replaceChildren(newChildren, 0, 2);
            active.replaceChildren(new WmiModel[0], 2, 2);
            this.processOperatorChildren(active);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateOverModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiOverModel active = (WmiOverModel)this.getActiveModel();
            WmiModel[] newChildren = new WmiModel[]{active.getChild(2), active.getChild(3)};
            active.replaceChildren(newChildren, 0, 2);
            active.replaceChildren(new WmiModel[0], 2, 2);
            this.processOperatorChildren(active);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateUnderOverModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiUnderOverModel active = (WmiUnderOverModel)this.getActiveModel();
            WmiAttributeSet attributes = active.getAttributes();
            WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)attributes);
            WmiModel[] newChildren = new WmiModel[]{active.getChild(3), active.getChild(4) != null ? active.getChild(4) : WmiMathFactory.createMathIdentifierToken(active.getDocument(), "", context), active.getChild(5) != null ? active.getChild(5) : WmiMathFactory.createMathIdentifierToken(active.getDocument(), "", context)};
            active.replaceChildren(newChildren, 0, 3);
            active.replaceChildren(new WmiModel[0], 3, active.getChildCount() - 3);
            this.processOperatorChildren(active);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateListModel() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathFencedModel active = (WmiMathFencedModel)this.getActiveModel();
        WmiMathDocumentModel doc = active.getDocument();
        WmiMathContext context = new WmiMathContext(new WmiMathAttributeSet());
        String semantics = (String)((WmiMathAttributeSet)active.getAttributes()).getAttribute("Typesetting:-msemantics");
        active.addAttribute("open", "[");
        active.addAttribute("close", "]");
        if (semantics.equals("list-numeric") || semantics.equals("list-lexicographic")) {
            String sortCommand = "numeric";
            if (semantics.equals("list-lexicographic")) {
                sortCommand = "lexorder";
            }
            try {
                WmiCompositeModel parent = active.getParent();
                WmiInlineMathModel inline = new WmiInlineMathModel(doc);
                WmiMathTokenModel sort = WmiMathFactory.createMathIdentifierToken(doc, "sort", context);
                WmiMathTokenModel applyF = WmiMathFactory.createMathOperatorToken(doc, "&ApplyFunction;", context);
                WmiModel[] kids = new WmiModel[]{active, WmiMathFactory.createMathIdentifierToken(doc, sortCommand, context)};
                WmiMathFencedModel f = new WmiMathFencedModel(doc, kids, context);
                inline.appendChild(sort);
                inline.appendChild(applyF);
                inline.appendChild(f);
                inline.setParent(parent);
                this.setActiveModel(inline);
                inline.addAttribute("Typesetting:-msemantics", "list");
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
            }
        }
    }

    public void updateTableModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiMathTableModel active = (WmiMathTableModel)this.getActiveModel();
            ArrayList<WmiModel> childList = new ArrayList<WmiModel>();
            int beginIndex = -1;
            int endIndex = 0;
            int i = 0;
            while (i < active.getChildCount()) {
                WmiModel child = active.getChild(i);
                if (!child.getTag().equals(WmiModelTag.MATH_TABLE_ROW) && !child.getTag().equals(WmiModelTag.MATH_TABLE_LABELED_ROW)) {
                    childList.add(child);
                    if (beginIndex == -1) {
                        beginIndex = i;
                    }
                } else if (!childList.isEmpty()) {
                    endIndex = i;
                    try {
                        WmiMathTableModel.WmiMathTableRowModel rowModel = new WmiMathTableModel.WmiMathTableRowModel(active.getDocument(), childList.toArray(new WmiModel[endIndex - 1 - beginIndex]));
                        WmiModel[] row = new WmiModel[]{rowModel};
                        active.replaceChildren(row, beginIndex, endIndex - beginIndex);
                    }
                    catch (WmiInvalidModelInitializationException imie) {
                        WmiErrorLog.log(imie);
                    }
                    childList.clear();
                    beginIndex = -1;
                    i = -1;
                }
                ++i;
            }
            if (!childList.isEmpty()) {
                endIndex = active.getChildCount() - 1;
                try {
                    WmiMathTableModel.WmiMathTableRowModel rowModel = new WmiMathTableModel.WmiMathTableRowModel(active.getDocument(), childList.toArray(new WmiModel[childList.size()]));
                    WmiModel[] row = new WmiModel[]{rowModel};
                    active.replaceChildren(row, beginIndex, endIndex - beginIndex + 1);
                }
                catch (WmiInvalidModelInitializationException imie) {
                    WmiErrorLog.log(imie);
                }
            }
            i = 0;
            while (i < active.getChildCount()) {
                this.updateTableRowModel((WmiMathTableModel.WmiMathTableRowModel)active.getChild(i));
                ++i;
            }
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateTableRowModel(WmiMathTableModel.WmiMathTableRowModel rowModel) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            int i = 0;
            while (i < rowModel.getChildCount()) {
                WmiModel child = rowModel.getChild(i);
                if (!child.getTag().equals(WmiModelTag.MATH_TABLE_CELL)) {
                    WmiMathTableModel.WmiMathTableDataModel cellModel = new WmiMathTableModel.WmiMathTableDataModel(rowModel.getDocument(), child);
                    WmiModel[] cell = new WmiModel[]{cellModel};
                    rowModel.replaceChildren(cell, i, 1);
                }
                ++i;
            }
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateTableDataModel() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        try {
            WmiMathTableModel.WmiMathTableDataModel active = (WmiMathTableModel.WmiMathTableDataModel)this.getActiveModel();
            WmiInlineMathModel inline = (WmiInlineMathModel)active.getChild(0);
            int i = 1;
            while (i < active.getChildCount()) {
                inline.addChild(active.getChild(i), i - 1);
                ++i;
            }
            active.removeChildren(1, active.getChildCount() - 1);
            this.processOperatorChildren(inline);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateAlignMarkModel(int edge) throws WmiNoReadAccessException {
        if (this.getActiveModel() instanceof WmiAbstractMathTokenModel) {
            WmiAbstractMathTokenModel token = (WmiAbstractMathTokenModel)this.getActiveModel();
            token.alignmarkIndex = token.getAllText().length() - 1;
            token.alignmarkEdge = edge;
        }
    }

    public void updateApplyModel() throws WmiNoReadAccessException {
        WmiMathAttributeSet attrs;
        WmiInlineMathModel active = (WmiInlineMathModel)this.getActiveModel();
        WmiCompositeModel parent = active.getParent();
        WmiMathDocumentModel doc = active.getDocument();
        WmiAttributeSet attributes = active.getAttributes();
        WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)attributes);
        Object function = null;
        String functionName = "";
        if (active.getChild(0) instanceof WmiIdentifierModel && (attrs = (WmiMathAttributeSet)((WmiIdentifierModel)(function = active.getChild(0))).getAttributesForRead()).getAttribute("Typesetting:-msemantics") != null && attrs.getAttribute("Typesetting:-msemantics") == "function") {
            functionName = ((WmiIdentifierModel)function).getText();
        }
        if (functionName.equals("") && this.applyStack.size() > 0) {
            function = this.popApplyFunction();
            if (function instanceof WmiMathTokenModel) {
                functionName = ((WmiMathTokenModel)function).getTokenContents();
            } else if (function instanceof String) {
                functionName = (String)function;
            }
        }
        try {
            String opEntity;
            if (WmiMathMLImportParser.isOperator(functionNameList, functionName)) {
                if (!WmiMathMLImportParser.getOperatorEntity(functionNameList, functionName).equals("")) {
                    String newName = WmiMathMLImportParser.getOperatorEntity(functionNameList, functionName).toString();
                    String oldName = ((WmiAbstractMathTokenModel)active.getChild(0)).getText();
                    ((WmiAbstractMathTokenModel)active.getChild(0)).replaceText(newName, 0, oldName.length());
                }
                ArrayList<WmiModel> parameters = new ArrayList<WmiModel>();
                int i = 1;
                while (i < active.getChildCount()) {
                    parameters.add(active.getChild(i));
                    ++i;
                }
                WmiMathTokenModel apply = WmiMathFactory.createMathOperatorToken(doc, "&ApplyFunction;", context);
                active.addChild(apply, 1);
                WmiMathFencedModel fenced = new WmiMathFencedModel(doc, parameters.toArray(new WmiModel[0]), context);
                WmiModel[] replace = new WmiModel[]{fenced};
                active.replaceChildren(replace, 2, active.getChildCount() - 2);
                active.addAttribute("Typesetting:-msemantics", "function");
            } else if (WmiMathMLImportParser.isOperator(infixOperatorList, functionName) && active.getChildCount() >= 3) {
                int i;
                opEntity = WmiMathMLImportParser.getOperatorEntity(infixOperatorList, functionName).toString();
                WmiMathTokenModel op = WmiMathFactory.createMathOperatorToken(doc, opEntity, context);
                active.removeChild(0);
                if (!functionName.equals(WmiMathMLTag.EQ.getName()) && !functionName.equals(WmiMathMLTag.EQUIVALENT.getName())) {
                    i = 0;
                    while (i < active.getChildCount()) {
                        WmiInlineMathModel inline;
                        WmiModel child = active.getChild(i);
                        if (!(!(child instanceof WmiInlineMathModel) || (inline = (WmiInlineMathModel)child).getChildCount() == 1 || inline.getChildCount() == 2 && inline.getChild(0) instanceof WmiMathOperatorModel && ((WmiMathOperatorModel)inline.getChild(0)).getSemanticLabel().equals("&minus;") || inline.getChildCount() == 3 && inline.getChild(1) instanceof WmiMathOperatorModel && (((WmiMathOperatorModel)inline.getChild(1)).getSemanticLabel().equals("&InvisibleTimes;") || ((WmiMathOperatorModel)inline.getChild(1)).getSemanticLabel().equals("&ApplyFunction;")))) {
                            WmiModel[] kids = new WmiModel[]{child};
                            WmiMathFencedModel fenced = new WmiMathFencedModel(doc, kids, context);
                            active.replaceChild(fenced, i);
                        }
                        ++i;
                    }
                }
                i = active.getChildCount() - 1;
                while (i > 0) {
                    op = WmiMathFactory.createMathOperatorToken(doc, opEntity, context);
                    active.addChild(op, i);
                    --i;
                }
                if (functionName.equals("cartesianproduct")) {
                    active.addAttribute("Typesetting:-msemantics", "cartesianproduct");
                } else {
                    active.addAttribute("Typesetting:-msemantics", "infix");
                }
            } else if (WmiMathMLImportParser.isOperator(postfixOperatorList, functionName)) {
                opEntity = WmiMathMLImportParser.getOperatorEntity(postfixOperatorList, functionName).toString();
                WmiMathTokenModel op = WmiMathFactory.createMathOperatorToken(doc, opEntity, context);
                WmiMathModel parameters = (WmiMathModel)active.getChild(1);
                if (parameters instanceof WmiCompositeModel && ((WmiCompositeModel)((Object)parameters)).getChildCount() > 1) {
                    WmiModel[] kids = new WmiModel[]{parameters};
                    WmiMathFencedModel fenced = new WmiMathFencedModel(doc, kids, context);
                    active.replaceChild(fenced, 1);
                }
                active.removeChild(0);
                active.addChild(op, 1);
                active.addAttribute("Typesetting:-msemantics", "postfix");
            } else if (WmiMathMLImportParser.isOperator(prefixOperatorList, functionName)) {
                opEntity = WmiMathMLImportParser.getOperatorEntity(prefixOperatorList, functionName).toString();
                WmiMathTokenModel op = WmiMathFactory.createMathOperatorToken(doc, opEntity, context);
                active.replaceChild(op, 0);
                boolean needFence = false;
                if (functionName.equals("minus")) {
                    WmiMathOperatorModel secondTermOp;
                    WmiInlineMathModel secondTerm;
                    if (active.getChildCount() > 1 && active.getChild(1) instanceof WmiInlineMathModel && (secondTerm = (WmiInlineMathModel)active.getChild(1)).getChildCount() == 3 && secondTerm.getChild(1) instanceof WmiMathOperatorModel && !(secondTermOp = (WmiMathOperatorModel)secondTerm.getChild(1)).getSemanticLabel().equals("&InvisibleTimes;")) {
                        needFence = true;
                    }
                } else if (active.getChildCount() > 2) {
                    needFence = true;
                }
                if (needFence) {
                    WmiMathFencedModel fenced = new WmiMathFencedModel(doc, new WmiModel[0], context);
                    WmiInlineMathModel inline = new WmiInlineMathModel(doc);
                    int i = 1;
                    while (i < active.getChildCount()) {
                        inline.appendChild(active.getChild(i));
                        ++i;
                    }
                    fenced.appendChild(inline);
                    active.replaceChild(fenced, 1);
                    active.removeChildren(2, active.getChildCount() - 2);
                }
                active.addAttribute("Typesetting:-msemantics", "prefix");
            } else {
                WmiMathMLParserModelBuilder builder = (WmiMathMLParserModelBuilder)modelFactoryMap.get(functionName);
                if (builder != null) {
                    this.setActiveModel(builder.createModel(doc, context, parent, active));
                } else {
                    ArrayList<WmiModel> parameters = new ArrayList<WmiModel>();
                    int i = 1;
                    while (i < active.getChildCount()) {
                        parameters.add(active.getChild(i));
                        ++i;
                    }
                    WmiMathTokenModel apply = WmiMathFactory.createMathOperatorToken(doc, "&ApplyFunction;", context);
                    active.addChild(apply, 1);
                    WmiMathFencedModel fenced = new WmiMathFencedModel(doc, parameters.toArray(new WmiModel[0]), context);
                    WmiModel[] replace = new WmiModel[]{fenced};
                    active.replaceChildren(replace, 2, active.getChildCount() - 2);
                    active.addAttribute("Typesetting:-msemantics", "function");
                }
            }
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
    }

    public WmiModel updateFnModel() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel active = (WmiInlineMathModel)this.getActiveModel();
        WmiMathDocumentModel doc = active.getDocument();
        WmiAttributeSet attributes = active.getAttributes();
        WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)attributes);
        try {
            if (active.getChild(0) instanceof WmiInlineMathModel) {
                WmiInlineMathModel fn = (WmiInlineMathModel)active.getChild(0);
                WmiModel[] kids = new WmiModel[]{fn};
                WmiMathFencedModel fenced = new WmiMathFencedModel(doc, kids, context);
                active.replaceChild(fenced, 0);
            }
            WmiModel name = WmiModelUtil.findFirstDescendantLeaf(active);
            this.pushApplyFunction(name);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        active.addAttribute("Typesetting:-msemantics", "fn");
        return active;
    }

    public void updateVectorModel() {
        try {
            WmiMathFencedModel active = (WmiMathFencedModel)this.getActiveModel();
            active.addAttribute("open", "(");
            active.addAttribute("close", ")");
            active.removeChild(0);
            active.addAttribute("Typesetting:-msemantics", "vector");
            this.setActiveModel(active);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateMatrixModel() {
        try {
            WmiMathFencedModel active = (WmiMathFencedModel)this.getActiveModel();
            WmiMathTableModel table = (WmiMathTableModel)active.getChild(0);
            WmiMathDocumentModel doc = table.getDocument();
            int i = 1;
            while (i < active.getChildCount()) {
                WmiMathTableModel.WmiMathTableRowModel row = new WmiMathTableModel.WmiMathTableRowModel(doc);
                WmiInlineMathModel inline = (WmiInlineMathModel)active.getChild(i);
                int j = 0;
                while (j < inline.getChildCount()) {
                    WmiMathTableModel.WmiMathTableDataModel cell = new WmiMathTableModel.WmiMathTableDataModel(doc, inline.getChild(j));
                    row.appendChild(cell);
                    row.addAttribute("Typesetting:-msemantics", "matrixrow");
                    ++j;
                }
                table.appendChild(row);
                ++i;
            }
            table.addAttribute("Typesetting:-msemantics", "matrix");
            active.removeChildren(1, active.getChildCount() - 1);
            this.setActiveModel(active);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateLambdaModel() throws WmiNoReadAccessException {
        WmiInlineMathModel active = (WmiInlineMathModel)this.getActiveModel();
        WmiCompositeModel parent = active.getParent();
        WmiMathDocumentModel doc = active.getDocument();
        WmiAttributeSet attributes = active.getAttributes();
        WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)attributes);
        try {
            WmiInlineMathModel inline = new WmiInlineMathModel(doc);
            WmiMathTokenModel lambda = WmiMathFactory.createMathIdentifierToken(doc, "&lambda;", context);
            WmiMathTokenModel applyF = WmiMathFactory.createMathOperatorToken(doc, "&ApplyFunction;", context);
            ArrayList<WmiModel> children = new ArrayList<WmiModel>();
            int i = 0;
            while (i < active.getChildCount() - 1) {
                WmiInlineMathModel bvar = (WmiInlineMathModel)active.getChild(i);
                children.add(bvar.getChild(0));
                ++i;
            }
            children.add(active.getChild(active.getChildCount() - 1));
            WmiMathFencedModel fenced = new WmiMathFencedModel(doc, children.toArray(new WmiModel[0]), context);
            inline.appendChild(lambda);
            inline.appendChild(applyF);
            inline.appendChild(fenced);
            inline.setParent(parent);
            inline.addAttribute("Typesetting:-msemantics", "lambda");
            this.setActiveModel(inline);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    public void updateOperatorModelAttributes(WmiMathOperatorModel operator, WmiCompositeModel parent) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            int index = 0;
            int form = 0;
            int i = 0;
            while (i < parent.getChildCount()) {
                if (parent.getChild(i) == operator || WmiModelUtil.isModelAncestorOfModel(parent.getChild(i), operator)) {
                    index = i;
                    break;
                }
                ++i;
            }
            form = index == 0 ? 0 : (index == parent.getChildCount() - 1 ? 2 : 1);
            WmiMathOperatorModel.WmiMathOperatorAttributeSet attrSet = (WmiMathOperatorModel.WmiMathOperatorAttributeSet)operator.getAttributes();
            WmiMathOperatorDictionary.installAttributes(operator, form);
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public String getActiveModelTag() {
        WmiModelTag tag = null;
        WmiModel model = this.getActiveModel();
        if (model != null) {
            tag = model.getTag();
        }
        return tag != null ? tag.getName() : null;
    }

    private ArrayList getMSpaceAttribute(String contents) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            if (!contents.equals("Tab")) {
                if (contents.equals("NewLine")) {
                    results.add("linebreak");
                    results.add("newline");
                } else if (contents.equals("IndentingNewLine")) {
                    results.add("linebreak");
                    results.add("indentingnewline");
                } else if (contents.equals("NoBreak")) {
                    results.add("linebreak");
                    results.add("nobreak");
                } else if (contents.equals("GoodBreak")) {
                    results.add("linebreak");
                    results.add("goodbreak");
                } else if (contents.equals("BadBreak")) {
                    results.add("linebreak");
                    results.add("badbreak");
                } else if (contents.equals("Space")) {
                    results.add("width");
                    results.add("1em");
                } else if (contents.equals("NonBreakingSpace") || contents.equals("nbsp")) {
                    results.add("width");
                    results.add("1em");
                    results.add("linebreak");
                    results.add("nobreak");
                } else if (contents.equals("ZeroWidthSpace")) {
                    results.add("width");
                    results.add("0em");
                } else if (contents.equals("VeryThinSpace")) {
                    results.add("width");
                    results.add("0.056em");
                } else if (contents.equals("ThinSpace")) {
                    results.add("width");
                    results.add("0.167em");
                } else if (contents.equals("MediumSpace")) {
                    results.add("width");
                    results.add("0.222em");
                } else if (contents.equals("ThickSpace")) {
                    results.add("width");
                    results.add("0.278em");
                } else if (contents.equals("NegativeVeryThinSpace")) {
                    results.add("width");
                    results.add("-0.056em");
                } else if (contents.equals("NegativeThinSpace")) {
                    results.add("width");
                    results.add("-0.167em");
                } else if (contents.equals("NegativeMediumSpace")) {
                    results.add("width");
                    results.add("-0.222em");
                } else if (contents.equals("NegativeThickSpace")) {
                    results.add("width");
                    results.add("-0.278em");
                }
            }
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
        return results;
    }

    @Override
    public boolean parse(Reader reader, WmiCompositeModel parent, int offset) throws WmiParseException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        boolean success = false;
        StringBuffer s = new StringBuffer();
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = bufferedReader.readLine();
            while (line != null) {
                s.append(line);
                line = bufferedReader.readLine();
                if (line == null) continue;
                line = " " + line;
            }
            String mathml = s.toString();
            mathml = mathml.replaceAll("&", "&amp;");
            mathml = mathml.replaceAll("&amp;amp;", "&amp;");
            if (s != null) {
                reader = new StringReader(mathml);
                success = super.parse(reader, parent, offset);
            }
        }
        catch (IOException ioe) {
            WmiErrorLog.log(ioe);
        }
        return success;
    }

    protected static class MathConjugateBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathConjugateBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiOverModel m = null;
            WmiOverModel over = (WmiOverModel)active.getChild(0);
            WmiModel second = active.getChild(1);
            if (second != null) {
                over.replaceChild(second, 0);
                over.replaceChild(WmiMathFactory.createMathOperatorToken(doc, "&conjugate0;", context), 1);
            }
            over.setParent(parent);
            over.addAttribute("Typesetting:-msemantics", "conjugate");
            m = over;
            return m;
        }
    }

    protected static class MathCurlBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathCurlBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiInlineMathModel inline;
            WmiMathTokenModel op1 = WmiMathFactory.createMathOperatorToken(doc, "&Del;", context);
            WmiMathTokenModel op2 = WmiMathFactory.createMathOperatorToken(doc, "&times;", context);
            active.replaceChild(op1, 0);
            active.addChild(op2, 1);
            if (active.getChild(2) instanceof WmiInlineMathModel && (inline = (WmiInlineMathModel)active.getChild(2)).getChildCount() > 1) {
                try {
                    WmiModel[] kids = new WmiModel[]{inline};
                    WmiMathFencedModel fenced = new WmiMathFencedModel(doc, kids, context);
                    active.replaceChild(fenced, 2);
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
            }
            active.addAttribute("Typesetting:-msemantics", "curl");
            return active;
        }
    }

    protected static class MathDeterminantBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathDeterminantBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathOperatorModel function = (WmiMathOperatorModel)active.getChild(0);
            function.replaceText("det", 0, function.getText().length());
            WmiMathTokenModel applyF = WmiMathFactory.createMathOperatorToken(doc, "&ApplyFunction;", context);
            active.addChild(applyF, 1);
            try {
                WmiModel[] kids = new WmiModel[]{active.getChild(2)};
                WmiMathFencedModel fenced = new WmiMathFencedModel(doc, kids, context);
                active.replaceChild(fenced, 2);
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
            }
            active.addAttribute("Typesetting:-msemantics", "determinant");
            return active;
        }
    }

    protected static class MathDiffBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathDiffBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiInlineMathModel m = active;
            if (active.getChildCount() == 2) {
                WmiInlineMathModel inline = (WmiInlineMathModel)active.getChild(0);
                inline.appendChild(active.getChild(1));
                inline.appendChild(WmiMathFactory.createMathOperatorToken(doc, "&prime;", context));
                inline.setParent(parent);
                m = inline;
            } else {
                WmiFractionModel fraction = new WmiFractionModel(doc, context);
                String degreeText = "";
                WmiInlineMathModel boundVar = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "bound-variable");
                WmiInlineMathModel degree = null;
                if (boundVar != null && (degree = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(boundVar, "Typesetting:-msemantics", "degree")) != null) {
                    degreeText = ((WmiMathTokenModel)degree.getChild(0)).getTokenContents();
                }
                WmiInlineMathModel num = new WmiInlineMathModel(doc);
                WmiMathTokenModel d1 = WmiMathFactory.createMathOperatorToken(doc, "&DifferentialD;", context);
                num.appendChild(d1);
                if (degree != null) {
                    WmiSuperscriptModel numSup = new WmiSuperscriptModel(doc);
                    numSup.replaceChild(boundVar.getChild(0), 0);
                    numSup.replaceChild(WmiMathFactory.createMathIdentifierToken(doc, degreeText, context), 1);
                    num.appendChild(numSup);
                }
                WmiInlineMathModel denom = new WmiInlineMathModel(doc);
                if (boundVar != null) {
                    WmiInlineMathModel inline = new WmiInlineMathModel(doc);
                    inline.appendChild(WmiMathFactory.createMathOperatorToken(doc, "&DifferentialD;", context));
                    WmiSuperscriptModel sup = new WmiSuperscriptModel(doc);
                    if (degree == null) {
                        inline.appendChild(boundVar.getChild(0));
                    } else {
                        sup.replaceChild(boundVar.getChild(0), 0);
                        sup.replaceChild(WmiMathFactory.createMathIdentifierToken(doc, degreeText, context), 1);
                        inline.appendChild(sup);
                    }
                    denom.appendChild(inline);
                    active.removeChild(boundVar);
                }
                fraction.replaceChild(num, 0);
                fraction.replaceChild(denom, 1);
                fraction.setParent(active);
                active.replaceChild(fraction, 0);
            }
            m.addAttribute("Typesetting:-msemantics", "diff");
            return m;
        }
    }

    protected static class MathDivergenceBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathDivergenceBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiInlineMathModel inline;
            WmiMathTokenModel op1 = WmiMathFactory.createMathOperatorToken(doc, "&Del;", context);
            WmiMathTokenModel op2 = WmiMathFactory.createMathOperatorToken(doc, "&sdot;", context);
            active.replaceChild(op1, 0);
            active.addChild(op2, 1);
            if (active.getChild(2) instanceof WmiInlineMathModel && (inline = (WmiInlineMathModel)active.getChild(2)).getChildCount() > 1) {
                try {
                    WmiModel[] kids = new WmiModel[]{inline};
                    WmiMathFencedModel fenced = new WmiMathFencedModel(doc, kids, context);
                    active.replaceChild(fenced, 2);
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
            }
            active.addAttribute("Typesetting:-msemantics", "divergence");
            return active;
        }
    }

    protected static class MathDivideBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathDivideBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiFractionModel m = null;
            WmiFractionModel fraction = (WmiFractionModel)active.getChild(0);
            WmiModel second = active.getChild(1);
            WmiModel third = active.getChild(2);
            if (second != null && third != null) {
                fraction.replaceChild(second, 0);
                fraction.replaceChild(third, 1);
                fraction.setParent(parent);
                m = fraction;
            }
            return m;
        }
    }

    protected static class MathExistsBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathExistsBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathOperatorModel exists = (WmiMathOperatorModel)active.getChild(0);
            exists.replaceText("&Exists;", 0, WmiMathMLTag.EXISTS.getName().length());
            int i = 1;
            while (i < active.getChildCount() - 1) {
                WmiModel child = active.getChild(i);
                WmiMathAttributeSet attrs = (WmiMathAttributeSet)child.getAttributesForRead();
                if (attrs.getAttribute("Typesetting:-msemantics") == "bound-variable") {
                    WmiMathTokenModel comma = WmiMathFactory.createMathOperatorToken(doc, ",", context);
                    active.addChild(comma, i + 1);
                    ++i;
                }
                ++i;
            }
            WmiMathTokenModel bar = WmiMathFactory.createMathOperatorToken(doc, "&verbar;", context);
            active.addChild(bar, active.getChildCount() - 1);
            active.addAttribute("Typesetting:-msemantics", "exists");
            return active;
        }
    }

    protected static class MathExpBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathExpBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiSuperscriptModel m = null;
            WmiSuperscriptModel exp = (WmiSuperscriptModel)active.getChild(0);
            WmiModel second = active.getChild(1);
            if (second != null) {
                WmiMathTokenModel e = WmiMathFactory.createMathIdentifierToken(doc, "&exponentiale;", context);
                exp.replaceChild(e, 0);
                exp.replaceChild(second, 1);
                exp.setParent(parent);
                m = exp;
            }
            return m;
        }
    }

    protected static class MathFencedBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathFencedBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathFencedModel fenced = (WmiMathFencedModel)active.getChild(0);
            WmiModel second = active.getChild(1);
            if (second != null) {
                fenced.appendChild(second);
                active.removeChild(second);
            }
            return active;
        }
    }

    protected static class MathForAllBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathForAllBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathOperatorModel forAll = (WmiMathOperatorModel)active.getChild(0);
            forAll.replaceText("&forall;", 0, "forall".length());
            int i = 1;
            while (i < active.getChildCount() - 1) {
                WmiModel child = active.getChild(i);
                WmiMathAttributeSet attrs = (WmiMathAttributeSet)child.getAttributesForRead();
                if (attrs.getAttribute("Typesetting:-msemantics") == "bound-variable") {
                    WmiMathTokenModel comma = WmiMathFactory.createMathOperatorToken(doc, ",", context);
                    active.addChild(comma, i + 1);
                    ++i;
                }
                ++i;
            }
            active.addAttribute("Typesetting:-msemantics", "forall");
            return active;
        }
    }

    protected static class MathIntegralBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathIntegralBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiInlineMathModel boundVar = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "bound-variable");
            while (boundVar != null) {
                String name = ((WmiMathTokenModel)boundVar.getChild(0)).getTokenContents();
                WmiInlineMathModel dx = new WmiInlineMathModel(doc);
                dx.appendChild(WmiMathFactory.createMathOperatorToken(doc, "&DifferentialD;", context));
                dx.appendChild(WmiMathFactory.createMathIdentifierToken(doc, name, context));
                active.appendChild(dx);
                active.removeChild(boundVar);
                boundVar = (WmiInlineMathModel)WmiModelUtil.findNextModel(active, boundVar, "Typesetting:-msemantics", "bound-variable");
            }
            ((WmiAbstractMathTokenModel)active.getChild(0)).replaceText("&int;", 0, "int".length());
            WmiInlineMathModel low = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "lowlimit");
            WmiInlineMathModel up = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "uplimit");
            if (low != null || up != null) {
                WmiInlineMathModel under = new WmiInlineMathModel(doc);
                WmiInlineMathModel over = new WmiInlineMathModel(doc);
                if (low != null) {
                    under.appendChild(low);
                    active.removeChild(low);
                }
                if (up != null) {
                    over.appendChild(up);
                    active.removeChild(up);
                }
                WmiUnderOverModel integral = new WmiUnderOverModel(doc, active.getChild(0), under, over, context);
                active.replaceChild(integral, 0);
            } else {
                WmiMathFencedModel interval = (WmiMathFencedModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "interval");
                if (interval != null) {
                    WmiInlineMathModel under = new WmiInlineMathModel(doc);
                    WmiInlineMathModel over = new WmiInlineMathModel(doc);
                    under.appendChild(interval.getChild(0));
                    over.appendChild(interval.getChild(1));
                    WmiUnderOverModel integral = new WmiUnderOverModel(doc, active.getChild(0), under, over, context);
                    active.replaceChild(integral, 0);
                    active.removeChild(interval);
                } else {
                    WmiInlineMathModel condition = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "condition");
                    if (condition != null) {
                        WmiInlineMathModel under = new WmiInlineMathModel(doc);
                        under.appendChild(condition);
                        WmiUnderModel integral = new WmiUnderModel(doc, active.getChild(0), under, context);
                        active.replaceChild(integral, 0);
                        active.removeChild(condition);
                    }
                }
            }
            active.addAttribute("Typesetting:-msemantics", "integral");
            return active;
        }
    }

    protected static class MathInverseBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathInverseBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiSuperscriptModel m = null;
            WmiSuperscriptModel inverse = (WmiSuperscriptModel)active.getChild(0);
            WmiModel second = active.getChild(1);
            if (second != null) {
                try {
                    inverse.replaceChild(second, 0);
                    WmiMathTokenModel num = WmiMathFactory.createMathNumericToken(doc, "-1", context);
                    WmiModel[] children = new WmiModel[]{num};
                    WmiMathFencedModel fence = new WmiMathFencedModel(doc, children, context);
                    inverse.replaceChild(fence, 1);
                    inverse.setParent(parent);
                    m = inverse;
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
            }
            return m;
        }
    }

    protected static class MathLaplacianBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathLaplacianBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiInlineMathModel inline;
            WmiMathTokenModel op = WmiMathFactory.createMathOperatorToken(doc, "&Del;", context);
            WmiMathTokenModel two = WmiMathFactory.createMathNumericToken(doc, "2", context);
            WmiMathModel[] kids = new WmiMathModel[]{op, two};
            WmiSuperscriptModel sup = new WmiSuperscriptModel(doc, kids, context);
            op.setParent(sup);
            two.setParent(sup);
            active.replaceChild(sup, 0);
            if (active.getChild(1) instanceof WmiInlineMathModel && (inline = (WmiInlineMathModel)active.getChild(2)).getChildCount() > 1) {
                try {
                    WmiModel[] k = new WmiModel[]{inline};
                    WmiMathFencedModel fenced = new WmiMathFencedModel(doc, k, context);
                    active.replaceChild(fenced, 2);
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
            }
            active.addAttribute("Typesetting:-msemantics", "laplacian");
            return active;
        }
    }

    protected static class MathLargeOpBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathLargeOpBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiUnderOverModel underOver = (WmiUnderOverModel)active.getChild(0);
            WmiMathTokenModel center = (WmiMathTokenModel)underOver.getChild(0);
            String opName = center.getTokenContents();
            WmiInlineMathModel exp = new WmiInlineMathModel(doc);
            if (opName.equals("lim")) {
                WmiInlineMathModel condition = (WmiInlineMathModel)active.getChild(2);
                if (condition.getChildCount() == 1 && condition.getChild(0) instanceof WmiNumericModel) {
                    WmiInlineMathModel var = (WmiInlineMathModel)active.getChild(1);
                    exp.appendChild(var.getChild(0));
                    exp.appendChild(WmiMathFactory.createMathOperatorToken(doc, "&rightarrow;", context));
                    exp.appendChild(((WmiInlineMathModel)active.getChild(2)).getChild(0));
                    underOver.replaceChild(exp, 1);
                    active.removeChildren(1, 2);
                } else {
                    exp.appendChild(active.getChild(2));
                    underOver.replaceChild(exp, 1);
                    active.removeChildren(1, 2);
                }
                condition.addAttribute("Typesetting:-msemantics", "condition");
                active.getChild(0).addAttribute("Typesetting:-msemantics", "limit");
                active.addAttribute("Typesetting:-msemantics", "limit");
            } else if (opName.equals("\u03a3") || opName.equals("\u03a0")) {
                WmiInlineMathModel boundVar = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "bound-variable");
                WmiInlineMathModel low = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "lowlimit");
                WmiInlineMathModel up = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "uplimit");
                if (low != null || up != null) {
                    WmiInlineMathModel under = new WmiInlineMathModel(doc);
                    WmiInlineMathModel over = new WmiInlineMathModel(doc);
                    if (low != null) {
                        under.appendChild(boundVar.getChild(0));
                        under.appendChild(WmiMathFactory.createMathOperatorToken(doc, "&equals;", context));
                        under.appendChild(low);
                        active.removeChild(low);
                    }
                    if (up != null) {
                        over.appendChild(up);
                        active.removeChild(up);
                    }
                    underOver.replaceChild(under, 1);
                    underOver.replaceChild(over, 2);
                } else {
                    WmiInlineMathModel condition = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "condition");
                    if (condition != null) {
                        WmiInlineMathModel under = new WmiInlineMathModel(doc);
                        under.appendChild(condition);
                        underOver.replaceChild(under, 1);
                        active.removeChild(condition);
                    }
                }
                active.removeChild(boundVar);
                if (opName.equals("\u03a3")) {
                    active.addAttribute("Typesetting:-msemantics", "sum");
                    active.getChild(0).addAttribute("Typesetting:-msemantics", "sum");
                } else {
                    active.addAttribute("Typesetting:-msemantics", "product");
                    active.getChild(0).addAttribute("Typesetting:-msemantics", "product");
                }
            }
            return active;
        }
    }

    protected static class MathLogBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathLogBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            if (active.getChildCount() == 3) {
                WmiSubscriptModel sub = new WmiSubscriptModel(doc);
                sub.replaceChild(active.getChild(0), 0);
                sub.replaceChild(active.getChild(1), 1);
                sub.addAttribute("Typesetting:-msemantics", "log");
                active.replaceChild(sub, 0);
                active.removeChild(1);
            }
            active.addAttribute("Typesetting:-msemantics", "log");
            return active;
        }
    }

    protected static class MathPartialDiffBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathPartialDiffBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            if (WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "bound-variable") == null) {
                try {
                    WmiSubscriptModel sub = new WmiSubscriptModel(doc);
                    sub.replaceChild(WmiMathFactory.createMathOperatorToken(doc, "D", context), 0);
                    WmiMathFencedModel fenced = (WmiMathFencedModel)active.getChild(1);
                    WmiMathFencedModel.WmiFencedAttributeSet attrs = (WmiMathFencedModel.WmiFencedAttributeSet)fenced.getAttributes();
                    attrs.addAttribute("open", "");
                    attrs.addAttribute("close", "");
                    fenced.setAttributes(attrs);
                    sub.replaceChild(fenced, 1);
                    ((WmiInlineMathModel)active.getChild(0)).appendChild(sub);
                    WmiModel[] children = new WmiModel[]{active.getChild(2)};
                    WmiMathFencedModel f2 = new WmiMathFencedModel(doc, children, context);
                    ((WmiInlineMathModel)active.getChild(0)).appendChild(f2);
                    active.removeChildren(1, 2);
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
            } else {
                WmiMathModel degreeModel = null;
                int i = 0;
                while (i < active.getChildCount()) {
                    WmiMathModel child = (WmiMathModel)active.getChild(i);
                    WmiMathAttributeSet attrs = (WmiMathAttributeSet)child.getAttributesForRead();
                    if (attrs.getAttribute("Typesetting:-msemantics") == "degree") {
                        degreeModel = child;
                    }
                    ++i;
                }
                WmiFractionModel fraction = new WmiFractionModel(doc, context);
                WmiInlineMathModel numerator = new WmiInlineMathModel(doc);
                WmiInlineMathModel denominator = new WmiInlineMathModel(doc);
                int boundVarCounter = 0;
                WmiInlineMathModel boundVar = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "bound-variable");
                while (boundVar != null) {
                    ++boundVarCounter;
                    denominator.appendChild(WmiMathFactory.createMathOperatorToken(doc, "&PartialD;", context));
                    WmiIdentifierModel varName = (WmiIdentifierModel)WmiModelUtil.findFirstDescendantOfTag((WmiModel)boundVar, WmiModelTag.MATH_IDENTIFIER);
                    WmiInlineMathModel degree = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(boundVar, "Typesetting:-msemantics", "degree");
                    WmiSuperscriptModel varSup = new WmiSuperscriptModel(doc);
                    varSup.replaceChild(varName, 0);
                    if (degree == null) {
                        if (degreeModel != null) {
                            varSup.replaceChild(degreeModel, 1);
                        } else {
                            varSup.replaceChild(WmiMathFactory.createMathIdentifierToken(doc, "", context), 1);
                        }
                    } else {
                        varSup.replaceChild(degree, 1);
                    }
                    denominator.appendChild(varSup);
                    active.removeChild(boundVar);
                    boundVar = (WmiInlineMathModel)WmiModelUtil.findNextModel(active, boundVar, "Typesetting:-msemantics", "bound-variable");
                }
                WmiSuperscriptModel numSuper = new WmiSuperscriptModel(doc);
                numSuper.replaceChild(WmiMathFactory.createMathOperatorToken(doc, "&PartialD;", context), 0);
                if (degreeModel != null) {
                    numSuper.replaceChild(degreeModel, 1);
                } else {
                    numSuper.replaceChild(WmiMathFactory.createMathNumericToken(doc, String.valueOf(boundVarCounter), context), 1);
                }
                numerator.appendChild(numSuper);
                fraction.replaceChild(numerator, 0);
                fraction.replaceChild(denominator, 1);
                fraction.setParent(active);
                ((WmiInlineMathModel)active.getChild(0)).appendChild(fraction);
            }
            WmiInlineMathModel degree = (WmiInlineMathModel)WmiModelUtil.findFirstDescendantWithAttribute(active, "Typesetting:-msemantics", "degree");
            if (degree != null) {
                active.removeChild(degree);
            }
            active.addAttribute("Typesetting:-msemantics", "partialdiff");
            return active;
        }
    }

    protected static class MathPowerBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathPowerBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiSuperscriptModel m = null;
            WmiSuperscriptModel power = (WmiSuperscriptModel)active.getChild(0);
            WmiModel second = active.getChild(1);
            WmiModel third = active.getChild(2);
            if (second != null && third != null) {
                if (second instanceof WmiInlineMathModel) {
                    try {
                        WmiModel[] kids = new WmiModel[]{second};
                        WmiMathFencedModel fenced = new WmiMathFencedModel(doc, kids, context);
                        power.replaceChild(fenced, 0);
                    }
                    catch (WmiInvalidModelInitializationException e) {
                        WmiErrorLog.log(e);
                    }
                } else {
                    power.replaceChild(second, 0);
                }
                power.replaceChild(third, 1);
                power.setParent(parent);
                m = power;
            }
            return m;
        }
    }

    protected static class MathQuotientBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathQuotientBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathFencedModel fenced = (WmiMathFencedModel)active.getChild(0);
            WmiInlineMathModel inline = new WmiInlineMathModel(doc);
            inline.appendChild(active.getChild(1));
            WmiMathTokenModel sol = WmiMathFactory.createMathOperatorToken(doc, "&sol;", context);
            inline.appendChild(sol);
            inline.appendChild(active.getChild(2));
            fenced.appendChild(inline);
            active.removeChildren(1, 2);
            return active;
        }
    }

    protected static class MathRootBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathRootBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiRootModel m = null;
            WmiRootModel root = (WmiRootModel)active.getChild(0);
            if (active.getChildCount() == 3) {
                root.replaceChild(active.getChild(2), 0);
                root.replaceChild(active.getChild(1), 1);
            } else {
                root = new WmiRootModel.WmiSquareRootModel(doc, root.getChild(1), context);
                root.replaceChild(active.getChild(1), 0);
            }
            root.setParent(parent);
            m = root;
            return m;
        }
    }

    protected static class MathSelectorBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathSelectorBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiSubscriptModel sub = new WmiSubscriptModel(doc);
            sub.addAttribute("Typesetting:-msemantics", "selector");
            sub.replaceChild(active.getChild(1), 0);
            try {
                WmiMathFencedModel fenced = new WmiMathFencedModel(doc, new WmiModel[0], context);
                fenced.addAttribute("open", "");
                fenced.addAttribute("close", "");
                int i = 2;
                while (i < active.getChildCount()) {
                    fenced.appendChild(active.getChild(i));
                    ++i;
                }
                sub.replaceChild(fenced, 1);
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
            }
            active.replaceChild(sub, 0);
            active.removeChildren(1, active.getChildCount() - 1);
            return active;
        }
    }

    protected static class MathStatisticsBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathStatisticsBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            try {
                WmiMathOperatorModel function = (WmiMathOperatorModel)active.getChild(0);
                String name = function.getText();
                ArrayList<WmiModel> parameters = new ArrayList<WmiModel>();
                int i = 1;
                while (i < active.getChildCount()) {
                    parameters.add(active.getChild(i));
                    ++i;
                }
                WmiMathTokenModel apply = WmiMathFactory.createMathOperatorToken(doc, "&ApplyFunction;", context);
                WmiMathFencedModel fenced = new WmiMathFencedModel(doc, parameters.toArray(new WmiModel[0]), context);
                if (name.equals(WmiMathMLTag.MEAN.getName())) {
                    fenced.addAttribute("open", "&lang;");
                    fenced.addAttribute("close", "&rang;");
                    active.replaceChild(fenced, 0);
                    active.removeChild(1);
                    active.addAttribute("Typesetting:-msemantics", "mean");
                } else if (name.equals(WmiMathMLTag.SDEV.getName())) {
                    function.replaceText("&sigma;", 0, name.length());
                    active.replaceChild(apply, 1);
                    active.appendChild(fenced);
                    active.addAttribute("Typesetting:-msemantics", "sdev");
                } else if (name.equals(WmiMathMLTag.VARIANCE.getName())) {
                    WmiMathTokenModel squared = WmiMathFactory.createMathNumericToken(doc, "2", context);
                    WmiMathModel[] kids = new WmiMathModel[]{fenced, squared};
                    WmiSuperscriptModel sup = new WmiSuperscriptModel(doc, kids, context);
                    function.replaceText("&sigma;", 0, name.length());
                    active.replaceChild(apply, 1);
                    active.appendChild(sup);
                    active.addAttribute("Typesetting:-msemantics", "variance");
                } else if (name.equals(WmiMathMLTag.MEDIAN.getName())) {
                    active.replaceChild(apply, 1);
                    active.appendChild(fenced);
                    active.addAttribute("Typesetting:-msemantics", "median");
                } else if (name.equals(WmiMathMLTag.MODE.getName())) {
                    active.replaceChild(apply, 1);
                    active.appendChild(fenced);
                    active.addAttribute("Typesetting:-msemantics", "mode");
                } else if (name.equals(WmiMathMLTag.MOMENT.getName())) {
                    fenced.removeChildren(0, fenced.getChildCount());
                    fenced.addAttribute("open", "&lang;");
                    fenced.addAttribute("close", "&rang;");
                    WmiSuperscriptModel sup = new WmiSuperscriptModel(doc);
                    WmiModel momentaboutModel = null;
                    int i2 = 1;
                    while (i2 < active.getChildCount()) {
                        WmiMathAttributeSet attrs = (WmiMathAttributeSet)active.getChild(i2).getAttributesForRead();
                        String semantics = (String)attrs.getAttribute("Typesetting:-msemantics");
                        if (semantics == "degree") {
                            sup.replaceChild(active.getChild(i2), 1);
                        } else if (semantics == "momentabout") {
                            momentaboutModel = active.getChild(i2);
                        } else {
                            sup.replaceChild(active.getChild(i2), 0);
                        }
                        ++i2;
                    }
                    fenced.appendChild(sup);
                    active.replaceChild(fenced, 0);
                    if (momentaboutModel != null) {
                        active.replaceChild(momentaboutModel, 1);
                        active.removeChildren(2, active.getChildCount() - 2);
                    } else {
                        active.removeChildren(1, active.getChildCount() - 1);
                    }
                    active.addAttribute("Typesetting:-msemantics", "moment");
                }
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
            }
            return active;
        }
    }

    protected static class MathTendsToBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathTendsToBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiModel left = active.getChild(1);
            active.replaceChild(active.getChild(0), 1);
            active.replaceChild(left, 0);
            active.addAttribute("Typesetting:-msemantics", "tendsto");
            return active;
        }
    }

    protected static class MathTransposeBuilder
    implements WmiMathMLParserModelBuilder {
        protected MathTransposeBuilder() {
        }

        @Override
        public WmiModel createModel(WmiMathDocumentModel doc, WmiMathContext context, WmiCompositeModel parent, WmiInlineMathModel active) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiSuperscriptModel m = null;
            WmiSuperscriptModel transpose = (WmiSuperscriptModel)active.getChild(0);
            WmiModel second = active.getChild(1);
            if (second != null) {
                WmiMathTokenModel t = WmiMathFactory.createMathIdentifierToken(doc, "T", context);
                transpose.replaceChild(second, 0);
                transpose.replaceChild(t, 1);
                transpose.setParent(parent);
                m = transpose;
            }
            return m;
        }
    }

    public static class WmiMathMLDeclaration {
        private String type;
        private int nargs;
        private String occurence;
        private WmiInlineMathModel definition;

        public void setType(String type) {
            this.type = type;
        }

        public void setNargs(int nargs) {
            this.nargs = nargs;
        }

        public void setOccurence(String occurence) {
            this.occurence = occurence;
        }

        public void setDefinition(WmiInlineMathModel definition) {
            this.definition = definition;
        }
    }
}

