/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLTokenImportAction;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.view.math.WmiMathOperatorView;
import java.awt.Color;
import org.xml.sax.Attributes;

public class WmiMathMLPresentationMstyleImportAction
extends WmiMathMLTokenImportAction {
    private static String[] dimensionAttributes = new String[7];

    static {
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[0] = "veryverythinmathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[1] = "verythinmathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[2] = "thinmathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[3] = "mediummathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[4] = "thickmathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[5] = "verythickmathspace";
        WmiMathMLPresentationMstyleImportAction.dimensionAttributes[6] = "veryverythickmathspace";
    }

    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathStyleModel m = null;
        try {
            try {
                WmiModelLock.writeLock(doc, true);
                m = new WmiMathStyleModel(doc, new WmiModel[0], new WmiMathStyleModel.WmiMathStyleAttributeSet());
            }
            catch (WmiInvalidModelInitializationException imie) {
                WmiErrorLog.log(imie);
                WmiModelLock.writeUnlock(doc);
            }
        }
        finally {
            WmiModelLock.writeUnlock(doc);
        }
        return m;
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (parser != null) {
            ((WmiMathMLImportParser)parser).updateStyleModel();
            super.endAction(parser, inputSource);
        }
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String mathbackground;
        String mathcolor;
        String scriptminsize;
        String scriptsizemultiplierString;
        String background;
        super.processAttributes(parser, source, model);
        WmiAttributeSet attributes = model.getAttributes();
        WmiMathStyleModel.WmiMathStyleAttributeSet charAttr = null;
        if (attributes instanceof WmiMathAttributeSet) {
            charAttr = (WmiMathStyleModel.WmiMathStyleAttributeSet)attributes;
        }
        if ((background = source.getValue("background")) != null) {
            background = background.toLowerCase();
            Color color = WmiMathMLPresentationMstyleImportAction.parseColor(background, Color.WHITE);
            charAttr.setBackground(color.getRGB());
            charAttr.setExtendedStyle(32);
        }
        int i = 0;
        while (i < dimensionAttributes.length) {
            String attrName = dimensionAttributes[i];
            String attrValue = source.getValue(attrName);
            if (attrValue != null) {
                attrValue = attrValue.toLowerCase();
                if (attrName.equals("veryverythinmathspace")) {
                    charAttr.setVeryVeryThinMathSpace(attrValue);
                } else if (attrName.equals("verythinmathspace")) {
                    charAttr.setVeryThinMathSpace(attrValue);
                } else if (attrName.equals("thinmathspace")) {
                    charAttr.setThinMathSpace(attrValue);
                } else if (attrName.equals("mediummathspace")) {
                    charAttr.setMediumMathSpace(attrValue);
                } else if (attrName.equals("thickmathspace")) {
                    charAttr.setThickMathSpace(attrValue);
                } else if (attrName.equals("verythickmathspace")) {
                    charAttr.setVeryThickMathSpace(attrValue);
                } else if (attrName.equals("veryverythickmathspace")) {
                    charAttr.setVeryVeryThickMathSpace(attrValue);
                }
                WmiMathOperatorView.updateOperatorSpaceDimension(attrName, attrValue);
            }
            ++i;
        }
        String scriptlevel = source.getValue("scriptlevel");
        if (scriptlevel != null) {
            scriptlevel = scriptlevel.toLowerCase();
            charAttr.setScriptLevel(scriptlevel);
        }
        if ((scriptsizemultiplierString = source.getValue("scriptsizemultiplier")) != null) {
            float scriptsizemultiplier = Float.parseFloat(scriptsizemultiplierString);
            charAttr.setScriptSizeMultiplier(scriptsizemultiplier);
        }
        if ((scriptminsize = source.getValue("scriptminsize")) != null) {
            scriptminsize = scriptminsize.toLowerCase();
            charAttr.setScriptMinSize(scriptminsize);
        }
        if ((mathcolor = source.getValue("mathcolor")) != null) {
            mathcolor = mathcolor.toLowerCase();
            Color color = WmiMathMLPresentationMstyleImportAction.parseColor(mathcolor, Color.BLACK);
            charAttr.setForeground(color.getRGB());
        }
        if ((mathbackground = source.getValue("mathbackground")) != null) {
            mathbackground = mathbackground.toLowerCase();
            Color color = WmiMathMLPresentationMstyleImportAction.parseColor(mathbackground, Color.WHITE);
            charAttr.setBackground(color.getRGB());
        }
        int i2 = 0;
        while (i2 < source.getLength()) {
            String attrName = source.getQName(i2);
            String attrValue = source.getValue(attrName);
            if (attrValue != null) {
                if (!attrName.equals("fontfamily")) {
                    attrValue = attrValue.toLowerCase();
                }
                charAttr.addAttribute(attrName, attrValue);
            }
            ++i2;
        }
        model.setAttributes(charAttr);
    }
}

