/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportAction;
import com.maplesoft.mathdoc.io.mathml.WmiMathMLImportParser;
import com.maplesoft.mathdoc.io.xml.WmiXMLBlockImportAction;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import org.xml.sax.Attributes;

public class WmiMathMLPresentationMtableImportAction
extends WmiMathMLImportAction {
    @Override
    public WmiModel createModel(WmiMathDocumentModel doc) {
        WmiMathTableModel m = null;
        try {
            WmiModelLock.writeLock(doc, true);
            m = new WmiMathTableModel(doc);
        }
        finally {
            WmiModelLock.writeUnlock(doc);
        }
        return m;
    }

    @Override
    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        String minLabelSpacing;
        String side;
        String displayStyle;
        String equalCols;
        String equalRows;
        String frameSpacing;
        String frame;
        String colLines;
        String rowLines;
        String colSpacing;
        String rowSpacing;
        String width;
        String columnWidth;
        String alignmentScope;
        String groupAlign;
        String columnAlign;
        String rowAlign;
        super.processAttributes(parser, source, model);
        WmiMathTableModel.WmiMathTableAttributeSet attrs = new WmiMathTableModel.WmiMathTableAttributeSet();
        String align = source.getValue("align");
        if (align != null) {
            attrs.addAttribute("align", align.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.ALIGN_FLAG);
        }
        if ((rowAlign = source.getValue("rowalign")) != null) {
            attrs.addAttribute("rowalign", rowAlign.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.ROW_ALIGN_FLAG);
        }
        if ((columnAlign = source.getValue("columnalign")) != null) {
            attrs.addAttribute("columnalign", columnAlign.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.COLUMN_ALIGN_FLAG);
        }
        if ((groupAlign = source.getValue("groupalign")) != null) {
            attrs.addAttribute("groupalign", groupAlign.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.GROUP_ALIGN_FLAG);
        }
        if ((alignmentScope = source.getValue("alignmentscope")) != null) {
            attrs.addAttribute("alignmentscope", new Boolean(alignmentScope.toLowerCase()));
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.ALIGNMENT_SCOPE_FLAG);
        }
        if ((columnWidth = source.getValue("columnwidth")) != null) {
            attrs.addAttribute("columnwidth", columnWidth.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.COLUMN_WIDTH_FLAG);
        }
        if ((width = source.getValue("width")) != null) {
            attrs.addAttribute("width", width.toLowerCase());
        }
        if ((rowSpacing = source.getValue("rowspacing")) != null) {
            attrs.addAttribute("rowspacing", rowSpacing.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.ROW_SPACING_FLAG);
        }
        if ((colSpacing = source.getValue("columnspacing")) != null) {
            attrs.addAttribute("columnspacing", colSpacing.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.COLUMN_SPACING_FLAG);
        }
        if ((rowLines = source.getValue("rowlines")) != null) {
            attrs.addAttribute("rowlines", rowLines.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.ROW_LINES_FLAG);
        }
        if ((colLines = source.getValue("columnlines")) != null) {
            attrs.addAttribute("columnlines", colLines.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.COLUMN_LINES_FLAG);
        }
        if ((frame = source.getValue("frame")) != null) {
            attrs.addAttribute("frame", frame.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.FRAME_FLAG);
        }
        if ((frameSpacing = source.getValue("framespacing")) != null) {
            attrs.addAttribute("framespacing", frameSpacing.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.FRAME_SPACING_FLAG);
        }
        if ((equalRows = source.getValue("equalrows")) != null) {
            attrs.addAttribute("equalrows", new Boolean(equalRows.toLowerCase()));
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.EQUAL_ROWS_FLAG);
        }
        if ((equalCols = source.getValue("equalcolumns")) != null) {
            attrs.addAttribute("equalcolumns", new Boolean(equalCols.toLowerCase()));
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.EQUAL_COLUMNS_FLAG);
        }
        if ((displayStyle = source.getValue("displaystyle")) != null) {
            attrs.addAttribute("displaystyle", new Boolean(displayStyle.toLowerCase()));
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.DISPLAY_STYLE_FLAG);
        }
        if ((side = source.getValue("side")) != null) {
            attrs.addAttribute("side", side.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.SIDE_FLAG);
        }
        if ((minLabelSpacing = source.getValue("minlabelspacing")) != null) {
            attrs.addAttribute("minlabelspacing", minLabelSpacing.toLowerCase());
            ((WmiAbstractArrayCompositeMathModel)model).setModifiedFlag(WmiAbstractArrayCompositeMathModel.MIN_LABEL_SPACING_FLAG);
        }
        model.setAttributes(attrs);
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (parser != null) {
            try {
                ((WmiMathMLImportParser)parser).updateTableModel();
            }
            catch (WmiModelIndexOutOfBoundsException miobe) {
                WmiErrorLog.log(miobe);
            }
            super.endAction(parser, inputSource);
        }
    }

    public static class WmiMathMLPresentationMlabeledtrImportAction
    extends WmiMathMLPresentationMtrImportAction {
        @Override
        public WmiModel createModel(WmiMathDocumentModel doc) {
            return new WmiMathTableModel.WmiMathTableLabeledRowModel(doc);
        }
    }

    public static class WmiMathMLPresentationMtdImportAction
    extends WmiXMLBlockImportAction {
        @Override
        public WmiModel createModel(WmiMathDocumentModel doc) {
            return new WmiMathTableModel.WmiMathTableDataModel(doc, new WmiInlineMathModel(doc));
        }

        @Override
        public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            String columnSpan;
            String rowSpan;
            String groupAlign;
            String columnAlign;
            super.processAttributes(parser, source, model);
            WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet attrs = new WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet();
            String rowAlign = source.getValue("rowalign");
            if (rowAlign != null) {
                attrs.addAttribute("rowalign", rowAlign.toLowerCase());
            }
            if ((columnAlign = source.getValue("columnalign")) != null) {
                attrs.addAttribute("columnalign", columnAlign.toLowerCase());
            }
            if ((groupAlign = source.getValue("groupalign")) != null) {
                attrs.addAttribute("groupalign", groupAlign.toLowerCase());
            }
            if ((rowSpan = source.getValue("rowspan")) != null) {
                attrs.addAttribute("rowspan", rowSpan.toLowerCase());
            }
            if ((columnSpan = source.getValue("columnspan")) != null) {
                attrs.addAttribute("columnspan", columnSpan.toLowerCase());
            }
            model.setAttributes(attrs);
        }

        @Override
        public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            if (parser != null) {
                try {
                    ((WmiMathMLImportParser)parser).updateTableDataModel();
                }
                catch (WmiModelIndexOutOfBoundsException miobe) {
                    WmiErrorLog.log(miobe);
                }
                super.endAction(parser, inputSource);
            }
        }
    }

    public static class WmiMathMLPresentationMtrImportAction
    extends WmiXMLBlockImportAction {
        @Override
        public WmiModel createModel(WmiMathDocumentModel doc) {
            return new WmiMathTableModel.WmiMathTableRowModel(doc);
        }

        @Override
        public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
            String groupAlign;
            String columnAlign;
            super.processAttributes(parser, source, model);
            WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet attrs = new WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet();
            String rowAlign = source.getValue("rowalign");
            if (rowAlign != null) {
                attrs.addAttribute("rowalign", rowAlign.toLowerCase());
            }
            if ((columnAlign = source.getValue("columnalign")) != null) {
                attrs.addAttribute("columnalign", columnAlign.toLowerCase());
            }
            if ((groupAlign = source.getValue("groupalign")) != null) {
                attrs.addAttribute("groupalign", groupAlign.toLowerCase());
            }
            model.setAttributes(attrs);
        }
    }
}

