/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.html.WmiHTMLFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathActionAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import java.io.IOException;

public class WmiMathMLActionExportAction
extends WmiMathMLExportAction {
    @Override
    public void openModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        WmiMathActionModel action = (WmiMathActionModel)model;
        formatter.writeBinary("<maction");
        try {
            formatter.writeText(this.exportAttributes(WmiMathActionAttributeSet.MACTION_ATTRIBUTE_KEY_SET, (WmiMathActionAttributeSet)action.getAttributes()));
            formatter.writeBinary(">");
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    @Override
    public void closeModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        formatter.writeBinary("</maction>");
    }

    protected String exportAttributes(String[] attrNames, WmiMathActionAttributeSet attrSet) {
        StringBuffer attr = new StringBuffer();
        if (exportAttributes) {
            int i = 0;
            while (i < attrNames.length) {
                String attrName = attrNames[i];
                if (attrSet.getAttribute(attrName) != null) {
                    attr.append(" " + attrName + "='" + WmiHTMLFormatter.translateAttribute(attrSet.getAttribute(attrName)) + "'");
                }
                ++i;
            }
        }
        return attr.toString();
    }
}

