/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiIdentifierModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.io.IOException;

public class WmiMathMLIdentifierExportAction
extends WmiMathMLExportAction {
    @Override
    public void openModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        try {
            WmiInlineMathModel im;
            WmiCompositeModel parent;
            WmiIdentifierModel identifier = (WmiIdentifierModel)model;
            if (WmiModelUtil.isEmptyIdentifierModel(model) && (parent = model.getParent()) instanceof WmiInlineMathModel && (im = (WmiInlineMathModel)parent).getChildCount() > 1) {
                return;
            }
            formatter.writeBinary("<mi");
            formatter.writeText(this.exportAttributes(WmiMathAttributeSet.MATHML_ATTR_KEYS, (WmiAbstractArrayAttributeSet)((WmiMathAttributeSet)identifier.getAttributes())));
            formatter.writeBinary(">");
            String label = identifier.getSemanticLabel();
            if (label != null) {
                if (label.startsWith("&") && label.endsWith(";")) {
                    formatter.writeBinary(label);
                } else {
                    StringBuffer buf = new StringBuffer();
                    int i = 0;
                    while (i < label.length()) {
                        String e = WmiMathEntityNameMapper.getEntityName(label.charAt(i));
                        if (e != null && label.charAt(i) > '\u007f') {
                            buf.append("&" + e + ";");
                        } else {
                            buf.append(label.charAt(i));
                        }
                        ++i;
                    }
                    StringBuffer htmlSafe = new StringBuffer();
                    WmiMathFormatter.makeHTMLSafe(buf.toString(), htmlSafe);
                    formatter.writeBinary(htmlSafe.toString());
                }
            }
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    @Override
    public void closeModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        try {
            WmiInlineMathModel im;
            WmiCompositeModel parent;
            if (WmiModelUtil.isEmptyIdentifierModel(model) && (parent = model.getParent()) instanceof WmiInlineMathModel && (im = (WmiInlineMathModel)parent).getChildCount() > 1) {
                return;
            }
            formatter.writeBinary("</mi>");
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    @Override
    protected boolean enableExport(String attributeName, Object value) {
        boolean export;
        boolean bl = export = value != null;
        if (export) {
            String defaultValue = (String)mathmlAttributeList.get(attributeName);
            if (attributeName.equals("mathvariant")) {
                defaultValue = "italic";
            }
            export = !value.toString().equals(defaultValue);
        }
        return export;
    }
}

