/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.html.WmiHTMLFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathStyleModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import java.io.IOException;

public class WmiMathMLMathExportAction
extends WmiMathMLExportAction {
    public static final String NAME_SPACE = "http://www.w3.org/1998/Math/MathML";
    private static final String OUTPUT_STYLE = "2D Output";

    @Override
    public void openModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        formatter.writeBinary("<math xmlns='http://www.w3.org/1998/Math/MathML'>");
        try {
            boolean isInOutput;
            WmiCompositeModel wrapper = (WmiCompositeModel)model;
            boolean bl = isInOutput = ((WmiFontAttributeSet)wrapper.getAttributes()).getStyleName() != null && ((WmiFontAttributeSet)wrapper.getAttributes()).getStyleName().equals(OUTPUT_STYLE);
            if (!isInOutput && wrapper.getChildCount() == 1 && wrapper.getChild(0).getTag() == WmiModelTag.MATH_ROW) {
                formatter.writeBinary(WmiMathMLMathExportAction.exportAttributesAsMStyle(WmiFontAttributeSet.ATTRIBUTE_KEYS, wrapper.getChild(0)));
            } else {
                formatter.writeBinary(WmiMathMLMathExportAction.exportAttributesAsMStyle(WmiFontAttributeSet.ATTRIBUTE_KEYS, wrapper));
            }
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    @Override
    public void closeModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        formatter.writeBinary("</mstyle>");
        formatter.writeBinary("</math>");
    }

    public static String exportAttributesAsMStyle(WmiAttributeKey[] attrNames, WmiModel model) throws WmiNoReadAccessException {
        WmiFontAttributeSet attrSet = (WmiFontAttributeSet)model.getAttributesForRead();
        if (attrSet instanceof WmiMathStyleModel.WmiMathStyleAttributeSet) {
            return "";
        }
        StringBuffer attr = new StringBuffer();
        attr.append("<mstyle ");
        int i = 0;
        while (i < attrNames.length) {
            WmiAttributeKey attrName = attrNames[i];
            boolean bold = false;
            boolean italic = false;
            if (attrName.equals(WmiFontAttributeSet.FAMILY_KEY)) {
                attr.append("fontfamily='" + attrSet.getAttribute(attrName) + "' ");
            } else if (attrName.equals(WmiFontAttributeSet.SIZE_KEY)) {
                attr.append("mathsize='" + attrSet.getAttribute(attrName) + "' ");
            } else if (attrName.equals(WmiFontAttributeSet.BOLD_KEY)) {
                if (attrName.getBooleanValue(attrSet)) {
                    bold = true;
                }
            } else if (attrName.equals(WmiFontAttributeSet.ITALIC_KEY)) {
                if (attrName.getBooleanValue(attrSet)) {
                    italic = true;
                }
            } else if (attrName.equals(WmiFontAttributeSet.FOREGROUND_KEY)) {
                attr.append("mathcolor='" + WmiHTMLFormatter.translateAttribute(attrSet.getAttribute(attrName)) + "' ");
            }
            if (bold && italic) {
                attr.append("mathvariant='bold-italic' ");
            } else if (bold) {
                attr.append("mathvariant='bold' ");
            } else if (italic) {
                attr.append("mathvariant='italic' ");
            }
            ++i;
        }
        if (!(model instanceof WmiMathWrapperModel && ((WmiMathWrapperModel)model).getChild(0) instanceof WmiMathStyleModel || model instanceof WmiMathStyleModel)) {
            attr.append("veryverythinmathspace='0.0555556em' ");
            attr.append("verythinmathspace='0.111111em' ");
            attr.append("thinmathspace='0.166667em' ");
            attr.append("mediummathspace='0.222222em' ");
            attr.append("thickmathspace='0.277778em' ");
            attr.append("verythickmathspace='0.333333em' ");
            attr.append("veryverythickmathspace='0.388889em' ");
            attr.append("scriptlevel='0' ");
            attr.append("scriptsizemultiplier='0.71' ");
            attr.append("scriptminsize='" + WmiMathStyleModel.WmiMathStyleAttributeSet.DEFAULT_SCRIPTMINSIZE + "'");
        }
        if (!(model instanceof WmiMathWrapperModel) || !(((WmiMathWrapperModel)model).getChild(0) instanceof WmiMathStyleModel)) {
            attr.append(">");
        }
        return attr.toString();
    }
}

