/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.util.WmiMathEntityNameMapper;
import java.io.IOException;

public class WmiMathMLOperatorExportAction
extends WmiMathMLExportAction {
    @Override
    public void openModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        WmiMathOperatorModel operator = (WmiMathOperatorModel)model;
        formatter.writeBinary("<mo");
        try {
            formatter.writeText(this.exportAttributes(WmiMathAttributeSet.MATHML_ATTR_KEYS, (WmiAbstractArrayAttributeSet)((WmiMathAttributeSet)operator.getAttributes())));
            formatter.writeText(this.exportAttributes(WmiMathOperatorModel.WmiMathOperatorAttributeSet.ATTRIBUTES, (WmiAbstractArrayAttributeSet)((WmiMathOperatorModel.WmiMathOperatorAttributeSet)operator.getAttributes())));
            String label = operator.getSemanticLabel();
            if (label.equals("&uminus0;")) {
                label = "&minus;";
            } else if (label.equals(" ")) {
                label = "&#32;";
            }
            if (label.length() == 0) {
                formatter.writeBinary(">");
                formatter.writeText(operator.getTokenContents());
            } else if (label.length() > 1 || WmiMathEntityNameMapper.getEntityName(label.charAt(0)) == null) {
                if (label.length() == 1 && (label.charAt(0) == '\u23a2' || label.charAt(0) == '\u23a5')) {
                    formatter.writeBinary(">|");
                } else if (label.length() == 1 && label.charAt(0) == '\u0305') {
                    formatter.writeBinary(">&macr;");
                } else if (label.equals("<>")) {
                    formatter.writeBinary(">&lt;&gt;");
                } else if (label.equals("<=")) {
                    formatter.writeBinary(">&lt;&equals;");
                } else if (label.equals(">=")) {
                    formatter.writeBinary(">&gt;&equals;");
                } else {
                    formatter.writeBinary(">" + label);
                }
            } else {
                StringBuffer htmlSafe = new StringBuffer();
                WmiMathFormatter.makeHTMLSafe(WmiMathEntityNameMapper.getEntityName(label.charAt(0)), htmlSafe);
                formatter.writeBinary(">&" + htmlSafe + ";");
            }
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    @Override
    protected boolean enableExport(String attributeName, Object value) {
        boolean export = super.enableExport(attributeName, value);
        if (export) {
            export = !value.toString().equals("unset");
        }
        return export;
    }

    @Override
    public void closeModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        formatter.writeBinary("</mo>");
    }
}

