/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.mathml.export;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathFormatter;
import com.maplesoft.mathdoc.io.mathml.export.WmiMathMLExportAction;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import java.io.IOException;

public class WmiMathMLStringExportAction
extends WmiMathMLExportAction {
    @Override
    public void openModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        WmiMathStringModel string = (WmiMathStringModel)model;
        formatter.writeBinary("<ms");
        try {
            formatter.writeText(this.exportAttributes(WmiMathAttributeSet.MATHML_ATTR_KEYS, (WmiAbstractArrayAttributeSet)((WmiMathAttributeSet)string.getAttributes())));
            formatter.writeText(this.exportAttributes(WmiMathStringModel.WmiMathStringAttributeSet.ATTRIBUTES, (WmiAbstractArrayAttributeSet)((WmiMathStringModel.WmiMathStringAttributeSet)string.getAttributes())));
            String contents = string.getTokenContents();
            formatter.writeBinary(">");
            WmiMathStringModel.WmiMathStringAttributeSet attrs = (WmiMathStringModel.WmiMathStringAttributeSet)string.getAttributesForRead();
            int left = 1;
            int right = 1;
            if (attrs != null) {
                left = attrs.getLeftQuote().length();
                right = attrs.getRightQuote().length();
            }
            StringBuffer htmlSafe = new StringBuffer();
            WmiMathFormatter.makeHTMLSafe(contents.substring(left, contents.length() - right), htmlSafe);
            formatter.writeBinary(htmlSafe.toString());
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    @Override
    public void closeModel(WmiExportFormatter formatter, WmiModel model) throws IOException {
        formatter.writeBinary("</ms>");
    }
}

