/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.xml;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.io.WmiImportAction;
import com.maplesoft.mathdoc.io.WmiImportParser;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import org.xml.sax.Attributes;

public abstract class WmiXMLBlockImportAction
implements WmiImportAction {
    protected WmiXMLBlockImportAction() {
    }

    protected boolean definesCharAttributes() {
        return false;
    }

    protected String[] getRelevantAttributeKeys() {
        return null;
    }

    public void processAttributes(WmiImportParser parser, Attributes source, WmiModel model) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            String[] attrRestrict = this.getRelevantAttributeKeys();
            if (attrRestrict == null) {
                int a = 0;
                while (a < source.getLength()) {
                    model.addAttribute(source.getQName(a), source.getValue(a));
                    ++a;
                }
            } else {
                int a = 0;
                while (a < attrRestrict.length) {
                    String key = attrRestrict[a];
                    String value = source.getValue(key);
                    if (value != null) {
                        model.addAttribute(key, value);
                    }
                    ++a;
                }
            }
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public void beginAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            if (parser != null) {
                WmiModel newModel;
                WmiFontAttributeSet charAttr = null;
                if (this.definesCharAttributes()) {
                    charAttr = parser.pushCharacterAttributes();
                }
                if ((newModel = this.createModel(parser.getDocument())) != null) {
                    if (inputSource instanceof Attributes) {
                        this.processAttributes(parser, (Attributes)inputSource, newModel);
                    }
                    if (charAttr != null) {
                        charAttr.addAttributes(newModel.getAttributes());
                    }
                    parser.openModel(newModel);
                }
            }
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public void endAction(WmiImportParser parser, Object inputSource) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        try {
            if (parser != null) {
                parser.closeModel(null);
                if (this.definesCharAttributes()) {
                    parser.popCharacterAttributes();
                }
            }
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
    }

    public abstract WmiModel createModel(WmiMathDocumentModel var1);
}

