/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.xml;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.io.WmiGenericTextExportAction;
import com.maplesoft.mathdoc.io.WmiHashedExportFormatter;
import com.maplesoft.mathdoc.io.xml.WmiXMLBlockExportAction;
import com.maplesoft.mathdoc.io.xml.WmiXMLDocumentElementExportAction;
import com.maplesoft.mathdoc.io.xml.WmiXMLMathExportAction;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.util.Base64Encoder;
import java.awt.Color;
import java.io.IOException;

public abstract class WmiXMLExportFormatter
extends WmiHashedExportFormatter {
    protected WmiXMLExportFormatter() {
    }

    public static String translateAttribute(Object value) {
        String xmlValue = null;
        if (value instanceof Color) {
            xmlValue = WmiColorAttributeKey.createRGBStringFromColor((Color)value);
        } else if (value != null) {
            xmlValue = value.toString();
        }
        return xmlValue;
    }

    public static String convertToXMLSafe(String text) {
        StringBuffer xmlText = new StringBuffer(text);
        int index = 0;
        while (index < xmlText.length()) {
            char current = xmlText.charAt(index);
            if (current == '\u0000') {
                xmlText.delete(index, index + 1);
                continue;
            }
            switch (current) {
                case '<': {
                    xmlText.replace(index, index + 1, "&lt;");
                    index += "&lt;".length();
                    break;
                }
                case '>': {
                    xmlText.replace(index, index + 1, "&gt;");
                    index += "&gt;".length();
                    break;
                }
                case '&': {
                    xmlText.replace(index, index + 1, "&amp;");
                    index += "&amp;".length();
                    break;
                }
                case '\"': {
                    xmlText.replace(index, index + 1, "&quot;");
                    index += "&quot;".length();
                    break;
                }
                default: {
                    ++index;
                }
            }
        }
        return xmlText.toString();
    }

    @Override
    protected void hashActions() {
        this.addAction(WmiModelTag.DOCUMENT, new WmiXMLDocumentElementExportAction());
        this.addAction(WmiModelTag.MATH, new WmiXMLMathExportAction());
        this.addAction(WmiModelTag.PARAGRAPH, new WmiXMLBlockExportAction());
        this.addAction(WmiModelTag.TEXT, new WmiGenericTextExportAction());
    }

    @Override
    public void writeAttribute(Object key, Object value) throws IOException {
        if (key != null && value != null) {
            this.writeBinary(" ");
            this.writeText(key.toString());
            this.writeBinary("=\"");
            this.writeText(WmiXMLExportFormatter.translateAttribute(value));
            this.writeBinary("\"");
        }
    }

    @Override
    public void writeMathModel(WmiMathModel math) throws WmiNoReadAccessException, IOException {
        String dotM = null;
        if (math instanceof WmiMathWrapperModel) {
            dotM = ((WmiMathWrapperModel)math).getSaveDotM();
        } else {
            Dag dag = math.toDag();
            dotM = DagBuilder.createDotm(dag);
        }
        if (dotM != null) {
            StringBuffer data = new StringBuffer();
            Base64Encoder.encode(dotM, data);
            this.writeBinary(data.toString());
        }
    }

    @Override
    protected boolean ignoreHiddenModels() {
        return false;
    }

    @Override
    protected String transformForTextOutput(String unicodeText) {
        String encoded = super.transformForTextOutput(unicodeText);
        String safe = WmiXMLExportFormatter.convertToXMLSafe(encoded);
        return safe;
    }
}

