/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.xml;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.exception.WmiParseException;
import com.maplesoft.mathdoc.io.WmiHashedImportParser;
import com.maplesoft.mathdoc.io.xml.WmiXMLModelBuilder;
import com.maplesoft.mathdoc.io.xml.WmiXMLParseException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiModelLock;
import com.maplesoft.util.WmiXMLParserImplementation;
import java.io.IOException;
import java.io.Reader;
import org.xml.sax.SAXException;

public abstract class WmiXMLImportParser
extends WmiHashedImportParser {
    protected WmiXMLModelBuilder xmlContentHandler = new WmiXMLModelBuilder(this);
    protected WmiXMLParserImplementation parser = new WmiXMLParserImplementation(this.xmlContentHandler);

    protected WmiXMLImportParser() {
    }

    public void reportUnrecognizedTag(String specTag, Object specs) {
        this.reportUnrecognizedObject(specTag, specs);
    }

    @Override
    public boolean parse(Reader reader, WmiCompositeModel parent, int offset) throws WmiParseException, WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        if (parent == null) {
            throw new WmiParseException("Bad parameter", reader);
        }
        if (!WmiModelLock.hasLock(parent, 1)) {
            throw new WmiNoWriteAccessException(parent);
        }
        if (offset < 0) {
            throw new WmiModelIndexOutOfBoundsException(parent, offset);
        }
        if (offset > parent.getChildCount()) {
            throw new WmiModelIndexOutOfBoundsException(parent, offset);
        }
        this.parserInitialization(parent, offset);
        boolean success = false;
        try {
            try {
                this.parser.parse(reader);
                success = true;
            }
            catch (SAXException saxE) {
                throw new WmiXMLParseException(reader, saxE);
            }
            catch (IOException ioE) {
                throw new WmiParseException(ioE.toString(), reader);
            }
        }
        finally {
            this.flush();
        }
        return success;
    }
}

