/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.io.xml;

import com.maplesoft.mathdoc.io.WmiExportFormatter;
import com.maplesoft.mathdoc.io.WmiMetadataTableExporter;
import com.maplesoft.mathdoc.model.WmiMetadataContainer;
import com.maplesoft.mathdoc.model.WmiMetatag;
import com.maplesoft.mathdoc.model.WmiMetatagCategory;
import com.maplesoft.mathdoc.model.WmiModelTag;
import java.io.IOException;
import java.util.Set;

public class WmiXMLMetadataTableExporter
extends WmiMetadataTableExporter {
    protected static final String INDENT_SPACES = "    ";

    @Override
    protected void beginMetadataTable(WmiExportFormatter formatter) throws IOException {
        formatter.writeBinary("\n<" + this.getMetadataTableName() + ">");
    }

    @Override
    protected void endMetadataTable(WmiExportFormatter formatter) throws IOException {
        formatter.writeBinary("\n</" + this.getMetadataTableName() + ">");
    }

    @Override
    protected void writeCategoryTag(WmiMetatagCategory tag, WmiExportFormatter formatter) throws IOException {
        formatter.writeBinary("\n");
        formatter.writeBinary(INDENT_SPACES);
        formatter.writeBinary("<");
        formatter.writeBinary(this.getMetadataCategoryName());
        formatter.writeBinary(" ");
        formatter.writeBinary("name");
        formatter.writeBinary("=");
        this.writeQuoted(tag.getName(), formatter);
        formatter.writeBinary(">");
        this.writeAttributesForTag(tag, formatter);
        formatter.writeBinary("\n");
        formatter.writeBinary(INDENT_SPACES);
        formatter.writeBinary("</");
        formatter.writeBinary(this.getMetadataCategoryName());
        formatter.writeBinary(">");
    }

    @Override
    protected void writeMetatag(WmiMetatag tag, WmiExportFormatter formatter) throws IOException {
        formatter.writeBinary("\n");
        formatter.writeBinary(INDENT_SPACES);
        formatter.writeBinary("<");
        formatter.writeBinary(this.getMetadataTagName());
        formatter.writeBinary(" ");
        formatter.writeBinary("id");
        formatter.writeBinary("=");
        this.writeQuoted(tag.getId(), formatter);
        formatter.writeBinary(" ");
        formatter.writeBinary("category");
        formatter.writeBinary("=");
        this.writeQuoted(tag.getCategory(), formatter);
        formatter.writeBinary(" ");
        formatter.writeBinary("name");
        formatter.writeBinary("=");
        this.writeQuoted(tag.getName(), formatter);
        formatter.writeBinary(">");
        this.writeAttributesForTag(tag, formatter);
        formatter.writeBinary("\n");
        formatter.writeBinary(INDENT_SPACES);
        formatter.writeBinary("</");
        formatter.writeBinary(this.getMetadataTagName());
        formatter.writeBinary(">");
    }

    protected void writeAttributesForTag(WmiMetadataContainer tag, WmiExportFormatter formatter) throws IOException {
        Set attrSet = tag.getAttributeKeySet();
        if (attrSet != null) {
            for (Object key : attrSet) {
                if (!(key instanceof String)) continue;
                this.writeAttribute(tag, (String)key, formatter);
            }
        }
    }

    protected void writeAttribute(WmiMetadataContainer tag, String key, WmiExportFormatter formatter) throws IOException {
        formatter.writeBinary("\n");
        formatter.writeBinary(INDENT_SPACES);
        formatter.writeBinary(INDENT_SPACES);
        formatter.writeBinary("<");
        formatter.writeBinary(this.getMetadataAttributeName());
        formatter.writeBinary(" ");
        formatter.writeBinary("name");
        formatter.writeBinary("=");
        this.writeQuoted(key, formatter);
        formatter.writeBinary(" ");
        formatter.writeBinary("value");
        formatter.writeBinary("=");
        this.writeQuoted(tag.getAttribute(key), formatter);
        formatter.writeBinary("/>");
    }

    protected void writeQuoted(String text, WmiExportFormatter formatter) throws IOException {
        formatter.writeBinary("\"");
        formatter.writeText(text);
        formatter.writeBinary("\"");
    }

    protected String getMetadataTableName() {
        return WmiModelTag.METADATA_TABLE.toString();
    }

    protected String getMetadataCategoryName() {
        return WmiModelTag.METADATA_CATEGORY.toString();
    }

    protected String getMetadataTagName() {
        return WmiModelTag.METADATA_TAG.toString();
    }

    protected String getMetadataAttributeName() {
        return WmiModelTag.METADATA_ATTRIBUTE.toString();
    }
}

