/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiColorAttributeKey;
import java.awt.Color;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;

public abstract class WmiAbstractMappedAttributeSet
implements WmiAttributeSet {
    @Override
    public void addAttribute(Object key, Object value) {
        HashMap mapperMap = this.getAttributeMapperMap();
        if (mapperMap != null) {
            WmiAttributeMapper mapper = (WmiAttributeMapper)mapperMap.get(key);
            if (mapper != null) {
                mapper.addAttribute(this, value);
            } else if (key != null && !(key instanceof String) && (mapper = (WmiAttributeMapper)mapperMap.get(key.toString())) != null) {
                mapper.addAttribute(this, value);
            }
        }
    }

    @Override
    public void addAttributes(WmiAttributeSet addSet) {
        if (addSet != null) {
            Enumeration keys = addSet.getAttributeNames();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                this.addAttribute(key, addSet.getAttribute(key));
            }
        }
    }

    @Override
    public void addAttributes(Object[] keys, Object[] values) {
        if (keys == null || values == null) {
            throw new IllegalArgumentException();
        }
        if (keys.length == values.length) {
            int i = 0;
            while (i < keys.length) {
                this.addAttribute(keys[i], values[i]);
                ++i;
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Object getAttribute(Object key) {
        WmiAttributeMapper mapper;
        Object value = null;
        HashMap mapperMap = this.getAttributeMapperMap();
        if (mapperMap != null && (mapper = (WmiAttributeMapper)mapperMap.get(key)) != null) {
            value = mapper.getAttribute(this);
        }
        return value;
    }

    protected abstract HashMap getAttributeMapperMap();

    protected static interface WmiAttributeMapper {
        public void addAttribute(WmiAttributeSet var1, Object var2);

        public Object getAttribute(WmiAttributeSet var1);
    }

    protected static abstract class WmiColorAttributeMapper
    implements WmiAttributeMapper {
        protected WmiColorAttributeMapper() {
        }

        @Override
        public void addAttribute(WmiAttributeSet set, Object value) {
            int[] colArray;
            Color colorVal = null;
            if (value instanceof Color) {
                colorVal = (Color)value;
            } else if (value instanceof String) {
                colorVal = new Color(WmiColorAttributeKey.createColorIndexFromRGBString((String)value));
            } else if (value instanceof int[] && (colArray = (int[])value).length == 3) {
                colorVal = new Color(colArray[0], colArray[1], colArray[2]);
            }
            if (colorVal != null) {
                this.store(set, colorVal);
            }
        }

        @Override
        public Object getAttribute(WmiAttributeSet set) {
            return this.fetch(set);
        }

        public abstract Color fetch(WmiAttributeSet var1);

        public abstract void store(WmiAttributeSet var1, Color var2);
    }

    protected static abstract class WmiDagAttributeMapper
    implements WmiAttributeMapper {
        protected WmiDagAttributeMapper() {
        }

        @Override
        public void addAttribute(WmiAttributeSet set, Object value) {
            Dag dagValue = null;
            if (value instanceof byte[]) {
                try {
                    dagValue = DagBuilder.createDag((byte[])value);
                }
                catch (IOException ioE) {
                    WmiErrorLog.log(ioE);
                }
            } else if (value instanceof Dag) {
                dagValue = (Dag)value;
            } else if (value != null) {
                try {
                    dagValue = DagBuilder.createDag(value.toString().getBytes());
                }
                catch (IOException ioE) {
                    WmiErrorLog.log(ioE);
                }
            }
            if (dagValue != null) {
                this.store(set, dagValue);
            }
        }

        @Override
        public Object getAttribute(WmiAttributeSet set) {
            return this.fetch(set);
        }

        public abstract Dag fetch(WmiAttributeSet var1);

        public abstract void store(WmiAttributeSet var1, Dag var2);
    }

    protected static abstract class WmiDoubleAttributeMapper
    implements WmiAttributeMapper {
        protected WmiDoubleAttributeMapper() {
        }

        @Override
        public void addAttribute(WmiAttributeSet set, Object value) {
            double dValue = 0.0;
            if (value instanceof Double) {
                dValue = (Double)value;
            } else if (value != null) {
                try {
                    dValue = Double.parseDouble(value.toString());
                }
                catch (NumberFormatException numE) {
                    WmiErrorLog.log(numE);
                }
            }
            this.store(set, dValue);
        }

        @Override
        public Object getAttribute(WmiAttributeSet set) {
            return new Double(this.fetch(set));
        }

        public abstract double fetch(WmiAttributeSet var1);

        public abstract void store(WmiAttributeSet var1, double var2);
    }

    protected static abstract class WmiIntAttributeMapper
    implements WmiAttributeMapper {
        protected WmiIntAttributeMapper() {
        }

        @Override
        public void addAttribute(WmiAttributeSet set, Object value) {
            int ivalue = 0;
            if (value instanceof Integer) {
                ivalue = (Integer)value;
            } else if (value != null) {
                try {
                    ivalue = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException numE) {
                    try {
                        float fValue = new Float(value.toString()).floatValue();
                        ivalue = (int)Math.ceil(fValue);
                    }
                    catch (NumberFormatException floatE) {
                        WmiErrorLog.log(floatE);
                    }
                }
            }
            this.store(set, ivalue);
        }

        @Override
        public Object getAttribute(WmiAttributeSet set) {
            return new Integer(this.fetch(set));
        }

        public abstract int fetch(WmiAttributeSet var1);

        public abstract void store(WmiAttributeSet var1, int var2);
    }

    protected static abstract class WmiStringAttributeMapper
    implements WmiAttributeMapper {
        protected WmiStringAttributeMapper() {
        }

        @Override
        public void addAttribute(WmiAttributeSet set, Object value) {
            if (value != null) {
                this.store(set, value.toString());
            }
        }

        @Override
        public Object getAttribute(WmiAttributeSet set) {
            return this.fetch(set);
        }

        public abstract String fetch(WmiAttributeSet var1);

        public abstract void store(WmiAttributeSet var1, String var2);
    }

    protected static abstract class WmiStringBoolAttributeMapper
    extends WmiStringAttributeMapper {
        protected WmiStringBoolAttributeMapper() {
        }

        @Override
        public void addAttribute(WmiAttributeSet set, Object value) {
            String valueStr;
            String boolString = null;
            if (value instanceof Boolean) {
                boolString = ((Boolean)value).toString();
            } else if (value != null && ((valueStr = value.toString()).equalsIgnoreCase(Boolean.TRUE.toString()) || valueStr.equalsIgnoreCase(Boolean.FALSE.toString()))) {
                boolString = valueStr.toLowerCase();
            }
            if (boolString != null) {
                this.store(set, boolString);
            }
        }
    }
}

