/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;

public abstract class WmiAbstractMathDeleteHandler
implements WmiDeleteHandler {
    protected WmiCompositeModel model;

    protected abstract void processRestructure(WmiDeleteManager var1) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException;

    @Override
    public void processDelete(WmiDeleteManager manager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceNonEmptyPlaceholders(manager);
        this.processRestructure(manager);
    }

    protected boolean isNonEmptyPlaceholder(WmiModel model) throws WmiNoReadAccessException {
        boolean nonEmptyPlaceholder = false;
        if (model instanceof WmiDeletePlaceholderModel) {
            WmiDeletePlaceholderModel placeHolder = (WmiDeletePlaceholderModel)model;
            WmiModel replaced = placeHolder.getReplacedModel();
            nonEmptyPlaceholder = !WmiModelUtil.isEmptyModel(replaced);
        }
        return nonEmptyPlaceholder;
    }

    protected void replaceNonEmptyPlaceholders(WmiDeleteManager manager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int childCount = this.model.getChildCount();
        int i = 0;
        while (i < childCount) {
            if (this.isNonEmptyPlaceholder(this.model.getChild(i))) {
                this.replaceWithEmptyIdentifier(manager, i);
            }
            ++i;
        }
    }

    protected void replaceWithEmptyIdentifier(WmiDeleteManager manager, int index) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiMathDocumentModel doc = this.model.getDocument();
        WmiDeletePlaceholderModel placeHolder = (WmiDeletePlaceholderModel)this.model.getChild(index);
        WmiModel deleted = placeHolder.getReplacedModel();
        WmiFontAttributeSet attribs = deleted.getAttributes() instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)deleted.getAttributes() : new WmiMathAttributeSet();
        WmiMathContext context = new WmiMathContext(attribs);
        WmiMathTokenModel identifier = WmiMathFactory.createMathIdentifierToken(doc, "", context);
        this.model.replaceChild(identifier, index);
        manager.setModelToReposition(new WmiModelPosition(identifier, 0));
    }

    @Override
    public boolean forceDeleteHandling() {
        return false;
    }
}

