/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.graphics.AbstractInheritedAttributeKey;

public abstract class WmiBooleanAttributeKey
extends AbstractInheritedAttributeKey {
    public static final String SET = "true";
    public static final String RESET = "false";
    private String name;
    protected boolean defaultValue;

    public WmiBooleanAttributeKey(String name, boolean defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public WmiBooleanAttributeKey(String name, boolean defaultValue, int inheritanceIndex) {
        super(inheritanceIndex);
        this.name = name;
        this.defaultValue = defaultValue;
    }

    @Override
    public abstract boolean getBooleanValue(WmiAttributeSet var1);

    public boolean getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int getIntValue(WmiAttributeSet set) {
        return this.getBooleanValue(set) ? 1 : 0;
    }

    @Override
    public float getFloatValue(WmiAttributeSet set) {
        return this.getBooleanValue(set) ? 1 : 0;
    }

    @Override
    public String getStringValue(WmiAttributeSet set) {
        return this.getBooleanValue(set) ? SET : RESET;
    }

    @Override
    public Object getValue(WmiAttributeSet set) {
        return this.getBooleanValue(set) ? SET : RESET;
    }

    @Override
    public abstract void setBooleanValue(WmiAttributeSet var1, boolean var2);

    @Override
    public void setIntValue(WmiAttributeSet set, int value) {
        this.setBooleanValue(set, value != 0);
    }

    @Override
    public void setFloatValue(WmiAttributeSet set, float value) {
        this.setBooleanValue(set, value != 0.0f);
    }

    @Override
    public void setStringValue(WmiAttributeSet set, String value) {
        boolean state = value == null ? this.defaultValue : value.compareToIgnoreCase(SET) == 0;
        this.setBooleanValue(set, state);
    }

    @Override
    public void setValue(WmiAttributeSet set, Object value) {
        if (value instanceof Boolean) {
            this.setBooleanValue(set, value.equals(Boolean.TRUE));
        } else if (value instanceof Integer) {
            this.setIntValue(set, (Integer)value);
        } else if (value instanceof Float) {
            this.setFloatValue(set, ((Float)value).floatValue());
        } else if (value != null) {
            this.setStringValue(set, value.toString());
        } else {
            this.setBooleanValue(set, this.defaultValue);
        }
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public int getAttributeType() {
        return 0;
    }

    public String toString() {
        return this.getAttributeName();
    }
}

