/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.util.WmiStringParseTools;
import java.awt.Color;
import java.util.regex.Pattern;

public abstract class WmiColorAttributeKey
extends WmiIntAttributeKey {
    private static Pattern hex = Pattern.compile("0?[#xX][0-9a-fA-F]{6}");

    public WmiColorAttributeKey(String name, int defaultValue) {
        super(name, defaultValue);
    }

    public WmiColorAttributeKey(String name, int defaultValue, int inheritanceIndex) {
        super(name, defaultValue, inheritanceIndex);
    }

    @Override
    public String getStringValue(WmiAttributeSet set) {
        int value = this.getIntValue(set);
        return WmiColorAttributeKey.createRGBStringFromColorIndex(value);
    }

    @Override
    public Object getValue(WmiAttributeSet set) {
        return this.getStringValue(set);
    }

    @Override
    public void setStringValue(WmiAttributeSet set, String value) {
        int iValue = WmiColorAttributeKey.createColorIndexFromRGBString(value);
        if (iValue == -1) {
            iValue = WmiColorAttributeKey.createColorIndexFromHexString(value);
        }
        if (iValue == -1) {
            iValue = WmiColorAttributeKey.createColorIndexFromColorName(value);
        }
        if (iValue == -1) {
            iValue = this.getDefaultValue();
        }
        this.setIntValue(set, iValue);
    }

    @Override
    public void setValue(WmiAttributeSet set, Object value) {
        if (value instanceof Color) {
            this.setIntValue(set, ((Color)value).getRGB());
        } else {
            super.setValue(set, value);
        }
    }

    public static int createColorIndexFromRGBString(String colorStr) {
        int iValue = -1;
        try {
            int startIndex = 1;
            int endIndex = colorStr.indexOf(44);
            if (endIndex > 0) {
                int red = WmiStringParseTools.parseInt(colorStr, startIndex, endIndex);
                startIndex = endIndex + 1;
                if ((endIndex = colorStr.indexOf(44, startIndex)) > 0) {
                    int green = WmiStringParseTools.parseInt(colorStr, startIndex, endIndex);
                    startIndex = endIndex + 1;
                    if ((endIndex = colorStr.indexOf(93, startIndex)) > 0) {
                        int blue = WmiStringParseTools.parseInt(colorStr, startIndex, endIndex);
                        iValue = (red << 16) + (green << 8) + blue;
                    }
                }
            }
        }
        catch (NumberFormatException e) {
            WmiErrorLog.log(e);
        }
        return iValue;
    }

    public static int createColorIndexFromColorName(String name) {
        String hexValue = WmiMathAttributeSet.getColour(name);
        if (hexValue.equals("")) {
            return -1;
        }
        return WmiColorAttributeKey.createColorIndexFromHexString(hexValue);
    }

    public static int createColorIndexFromHexString(String colorStr) {
        int colorIndex = -1;
        if (hex.matcher(colorStr = colorStr.toUpperCase()).matches()) {
            int start = 1;
            if (colorStr.startsWith("0")) {
                // empty if block
            }
            int n = ++start;
            int n2 = ++start;
            int red = WmiColorAttributeKey.hexToDec(colorStr.charAt(n)) * 16 + WmiColorAttributeKey.hexToDec(colorStr.charAt(n2));
            int n3 = ++start;
            int n4 = ++start;
            int green = WmiColorAttributeKey.hexToDec(colorStr.charAt(n3)) * 16 + WmiColorAttributeKey.hexToDec(colorStr.charAt(n4));
            int n5 = ++start;
            int n6 = ++start;
            ++start;
            int blue = WmiColorAttributeKey.hexToDec(colorStr.charAt(n5)) * 16 + WmiColorAttributeKey.hexToDec(colorStr.charAt(n6));
            colorIndex = (red << 16) + (green << 8) + blue;
        }
        return colorIndex;
    }

    private static int hexToDec(char ch) {
        int value = 0;
        if (ch >= '0' && ch <= '9') {
            value = ch - 48;
        } else if (ch >= 'a' && ch <= 'f') {
            ch = (char)97;
            value = 97 + 10;
        } else if (ch >= 'A' && ch <= 'F') {
            value = ch - 65 + 10;
        }
        return value;
    }

    public static String createRGBHexStringFromColor(Color color) {
        return WmiColorAttributeKey.createRGBHexStringFromColorTriplet(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static String createRGBHexStringFromColorIndex(int index) {
        return WmiColorAttributeKey.createRGBHexStringFromColorTriplet(index >> 16 & 0xFF, index >> 8 & 0xFF, index & 0xFF);
    }

    public static String createRGBHexStringFromColorTriplet(int r, int g, int b) {
        StringBuffer rgb = new StringBuffer();
        String red = Integer.toHexString(r);
        if (red.length() == 1) {
            rgb.append('0');
        }
        rgb.append(red);
        String green = Integer.toHexString(g);
        if (green.length() == 1) {
            rgb.append('0');
        }
        rgb.append(green);
        String blue = Integer.toHexString(b);
        if (blue.length() == 1) {
            rgb.append('0');
        }
        rgb.append(blue);
        return rgb.toString();
    }

    public static String createRGBStringFromColorIndex(int value) {
        StringBuffer buffy = new StringBuffer();
        buffy.append("[");
        buffy.append(value >> 16 & 0xFF);
        buffy.append(",");
        buffy.append(value >> 8 & 0xFF);
        buffy.append(",");
        buffy.append(value & 0xFF);
        buffy.append("]");
        return buffy.toString();
    }

    public static String createRGBStringFromColor(Color color) {
        StringBuffer rgb = new StringBuffer("[");
        rgb.append(color.getRed());
        rgb.append("," + color.getGreen());
        rgb.append("," + color.getBlue() + "]");
        return rgb.toString();
    }
}

