/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;
import java.util.ArrayList;

public class WmiCompositeUndoableEdit
implements WmiUndoableEdit {
    private String name;
    private ArrayList editsList = new ArrayList();
    private boolean coalescable = false;

    public WmiCompositeUndoableEdit(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void addEdit(WmiUndoableEdit edit) {
        this.editsList.add(edit);
    }

    @Override
    public void undo() throws WmiNoUpdateAccessException {
        int size = this.editsList.size();
        int i = size - 1;
        while (i >= 0) {
            WmiUndoableEdit edit = (WmiUndoableEdit)this.editsList.get(i);
            edit.undo();
            --i;
        }
    }

    @Override
    public void redo() throws WmiNoUpdateAccessException {
        int size = this.editsList.size();
        int i = 0;
        while (i < size) {
            WmiUndoableEdit edit = (WmiUndoableEdit)this.editsList.get(i);
            edit.redo();
            ++i;
        }
    }

    public void combineWith(WmiCompositeUndoableEdit postpend) {
        this.editsList.addAll(postpend.editsList);
    }

    public boolean isCoalescable() {
        return this.coalescable;
    }

    public void setCoalescable(boolean isCoalescable) {
        this.coalescable = isCoalescable;
    }
}

