/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import java.util.Stack;

public class WmiDeleteManager {
    private Stack deletionStack = new Stack();
    private WmiModelPosition modelToReposition = null;

    public void mark(WmiCompositeModel model) {
        if (!this.deletionStack.contains(model)) {
            this.deletionStack.push(model);
        }
    }

    public void unMark(WmiCompositeModel model) {
        this.deletionStack.removeElement(model);
    }

    public void clear() {
        this.deletionStack.clear();
    }

    public void update() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        while (!this.deletionStack.isEmpty()) {
            WmiCompositeModel model;
            WmiDeleteHandler handler;
            Object popped = this.deletionStack.pop();
            if (!(popped instanceof WmiCompositeModel) || (handler = (model = (WmiCompositeModel)popped).getDeleteHandler()) == null) continue;
            handler.processDelete(this);
        }
    }

    public WmiModelPosition getModelToReposition() {
        return this.modelToReposition;
    }

    public void setModelToReposition(WmiModelPosition modelToReposition) {
        this.modelToReposition = modelToReposition;
    }
}

