/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.graphics.AbstractInheritedAttributeKey;
import com.maplesoft.mathdoc.model.graphics.InheritedAttributeSet;

public class WmiFloatAttributeKey
extends AbstractInheritedAttributeKey
implements WmiAttributeKey {
    private String name;
    private float defaultValue;

    protected WmiFloatAttributeKey(String name, float defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public WmiFloatAttributeKey(String name, float defaultValue, int inheritanceIndex) {
        super(inheritanceIndex);
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public String toString() {
        return this.getAttributeName();
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean getBooleanValue(WmiAttributeSet set) {
        return false;
    }

    @Override
    public int getIntValue(WmiAttributeSet set) {
        return (int)this.getFloatValue(set);
    }

    @Override
    public float getFloatValue(WmiAttributeSet set) {
        return 0.0f;
    }

    @Override
    public String getStringValue(WmiAttributeSet set) {
        return String.valueOf(this.getFloatValue(set));
    }

    @Override
    public Object getValue(WmiAttributeSet set) {
        return new Float(this.getFloatValue(set));
    }

    @Override
    public void setBooleanValue(WmiAttributeSet set, boolean value) {
    }

    @Override
    public void setIntValue(WmiAttributeSet set, int value) {
        this.setFloatValue(set, value);
    }

    @Override
    public void setFloatValue(WmiAttributeSet set, float value) {
    }

    @Override
    public void setStringValue(WmiAttributeSet set, String value) {
        try {
            this.setFloatValue(set, Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public void setValue(WmiAttributeSet set, Object value) {
        this.setStringValue(set, String.valueOf(value));
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    @Override
    public int getAttributeType() {
        return 2;
    }

    @Override
    public boolean isInherited(InheritedAttributeSet set) {
        return set != null && set.isInherited(this);
    }

    @Override
    public void setInheritance(InheritedAttributeSet set, boolean inherited) {
        if (set != null) {
            set.setInherited(this, inherited);
        }
    }
}

