/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;

public final class WmiInputLock {
    protected WmiMathDocumentModel parent = null;
    protected boolean enabled = true;
    protected Object lock = new Object();
    protected int count = 0;

    public WmiInputLock(WmiMathDocumentModel document) {
        this.parent = document;
    }

    public void disable() {
        this.enabled = false;
    }

    public static void lock(WmiModel model) {
        WmiMathDocumentModel doc = model.getDocument();
        if (doc != null) {
            doc.getInputLock().lock();
        }
    }

    public static void unlock(WmiModel model) {
        WmiMathDocumentModel doc = model.getDocument();
        if (doc != null) {
            doc.getInputLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        Object object = this.lock;
        synchronized (object) {
            ++this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Object object = this.lock;
        synchronized (object) {
            if (this.count > 0) {
                --this.count;
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            if (this.count > 0) {
                this.count = 0;
            }
        }
        this.lock.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        Object object = this.lock;
        synchronized (object) {
            return this.count != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLock() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

