/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.graphics.AbstractInheritedAttributeKey;

public abstract class WmiIntAttributeKey
extends AbstractInheritedAttributeKey
implements WmiAttributeKey {
    private static Integer[] INTEGER_POOL = new Integer[20];
    private String name;
    private int defaultValue;

    protected WmiIntAttributeKey(String name, int defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public WmiIntAttributeKey(String name, int defaultValue, int inheritanceIndex) {
        super(inheritanceIndex);
        this.name = name;
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean getBooleanValue(WmiAttributeSet set) {
        return this.getIntValue(set) != 0;
    }

    @Override
    public abstract int getIntValue(WmiAttributeSet var1);

    @Override
    public float getFloatValue(WmiAttributeSet set) {
        int value = this.getIntValue(set);
        return value;
    }

    @Override
    public String getStringValue(WmiAttributeSet set) {
        int value = this.getIntValue(set);
        return Integer.toString(value);
    }

    @Override
    public Object getValue(WmiAttributeSet set) {
        Integer integer;
        int value = this.getIntValue(set);
        if (value < INTEGER_POOL.length && value >= 0) {
            integer = INTEGER_POOL[value];
            if (integer == null) {
                WmiIntAttributeKey.INTEGER_POOL[value] = integer = new Integer(value);
            }
        } else {
            integer = new Integer(value);
        }
        return integer;
    }

    @Override
    public void setBooleanValue(WmiAttributeSet set, boolean value) {
        this.setIntValue(set, value ? 1 : 0);
    }

    @Override
    public abstract void setIntValue(WmiAttributeSet var1, int var2);

    @Override
    public void setFloatValue(WmiAttributeSet set, float value) {
        this.setIntValue(set, Math.round(value));
    }

    @Override
    public void setStringValue(WmiAttributeSet set, String value) {
        int iValue = this.getDefaultValue();
        try {
            iValue = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            WmiErrorLog.log(nfe);
        }
        this.setIntValue(set, iValue);
    }

    @Override
    public void setValue(WmiAttributeSet set, Object value) {
        if (value != null) {
            this.setStringValue(set, value.toString());
        } else {
            this.setIntValue(set, this.getDefaultValue());
        }
    }

    @Override
    public String getAttributeName() {
        return this.name;
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int getAttributeType() {
        return 1;
    }

    public String toString() {
        return this.getAttributeName();
    }
}

