/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMapleCodeAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;

public class WmiMapleCodeModel
extends WmiAbstractModel {
    private String code;

    public WmiMapleCodeModel(WmiMathDocumentModel doc) {
        super(doc);
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MAPLE_CODE;
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        WmiMapleCodeModelEdit edit = null;
        if (undoName != null) {
            edit = new WmiMapleCodeModelEdit(this);
            edit.setPreupdateProperties(this.parent, this.attributes, this.code);
        }
        if (this.pending != null) {
            this.code = ((WmiMapleCodeModel)this.pending).code;
            if (this.attributes != this.pending.attributes) {
                this.attributes = this.pending.attributes;
            }
            this.parent = this.pending.parent;
        }
        if (edit != null) {
            edit.setPostupdateProperties(this.parent, this.attributes, this.code);
            WmiUndoManager undoManager = this.getDocument().getUndoManager();
            undoManager.addEdit(edit);
        }
        this.pending = null;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMapleCodeAttributeSet();
    }

    public String getCode() throws WmiNoReadAccessException {
        String retCode = this.code;
        this.verifyReadLock();
        if (this.usePending() && this.pending instanceof WmiMapleCodeModel) {
            retCode = ((WmiMapleCodeModel)this.pending).code;
        }
        return retCode;
    }

    public void setCode(String newCode) throws WmiNoWriteAccessException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending instanceof WmiMapleCodeModel) {
            ((WmiMapleCodeModel)this.pending).code = newCode;
        }
    }

    protected static class WmiMapleCodeModelEdit
    implements WmiUndoableEdit {
        private WmiMapleCodeModel model = null;
        private WmiAttributeSet oldAttributes = null;
        private WmiAttributeSet newAttributes = null;
        private String oldCode = null;
        private String newCode = null;
        private WmiCompositeModel oldParent = null;
        private WmiCompositeModel newParent = null;

        public WmiMapleCodeModelEdit(WmiMapleCodeModel model) {
            this.model = model;
        }

        protected void setPreupdateProperties(WmiCompositeModel parent, WmiAttributeSet attributes, String code) {
            this.oldParent = parent;
            this.oldAttributes = attributes;
            this.oldCode = code;
        }

        protected void setPostupdateProperties(WmiCompositeModel parent, WmiAttributeSet attributes, String code) {
            this.newParent = parent;
            this.newAttributes = attributes;
            this.newCode = code;
        }

        @Override
        public void redo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.newParent;
            this.model.attributes = this.newAttributes;
            this.model.code = this.newCode;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }

        @Override
        public void undo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.oldParent;
            this.model.attributes = this.oldAttributes;
            this.model.code = this.oldCode;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
    }
}

