/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import java.util.HashMap;
import java.util.Set;

public abstract class WmiMetadataContainer
implements Comparable {
    public static final String INVALID_ID = "<invalid>";
    public static final String DEFAULT_NAME = "<default>";
    public static final String ID_TAG = "id";
    public static final String CATEGORY_TAG = "category";
    public static final String NAME_TAG = "name";
    public static final String VALUE_TAG = "value";
    public static final int MERGE_CANCEL_ACTION = 0;
    public static final int MERGE_NO_ATTRIBUTE_CHANGE = 1;
    public static final int MERGE_ADD_MISSING = 2;
    public static final int MERGE_REPLACE_WITH_DEFAULTS = 3;
    public static final int MERGE_OVERWITE_ALL = 4;
    private String id = null;
    private String name = null;
    private HashMap valueMap = null;

    public static String getMetadataSafeString(String in) {
        String out = in;
        if (out != null) {
            if (out.length() == 0) {
                out = DEFAULT_NAME;
            }
        } else {
            out = DEFAULT_NAME;
        }
        return out;
    }

    public WmiMetadataContainer(String id, String name) {
        this.valueMap = new HashMap();
        this.id = id;
        this.name = name;
    }

    protected WmiMetadataContainer(WmiMetadataContainer source, boolean duplicateIDs) {
        this.id = duplicateIDs ? source.id : INVALID_ID;
        this.name = new String(source.name);
        this.valueMap = WmiMetadataContainer.attributeMapDeepCopy(source.valueMap);
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean addAttribute(String name, String value) {
        boolean attributeAdded = false;
        if (!this.valueMap.containsKey(name)) {
            if (value != null) {
                this.valueMap.put(name, value);
            } else {
                this.valueMap.put(name, DEFAULT_NAME);
            }
            attributeAdded = true;
        }
        return attributeAdded;
    }

    public String getAttribute(String name) {
        return (String)this.valueMap.get(name);
    }

    public boolean removeAttribute(String name) {
        boolean attributeRemoved = false;
        if (this.valueMap.containsKey(name)) {
            this.valueMap.remove(name);
            attributeRemoved = true;
        }
        return attributeRemoved;
    }

    public void removeAllAttributes() {
        this.valueMap.clear();
    }

    public boolean renameAttribute(String oldName, String newName) {
        boolean attributeRenamed = false;
        if (this.valueMap.containsKey(oldName)) {
            Object value = this.valueMap.get(oldName);
            this.valueMap.remove(oldName);
            this.valueMap.put(newName, value);
            attributeRenamed = true;
        }
        return attributeRenamed;
    }

    public boolean changeAttribute(String name, String newValue, boolean addIfNecessary) {
        boolean attributeChanged = false;
        if (!this.valueMap.containsKey(name)) {
            if (addIfNecessary) {
                attributeChanged = this.addAttribute(name, newValue);
            }
        } else {
            this.valueMap.put(name, newValue);
            attributeChanged = true;
        }
        return attributeChanged;
    }

    public void mergeAttributesFromSource(WmiMetadataContainer source, int how) {
        switch (how) {
            case 2: {
                this.mergeAttributesFromSource(source, false);
                break;
            }
            case 3: {
                this.mergeAttributesFromSource(source, true);
                break;
            }
            case 4: {
                this.replaceAttributesFromSource(source);
                break;
            }
        }
    }

    protected void replaceAttributesFromSource(WmiMetadataContainer source) {
        this.valueMap = WmiMetadataContainer.attributeMapDeepCopy(source.valueMap);
    }

    protected void mergeAttributesFromSource(WmiMetadataContainer source, boolean replaceValues) {
        for (Object srcObj : source.valueMap.keySet()) {
            String srcValue;
            String srcKey;
            String string = srcKey = srcObj != null ? srcObj.toString() : null;
            if (srcKey == null) continue;
            Object srcValueObj = source.valueMap.get(srcKey);
            String string2 = srcValue = srcValueObj != null ? srcValueObj.toString() : null;
            if (srcValue == null) continue;
            boolean haveMatch = this.valueMap.containsKey(srcKey);
            if (haveMatch && replaceValues) {
                this.changeAttribute(srcKey, srcValue);
                continue;
            }
            if (haveMatch) continue;
            this.addAttribute(srcKey, srcValue);
        }
    }

    public boolean changeAttribute(String name, String newValue) {
        return this.changeAttribute(name, newValue, false);
    }

    public Set getAttributeKeySet() {
        return this.valueMap.keySet();
    }

    public int getAttributeCount() {
        return this.valueMap.size();
    }

    protected static HashMap attributeMapDeepCopy(HashMap source) {
        HashMap<String, String> mapCopy = new HashMap<String, String>();
        for (String attrName : source.keySet()) {
            String attrValue = (String)source.get(attrName);
            mapCopy.put(attrName, attrValue);
        }
        return mapCopy;
    }
}

