/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiCorruptedModelLockException;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiLockTimeoutException;
import com.maplesoft.mathdoc.exception.WmiMissingModelLockException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;

public final class WmiModelLock {
    private static final int LOCK_WAIT_TIMEOUT = 10000000;
    public static final int NO_LOCK = -1;
    public static final int READ_LOCK = 0;
    public static final int WRITE_LOCK = 1;
    public static final int UPDATE_LOCK = 2;
    private static Object monitor = new Object();
    private static boolean noWait = false;
    WmiMathDocumentModel document = null;
    int readLockCount = 0;
    int writeLockCount = 0;
    int updateLockCount = 0;
    Thread owner = null;
    boolean enabled = true;

    public WmiModelLock(WmiMathDocumentModel model) {
        this.document = model;
    }

    public void disable() {
        this.enabled = false;
    }

    public static boolean readLock(WmiModel model, boolean wait) {
        return WmiModelLock.acquireLock(model, 0, wait);
    }

    public static void readUnlock(WmiModel model) {
        WmiModelLock.releaseLock(model, 0);
    }

    public static boolean writeLock(WmiModel model, boolean wait) {
        return WmiModelLock.acquireLock(model, 1, wait);
    }

    public static void writeUnlock(WmiModel model) {
        WmiModelLock.releaseLock(model, 1);
    }

    public static boolean updateLock(WmiModel model, boolean wait) {
        return WmiModelLock.acquireLock(model, 2, wait);
    }

    public static void updateUnlock(WmiModel model) {
        WmiModelLock.releaseLock(model, 2);
    }

    public static boolean hasLock(WmiModel model, int type) {
        return WmiModelLock.getLock(model, type) != null;
    }

    public static boolean ownsWriteLock(WmiModel model) {
        boolean owner = false;
        WmiModelLock lock = WmiModelLock.getLock(model, 1);
        if (lock != null && lock.writeLockCount > 0) {
            owner = lock.owner == Thread.currentThread();
        }
        return owner;
    }

    public static boolean ownsUpdateLock(WmiModel model) {
        boolean owner = false;
        WmiModelLock lock = WmiModelLock.getLock(model);
        if (lock != null && lock.updateLockCount > 0) {
            owner = lock.owner == Thread.currentThread();
        }
        return owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WmiModelLock getLock(WmiModel model) {
        WmiModelLock lock = null;
        WmiMathDocumentModel docModel = model.getDocument();
        Object object = monitor;
        synchronized (object) {
            lock = docModel.getLock();
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WmiModelLock getLock(WmiModel model, int type) {
        WmiModelLock lock = null;
        WmiMathDocumentModel docModel = model.getDocument();
        Object object = monitor;
        synchronized (object) {
            lock = docModel.getLock();
            switch (type) {
                case 0: {
                    if (lock.readLockCount != 0) break;
                    lock = null;
                    break;
                }
                case 1: {
                    if (lock.writeLockCount != 0) break;
                    lock = null;
                    break;
                }
                case 2: {
                    if (lock.updateLockCount != 0) break;
                    lock = null;
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean canLock(WmiModel model, int type) {
        boolean cando = true;
        if (model == null) {
            return false;
        }
        Object object = monitor;
        synchronized (object) {
            WmiModelLock lock = null;
            WmiMathDocumentModel docModel = model.getDocument();
            lock = docModel.getLock();
            if (lock.updateLockCount > 0) {
                cando = lock.owner == Thread.currentThread();
            } else if (lock.writeLockCount > 0) {
                boolean bl = cando = type == 0 || lock.owner == Thread.currentThread();
                if (cando && type == 2) {
                    cando = lock.readLockCount == 0;
                }
            } else {
                cando = type != 2;
            }
        }
        return cando;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean acquireLock(WmiModel model, int type, boolean wait) {
        boolean locked = false;
        if (model != null) {
            Object object = monitor;
            synchronized (object) {
                WmiMathDocumentModel docModel = model.getDocument();
                WmiModelLock lock = docModel.getLock();
                if (lock != null && lock.enabled) {
                    if (WmiModelLock.canLock(model, type)) {
                        WmiModelLock.incrementLockCount(lock, type);
                        locked = true;
                    } else if (wait) {
                        boolean createLock = true;
                        long startTime = System.currentTimeMillis();
                        while (!WmiModelLock.canLock(model, type)) {
                            try {
                                long time = System.currentTimeMillis();
                                monitor.wait(10000000L);
                            }
                            catch (InterruptedException e) {
                                WmiErrorLog.log(e);
                                createLock = false;
                                monitor.notifyAll();
                                break;
                            }
                            catch (WmiLockTimeoutException e) {
                                WmiErrorLog.log(e);
                                createLock = false;
                                monitor.notifyAll();
                                break;
                            }
                            if (lock.enabled) continue;
                            createLock = false;
                            monitor.notifyAll();
                            break;
                        }
                        if (createLock) {
                            WmiModelLock.incrementLockCount(lock, type);
                            locked = true;
                        }
                    }
                }
            }
        }
        return locked;
    }

    private static void incrementLockCount(WmiModelLock lock, int type) {
        if (lock != null) {
            switch (type) {
                case 0: {
                    ++lock.readLockCount;
                    break;
                }
                case 1: {
                    ++lock.writeLockCount;
                    lock.owner = Thread.currentThread();
                    break;
                }
                case 2: {
                    ++lock.updateLockCount;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseLock(WmiModel model, int type) {
        if (model == null) {
            WmiErrorLog.log(new IllegalArgumentException("null model!"));
            return;
        }
        WmiModelLock lock = null;
        WmiMathDocumentModel docModel = model.getDocument();
        Object object = monitor;
        synchronized (object) {
            try {
                lock = docModel.getLock();
                if (lock == null) {
                    throw new WmiMissingModelLockException(model);
                }
                switch (type) {
                    case 0: {
                        if (lock.readLockCount > 0) {
                            --lock.readLockCount;
                            break;
                        }
                        throw new WmiCorruptedModelLockException(model);
                    }
                    case 1: {
                        if (lock.writeLockCount == 1) {
                            lock.writeLockCount = 0;
                            lock.owner = null;
                            break;
                        }
                        if (lock.writeLockCount > 0) {
                            --lock.writeLockCount;
                            break;
                        }
                        throw new WmiCorruptedModelLockException(model);
                    }
                    case 2: {
                        if (lock.updateLockCount > 0) {
                            --lock.updateLockCount;
                            break;
                        }
                        throw new WmiCorruptedModelLockException(model);
                    }
                }
            }
            catch (WmiMissingModelLockException e) {
                WmiErrorLog.log(new Exception("Missing model lock"));
            }
            catch (WmiCorruptedModelLockException e) {
                WmiErrorLog.log(new Exception("Corrupted model lock"));
            }
            monitor.notifyAll();
        }
    }
}

