/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiTextModel;

public class WmiModelPathInterval {
    private WmiModelPath lowerBound;
    private WmiModelPath upperBound;

    public WmiModelPathInterval(WmiModelPath first, WmiModelPath second) {
        if (second.greaterThan(first)) {
            this.lowerBound = (WmiModelPath)first.clone();
            this.upperBound = (WmiModelPath)second.clone();
        } else {
            this.lowerBound = (WmiModelPath)second.clone();
            this.upperBound = (WmiModelPath)first.clone();
        }
    }

    private int getBeginOffset(WmiModelPath path, WmiTextModel model) {
        int offset = 0;
        int depth = path.depth();
        int fromDepth = this.lowerBound.depth();
        boolean checkEndDepth = true;
        int i = 0;
        while (i < depth) {
            if (i >= fromDepth || path.peek(i) != this.lowerBound.peek(i)) {
                checkEndDepth = false;
                break;
            }
            ++i;
        }
        if (checkEndDepth && fromDepth > depth) {
            offset = this.lowerBound.peek(depth);
        }
        return offset;
    }

    private int getEndOffset(WmiModelPath path, WmiTextModel model) throws WmiNoReadAccessException {
        int offset = model.getLength();
        int depth = path.depth();
        int toDepth = this.upperBound.depth();
        boolean checkEndDepth = true;
        int i = 0;
        while (i < depth) {
            if (i >= toDepth || path.peek(i) != this.upperBound.peek(i)) {
                checkEndDepth = false;
                break;
            }
            ++i;
        }
        if (checkEndDepth && toDepth > depth) {
            offset = this.upperBound.peek(depth);
        }
        return offset;
    }

    private boolean inInterval(WmiModelPath path) {
        boolean inside = false;
        int size = path.depth();
        int fromDepth = this.lowerBound.depth();
        int toDepth = this.upperBound.depth();
        boolean checkLow = true;
        boolean checkHigh = true;
        int i = 0;
        while (i < size) {
            inside = true;
            int index = path.peek(i);
            if (checkLow) {
                if (i < fromDepth) {
                    int low = this.lowerBound.peek(i);
                    if (index < 0) {
                        inside = false;
                        break;
                    }
                    if (index < low) {
                        inside = false;
                        break;
                    }
                    if (index == low) {
                        inside = true;
                    } else {
                        checkLow = false;
                    }
                } else {
                    inside = true;
                }
            }
            if (checkHigh) {
                if (i < toDepth) {
                    int high = this.upperBound.peek(i);
                    if (index < 0 && i == size - 1) {
                        inside = true;
                    } else if (high < 0) {
                        inside = true;
                        checkHigh = false;
                    } else {
                        if (index > high) {
                            inside = false;
                            break;
                        }
                        if (index == high) {
                            inside = true;
                        } else {
                            checkHigh = false;
                        }
                    }
                } else {
                    inside = true;
                }
            }
            ++i;
        }
        return inside;
    }

    protected int walkIntervalChildren(WmiModelPath rootPath, WmiModel model, WmiMathDocumentModel doc, WmiModelPathWalker visitor) throws WmiNoReadAccessException {
        int selected = 0;
        if (model instanceof WmiCompositeModel) {
            WmiCompositeModel composite = (WmiCompositeModel)model;
            int kids = composite.getChildCount();
            int partialKids = 0;
            int fullKids = 0;
            int k = 0;
            while (k < kids) {
                rootPath.push(k);
                if (this.inInterval(rootPath)) {
                    int childSelected = this.walkIntervalChildren(rootPath, composite.getChild(k), doc, visitor);
                    if (childSelected == 2) {
                        ++fullKids;
                    } else if (childSelected == 1) {
                        ++partialKids;
                    }
                }
                rootPath.pop();
                ++k;
            }
            if (fullKids == kids) {
                selected = 2;
            } else if (fullKids > 0 || partialKids > 0) {
                selected = 1;
            }
        } else if (model instanceof WmiTextModel) {
            WmiTextModel textModel = (WmiTextModel)model;
            selected = 2;
            int begin = this.getBeginOffset(rootPath, textModel);
            if (begin > 0) {
                selected = 1;
            } else {
                int end = this.getEndOffset(rootPath, textModel);
                if (end >= 0 && end < textModel.getLength()) {
                    selected = 1;
                }
            }
        } else {
            selected = 2;
        }
        if (selected != 0) {
            visitor.visitModel(model, selected == 2);
        }
        return selected;
    }

    public WmiModelPath getLowerBound() {
        return this.lowerBound;
    }

    public WmiModelPath getUpperBound() {
        return this.upperBound;
    }

    public void walkInterval(WmiMathDocumentModel doc, WmiModelPathWalker visitor) throws WmiNoReadAccessException {
        WmiModelPath rootPath = WmiModelPath.commonParent(this.lowerBound, this.upperBound);
        WmiModelPosition modelPos = rootPath.getModelPosition(doc);
        if (visitor != null && modelPos != null) {
            this.walkIntervalChildren(rootPath, modelPos.getModel(), doc, visitor);
        }
    }

    public static interface WmiModelPathWalker {
        public void visitModel(WmiModel var1, boolean var2);
    }
}

