/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiTextModel;

public class WmiModelPosition {
    public static final int NO_OFFSET = -1;
    private WmiModel model;
    private int offset = -1;

    public WmiModelPosition(WmiModel model, int offset) {
        this.model = model;
        this.offset = offset;
    }

    public static WmiModelPosition[] splitTextModels(WmiModelPosition firstPos, WmiModelPosition secondPos) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelPosition[] answer = new WmiModelPosition[]{firstPos, secondPos};
        if (firstPos != null && secondPos != null) {
            WmiTextModel currentModel;
            WmiModel upperModel;
            WmiTextModel currentModel2;
            WmiModelPosition lower = null;
            WmiModelPosition upper = null;
            WmiModelPath second = new WmiModelPath(secondPos);
            WmiModelPath first = new WmiModelPath(firstPos);
            boolean orderNotSwitched = second.greaterThan(first);
            if (orderNotSwitched) {
                lower = firstPos;
                upper = secondPos;
            } else {
                lower = secondPos;
                upper = firstPos;
            }
            WmiModel lowerModel = lower.getModel();
            int begin = lower.getOffset();
            int end = upper.getOffset();
            if (lowerModel instanceof WmiTextModel && begin > 0 && begin < (currentModel2 = (WmiTextModel)lowerModel).getLength()) {
                currentModel2 = currentModel2.splitModel(begin);
                lower.model = currentModel2;
                lower.offset = 0;
                if (lowerModel == upper.getModel()) {
                    upper.model = currentModel2;
                    upper.offset = end -= begin;
                }
            }
            if (end > -1 && (upperModel = upper.getModel()) instanceof WmiTextModel && end < (currentModel = (WmiTextModel)upperModel).getLength()) {
                currentModel.splitModel(end);
                upper.offset = currentModel.getLength();
            }
            if (orderNotSwitched) {
                answer[0] = lower;
                answer[1] = upper;
            } else {
                answer[0] = upper;
                answer[1] = lower;
            }
        }
        return answer;
    }

    public WmiModel getModel() {
        return this.model;
    }

    public int getOffset() {
        return this.offset;
    }
}

