/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiLayoutAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPathInterval;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.util.ResourceLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.WeakHashMap;

public class WmiModelWriter {
    private static final int DEFAULT_INDENT = 2;
    private static final String LAYOUT_TABLE = "Layout Styles";
    private static final String FONT_TABLE = "Font Styles";
    private static final String ELLIPSIS = "...";
    private int maxAttributeLength = -1;
    private HashSet ignoreAttributes = new HashSet();
    private boolean zlTagIgnore = false;
    private HashSet ignoreZeroLength = new HashSet();
    private PrintStream out = null;
    private boolean processStyles = true;

    public WmiModelWriter(PrintStream out) {
        this.out = out;
    }

    public static boolean compareResults(String resourceFile, String results) throws FileNotFoundException, IOException {
        return WmiModelWriter.compareResults(resourceFile, results, true);
    }

    public static boolean compareResults(String resourceFile, String results, boolean ignoreWhitespace) throws FileNotFoundException, IOException {
        InputStream fileStream = ResourceLoader.getResourceAsStream(resourceFile);
        if (fileStream == null) {
            throw new FileNotFoundException(resourceFile);
        }
        boolean success = true;
        int value = fileStream.read();
        char ch = results.charAt(0);
        int index = 1;
        while (index != results.length()) {
            if (ignoreWhitespace && ch <= ' ') {
                ch = results.charAt(index++);
                continue;
            }
            if (value < 0) break;
            if (ignoreWhitespace && value <= 32 || value == 13) {
                value = fileStream.read();
                continue;
            }
            if (Character.toLowerCase((char)value) != Character.toLowerCase(ch)) {
                success = false;
                break;
            }
            ch = results.charAt(index++);
            value = fileStream.read();
        }
        return success;
    }

    private void report(WmiModel root, boolean verbose, int indent, WeakHashMap modelsMap) throws WmiNoReadAccessException {
        try {
            boolean allowed;
            int selected = 2;
            if (modelsMap != null) {
                selected = 0;
                Boolean fully = (Boolean)modelsMap.get(root);
                if (fully != null) {
                    int n = selected = fully != false ? 2 : 1;
                }
            }
            if (root instanceof WmiMathDocumentModel && this.processStyles) {
                this.reportStyleTable((WmiMathDocumentModel)root, verbose, indent);
            }
            boolean bl = allowed = !this.zlTagIgnore || !this.ignoreZeroLength.contains(root.getTag()) || !(root instanceof WmiTextModel) || ((WmiTextModel)root).getLength() != 0;
            if (selected != 0 && allowed) {
                this.writeIndent(indent);
                this.out.print(verbose ? "<" : ">");
                this.out.print(root);
                if (verbose) {
                    if (selected == 2 && this.writeVerboseAttributes(root.getAttributesForRead(), indent + 1)) {
                        this.writeIndent(indent);
                    }
                    this.out.print(">");
                }
                this.out.println();
            }
            if (root instanceof WmiCompositeModel && selected != 0) {
                WmiCompositeModel branch = (WmiCompositeModel)root;
                int n = branch.getChildCount();
                int i = 0;
                while (i < n) {
                    this.report(branch.getChild(i), verbose, indent + 2, modelsMap);
                    ++i;
                }
            } else if (root instanceof WmiTextModel && selected != 0 && allowed) {
                this.writeIndent(indent + 1);
                WmiTextModel leaf = (WmiTextModel)root;
                this.out.println("[" + leaf.getText() + "]");
            }
            if (selected != 0 && allowed) {
                this.writeIndent(indent);
                this.out.print(verbose ? "</" : "<");
                this.out.print(root);
                if (verbose) {
                    this.out.print(">");
                }
                this.out.println();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void writeDag(Object name, Dag dag) {
        StringBuffer details = new StringBuffer();
        int type = dag.getType();
        details.append(String.valueOf(DagBuilder.CLASS_NAMES[type]) + "#" + type);
        details.append(" {" + System.identityHashCode(dag) + "} '");
        details.append(String.valueOf(dag.getData()) + "' - ");
        int length = dag.getLength();
        if (length > 0) {
            details.append(" (" + length + ")");
        }
        this.out.println(name + "=" + details);
    }

    private void writeIndent(int n) {
        int i = 0;
        while (i < n) {
            this.out.print(" ");
            ++i;
        }
    }

    private boolean writeVerboseAttributes(WmiAttributeSet attr, int indent) {
        boolean hasAttributes = false;
        try {
            Enumeration names;
            Iterator attrIt = null;
            if (attr != null && attr.getAttributeCount() > 0 && (names = attr.getAttributeNames()) != null) {
                TreeSet<String> sortedAttr = new TreeSet<String>();
                while (names.hasMoreElements()) {
                    Object name = names.nextElement();
                    if (name == null) continue;
                    sortedAttr.add(name.toString());
                }
                if (!sortedAttr.isEmpty()) {
                    hasAttributes = true;
                    this.out.println();
                }
                attrIt = sortedAttr.iterator();
            }
            if (attrIt != null) {
                while (attrIt.hasNext()) {
                    StringBuffer buffy;
                    Object name = attrIt.next();
                    if (this.ignoreAttributes.contains(name)) continue;
                    this.writeIndent(indent);
                    Object value = attr.getAttribute(name);
                    if (value instanceof Dag) {
                        this.writeDag(name, (Dag)value);
                        continue;
                    }
                    if (value != null && this.maxAttributeLength >= 0 && (buffy = new StringBuffer(value.toString())).length() > this.maxAttributeLength) {
                        buffy.setLength(this.maxAttributeLength);
                        buffy.append(ELLIPSIS);
                        value = buffy.toString();
                    }
                    this.out.println(name + "=" + value);
                }
            }
        }
        catch (Exception e) {
            WmiErrorLog.log(e);
        }
        return hasAttributes;
    }

    public void ignoreAttribute(Object key) {
        this.ignoreAttributes.add(key);
    }

    public void ignoreZeroLengthModel(WmiModelTag tag) {
        this.zlTagIgnore = true;
        this.ignoreZeroLength.add(tag);
    }

    public void report(WmiModel root, boolean verbose) throws WmiNoReadAccessException {
        this.report(root, verbose, 2);
    }

    public void report(WmiModel root, boolean verbose, int indent) throws WmiNoReadAccessException {
        this.report(root, verbose, indent, null);
    }

    public void report(WmiMathDocumentModel doc, boolean verbose, WmiModelPathInterval span) throws WmiNoReadAccessException {
        WeakHashMap modelsMap = null;
        try {
            try {
                WmiModel root = doc;
                if (span != null) {
                    modelsMap = new WeakHashMap();
                    WmiModelSelectionWriter walker = new WmiModelSelectionWriter(modelsMap);
                    span.walkInterval(doc, walker);
                    WmiModelPath rootPath = WmiModelPath.commonParent(span.getLowerBound(), span.getUpperBound());
                    root = rootPath.getModelPosition(doc).getModel();
                }
                this.report(root, verbose, 2, modelsMap);
            }
            catch (NullPointerException nullPointerException) {
                if (modelsMap != null) {
                    modelsMap.clear();
                }
                if (this.out != null) {
                    this.out.flush();
                }
            }
        }
        finally {
            if (modelsMap != null) {
                modelsMap.clear();
            }
            if (this.out != null) {
                this.out.flush();
            }
        }
    }

    public void reportStyleTable(WmiMathDocumentModel doc, boolean verbose, int indent) throws WmiNoReadAccessException {
        try {
            Iterator layoutStyles;
            Iterator fontStyles = doc.getFontStyleNames();
            if (fontStyles.hasNext()) {
                this.writeIndent(indent);
                this.out.print(verbose ? "<" : ">");
                this.out.print(FONT_TABLE);
                if (verbose) {
                    this.out.print(">");
                }
                this.out.println();
                TreeSet sortedFonts = new TreeSet();
                while (fontStyles.hasNext()) {
                    sortedFonts.add(fontStyles.next());
                }
                fontStyles = sortedFonts.iterator();
                while (fontStyles.hasNext()) {
                    this.writeIndent(indent + 2);
                    String name = (String)fontStyles.next();
                    WmiFontAttributeSet font = doc.getFontStyle(name);
                    this.out.print(name);
                    if (verbose) {
                        this.writeVerboseAttributes(font, indent + 2 + 1);
                        continue;
                    }
                    this.out.println();
                }
                this.writeIndent(indent);
                this.out.print(verbose ? "</" : "<");
                this.out.print(FONT_TABLE);
                if (verbose) {
                    this.out.print(">");
                }
                this.out.println();
            }
            if ((layoutStyles = doc.getLayoutStyleNames()).hasNext()) {
                this.writeIndent(indent);
                this.out.print(verbose ? "<" : ">");
                this.out.print(LAYOUT_TABLE);
                if (verbose) {
                    this.out.print(">");
                }
                this.out.println();
                TreeSet sortedLayouts = new TreeSet();
                while (layoutStyles.hasNext()) {
                    sortedLayouts.add(layoutStyles.next());
                }
                layoutStyles = sortedLayouts.iterator();
                while (layoutStyles.hasNext()) {
                    this.writeIndent(indent + 2);
                    String name = (String)layoutStyles.next();
                    WmiLayoutAttributeSet layout = doc.getLayoutStyle(name);
                    this.out.print(name);
                    if (verbose) {
                        this.writeVerboseAttributes(layout, indent + 2 + 1);
                        continue;
                    }
                    this.out.println();
                }
                this.writeIndent(indent);
                this.out.print(verbose ? "</" : "<");
                this.out.print(LAYOUT_TABLE);
                if (verbose) {
                    this.out.print(">");
                }
                this.out.println();
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void resetIgnoreAttributes() {
        this.ignoreAttributes.clear();
    }

    public void setMaximumAttributeLength(int value) {
        this.maxAttributeLength = value;
    }

    public void setProcessStyleTable(boolean newValue) {
        this.processStyles = newValue;
    }

    protected static class WmiModelSelectionWriter
    implements WmiModelPathInterval.WmiModelPathWalker {
        private WeakHashMap modelsMap;

        protected WmiModelSelectionWriter(WeakHashMap modelsMap) {
            this.modelsMap = modelsMap;
        }

        @Override
        public void visitModel(WmiModel model, boolean fullySelected) {
            this.modelsMap.put(model, new Boolean(fullySelected |= model instanceof WmiTextModel));
        }
    }
}

