/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiLayoutAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextContainingModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import java.util.ArrayList;

public class WmiParagraphModel
extends WmiAbstractArrayCompositeModel
implements WmiTextContainingModel {
    public WmiParagraphModel(WmiMathDocumentModel doc) {
        super(doc);
    }

    public WmiParagraphModel(WmiMathDocumentModel doc, WmiModel[] children) throws WmiInvalidModelInitializationException {
        super(doc, children);
    }

    public WmiParagraphModel createEmptyParagraph() throws WmiNoWriteAccessException, WmiNoReadAccessException {
        WmiParagraphModel newParagraph = new WmiParagraphModel(this.getDocument());
        WmiAttributeSet set = this.getAttributesForRead();
        newParagraph.setAttributes(set.copyAttributes());
        return newParagraph;
    }

    @Override
    public void getAllText(StringBuffer buffer) throws WmiNoReadAccessException {
        if (buffer != null) {
            int t = 0;
            while (t < this.getChildCount()) {
                WmiModel child = this.getChild(t);
                if (child instanceof WmiTextContainingModel) {
                    ((WmiTextContainingModel)((Object)child)).getAllText(buffer);
                }
                ++t;
            }
        }
    }

    public ArrayList extractText() throws WmiNoReadAccessException {
        ArrayList list = new ArrayList();
        WmiParagraphModel.extractText(list, this);
        return list;
    }

    private static void extractText(ArrayList list, WmiCompositeModel composite) throws WmiNoReadAccessException {
        int t = 0;
        while (t < composite.getChildCount()) {
            WmiModel child = composite.getChild(t);
            if (child instanceof WmiTextModel) {
                list.add(child);
            } else if (child instanceof WmiCompositeModel && !(child instanceof WmiMathWrapperModel)) {
                WmiParagraphModel.extractText(list, (WmiCompositeModel)child);
            }
            ++t;
        }
    }

    public boolean isEmpty() throws WmiNoReadAccessException {
        return this.isEmpty(null);
    }

    public boolean isEmpty(WmiModel ignore) throws WmiNoReadAccessException {
        boolean empty = false;
        int kids = this.getChildCount();
        if (kids == 0) {
            empty = true;
        } else {
            empty = true;
            int i = 0;
            while (i < kids && empty) {
                WmiModel child = this.getChild(i);
                if (child != ignore) {
                    empty = child instanceof WmiTextModel ? ((WmiTextModel)child).getLength() == 0 : (child instanceof WmiMathWrapperModel ? ((WmiMathWrapperModel)child).isEmptyMath() : false);
                }
                ++i;
            }
        }
        return empty;
    }

    public void updateLayoutStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiAttributeSet set = this.getAttributes();
        if (set instanceof WmiLayoutAttributeSet) {
            ((WmiLayoutAttributeSet)set).setNamedLayoutStyle(name, this.getDocument());
            this.addAttributes(set);
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiLayoutAttributeSet();
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.PARAGRAPH;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        try {
            this.guaranteeInsertPoints();
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        super.update(undoName);
    }

    protected void guaranteeInsertPoints() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int i = 0;
        while (i < this.getChildCount()) {
            WmiModel child = this.getChild(i);
            if (!this.isTextOrMath(child)) {
                if (i > 0) {
                    if (!this.isTextOrMath(this.getChild(i - 1))) {
                        this.addChild(this.createFillModel(), i);
                    }
                } else {
                    this.addChild(this.createFillModel(), 0);
                }
            }
            ++i;
        }
        if (this.getChildCount() > 0 && !this.isTextOrMath(this.getChild(this.getChildCount() - 1)) || this.getChildCount() == 0) {
            this.appendChild(this.createFillModel());
        }
    }

    protected boolean isTextOrMath(WmiModel model) {
        boolean result = model instanceof WmiTextModel || model instanceof WmiMathWrapperModel;
        return result;
    }

    protected WmiModel createFillModel() throws WmiNoReadAccessException {
        WmiFontAttributeSet attrs = new WmiFontAttributeSet();
        attrs.addAttributes(this.getAttributes());
        return new WmiTextModel(this.getDocument(), "", attrs);
    }

    @Override
    public String getAllText() throws WmiNoReadAccessException {
        StringBuffer text = new StringBuffer();
        this.getAllText(text);
        return text.toString();
    }

    @Override
    public int getLength() throws WmiNoReadAccessException {
        int length = 0;
        int t = 0;
        while (t < this.getChildCount()) {
            WmiModel child = this.getChild(t);
            if (child instanceof WmiTextContainingModel) {
                length += ((WmiTextContainingModel)((Object)child)).getLength();
            }
            ++t;
        }
        return length;
    }

    @Override
    public WmiModelPosition getModelPosition(int offset, boolean before) throws WmiNoReadAccessException {
        int nKids = this.getChildCount();
        int charCount = 0;
        WmiModelPosition position = null;
        int k = 0;
        while (k < nKids) {
            WmiTextContainingModel textChild;
            int length;
            WmiModel child = this.getChild(k);
            if (child instanceof WmiTextContainingModel && (length = (textChild = (WmiTextContainingModel)((Object)child)).getLength()) > 0) {
                if (!before && charCount == offset) {
                    position = textChild.getModelPosition(0, before);
                    break;
                }
                if (before && charCount + length == offset) {
                    position = textChild.getModelPosition(length, before);
                    break;
                }
                if (offset - charCount < length) {
                    position = textChild.getModelPosition(offset - charCount, before);
                    break;
                }
                charCount += length;
            }
            ++k;
        }
        return position;
    }
}

