/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiCompositeUndoableEdit;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;

public abstract class WmiSnapshotUndoableEdit
extends WmiCompositeUndoableEdit {
    private WmiModel[] originals;
    private WmiUndoableEdit[] snapshotEdits;

    protected WmiSnapshotUndoableEdit(String name, WmiModel snapshot) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        this(name, new WmiModel[]{snapshot});
    }

    protected WmiSnapshotUndoableEdit(String name, WmiModel[] snapshot) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        super(name);
        this.originals = new WmiModel[snapshot.length];
        this.snapshotEdits = new WmiUndoableEdit[snapshot.length];
        int i = 0;
        while (i < this.originals.length) {
            this.originals[i] = snapshot[i];
            this.snapshotEdits[i] = this.createUndoableEdit(this.originals[i]);
            ++i;
        }
    }

    protected abstract WmiUndoableEdit createUndoableEdit(WmiModel var1) throws WmiNoReadAccessException;

    @Override
    public void redo() throws WmiNoUpdateAccessException {
        this.swapCurrentWithSnapshot();
    }

    @Override
    public void undo() throws WmiNoUpdateAccessException {
        this.swapCurrentWithSnapshot();
    }

    private void swapCurrentWithSnapshot() throws WmiNoUpdateAccessException {
        int j = 0;
        while (j < this.originals.length) {
            WmiUndoableEdit previous = this.snapshotEdits[j];
            if (this.originals[j] instanceof WmiAbstractModel) {
                try {
                    this.snapshotEdits[j] = this.createUndoableEdit(this.originals[j]);
                }
                catch (WmiNoReadAccessException nrae) {
                    WmiErrorLog.log(nrae);
                }
            }
            if (previous != null) {
                previous.undo();
            }
            ++j;
        }
    }

    @Override
    protected void addEdit(WmiUndoableEdit edit) {
    }
}

