/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPathInterval;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiTextModel;

public class WmiTextCollector
implements WmiModelPathInterval.WmiModelPathWalker {
    protected StringBuffer sb = null;
    protected int offset = -1;
    protected WmiModel indexModel = null;
    protected WmiModelPosition startPosition = null;
    protected WmiModelPosition endPosition = null;

    public WmiTextCollector(WmiModelPosition start, WmiModelPosition end) {
        this.startPosition = start;
        this.endPosition = end;
        this.sb = new StringBuffer();
    }

    public WmiTextCollector(WmiModel model) {
        this.indexModel = model;
        this.sb = new StringBuffer();
    }

    public WmiTextCollector(StringBuffer buffer) {
        this.sb = buffer;
    }

    public WmiTextCollector() {
        this.sb = new StringBuffer();
    }

    @Override
    public void visitModel(WmiModel model, boolean fullySelected) {
        if (model == this.indexModel) {
            this.offset = this.sb.length();
        }
        if (model instanceof WmiTextModel) {
            try {
                String text = ((WmiTextModel)model).getText();
                if (!fullySelected && this.startPosition != null && this.endPosition != null) {
                    int begin = 0;
                    int end = text.length();
                    if (model.equals(this.startPosition.getModel())) {
                        begin = this.startPosition.getOffset();
                    }
                    if (model.equals(this.endPosition.getModel())) {
                        end = this.endPosition.getOffset() + 1;
                    }
                    if (begin < 0) {
                        begin = 0;
                    }
                    if (end > text.length()) {
                        end = text.length();
                    }
                    if (begin <= end) {
                        this.sb.append(text.substring(begin, end));
                    }
                } else {
                    this.sb.append(text);
                }
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
    }

    public String getCollectedText() {
        return this.sb.toString();
    }

    public int getOffset() {
        return this.offset;
    }
}

