/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model;

import com.maplesoft.mathdoc.controller.insert.MathInsertUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiLocallyHideableModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTextContainingModel;
import com.maplesoft.mathdoc.model.WmiUndoManager;
import com.maplesoft.mathdoc.model.WmiUndoableEdit;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import java.util.ArrayList;

public class WmiTextModel
extends WmiAbstractModel
implements WmiModel,
WmiFontAttributeSource,
WmiLocallyHideableModel,
WmiTextContainingModel {
    private String contents;

    public WmiTextModel(WmiMathDocumentModel doc) {
        this(doc, "");
    }

    public WmiTextModel(WmiMathDocumentModel doc, String contents) {
        this(doc, contents, WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES);
    }

    public WmiTextModel(WmiMathDocumentModel doc, String contents, WmiFontAttributeSet attributes) {
        super(doc);
        this.contents = contents;
        this.attributes = attributes != null ? attributes.pack() : WmiFontAttributeSet.DEFAULT_FONT_ATTRIBUTES;
        this.pending = this;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.TEXT;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        boolean visible = true;
        WmiMathDocumentModel doc = this.getDocument();
        if (doc != null) {
            visible = !doc.isHidden(this);
        }
        return visible;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        if (set instanceof WmiFontAttributeSet) {
            super.setAttributes(set);
        } else {
            WmiErrorLog.log(new Exception("Invalid attribute set"));
        }
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        WmiTextModelEdit edit = null;
        if (undoName != null) {
            edit = new WmiTextModelEdit(this);
            edit.setPreupdateProperties(this.parent, this.attributes, this.contents);
        }
        if (this.pending != null) {
            this.updateValuesFromPending();
        }
        if (edit != null) {
            edit.setPostupdateProperties(this.parent, this.attributes, this.contents);
            WmiUndoManager undoManager = this.getDocument().getUndoManager();
            undoManager.addEdit(edit);
        }
        this.pending = null;
    }

    protected void updateValuesFromPending() throws WmiNoUpdateAccessException {
        this.verifyUpdateLock();
        this.contents = ((WmiTextModel)this.pending).contents;
        if (this.attributes != this.pending.attributes) {
            this.attributes = this.pending.attributes instanceof WmiFontAttributeSet ? ((WmiFontAttributeSet)this.pending.attributes).pack() : this.pending.attributes;
        }
        this.parent = this.pending.parent;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiFontAttributeSet();
    }

    protected WmiTextModel createSubModel(int offset) throws WmiNoReadAccessException {
        return new WmiTextModel(this.getDocument(), this.getText().substring(offset), (WmiFontAttributeSet)this.getAttributes());
    }

    @Override
    public int getLength() throws WmiNoReadAccessException {
        String data = this.getContents();
        return data != null ? data.length() : 0;
    }

    public String getText() throws WmiNoReadAccessException {
        return this.getContents();
    }

    public String getSubstring(int offset, int length) throws WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
        String reply = null;
        String data = this.getContents();
        if (data != null) {
            if (offset < 0) {
                throw new WmiModelIndexOutOfBoundsException(this, offset);
            }
            if (offset + length > data.length()) {
                throw new WmiModelIndexOutOfBoundsException(this, offset + length);
            }
            reply = data.substring(offset, offset + length);
        }
        return reply;
    }

    public char getChar(int pos) throws WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
        String data = this.getContents();
        if (data == null || pos < 0 || pos > data.length()) {
            throw new WmiModelIndexOutOfBoundsException(this, pos);
        }
        return data.charAt(pos);
    }

    public void appendText(String text) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException, WmiNoReadAccessException {
        this.replaceText(text, this.getLength(), 0);
    }

    public void insertText(String text, int pos) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceText(text, pos, 0);
    }

    public void deleteText(int offset, int length) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.replaceText(null, offset, length);
    }

    public void replaceText(String text, int offset, int span) throws WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        this.verifyWriteLock();
        this.createPendingModel();
        if (this.pending instanceof WmiTextModel) {
            WmiTextModel textModel = (WmiTextModel)this.pending;
            String oldContents = textModel.contents;
            if (oldContents == null) {
                oldContents = new String();
            }
            int limit = oldContents.length();
            if (offset < 0 || offset > limit) {
                throw new WmiModelIndexOutOfBoundsException(this, offset);
            }
            if (span < 0) {
                throw new WmiModelIndexOutOfBoundsException(this, span);
            }
            textModel.contents = text != null ? (offset == limit - span ? String.valueOf(oldContents.substring(0, limit - span)) + text : (offset == 0 ? String.valueOf(text) + oldContents.substring(span) : String.valueOf(oldContents.substring(0, offset)) + text + oldContents.substring(offset + span))) : String.valueOf(oldContents.substring(0, offset)) + oldContents.substring(offset + span);
        }
    }

    public WmiTextModel splitModel(int offset) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        return this.splitModel(offset, null);
    }

    public WmiTextModel createSubModel(int startOffset, int endOffset) throws WmiNoReadAccessException {
        WmiTextModel newModel = this.createSubModel(startOffset);
        try {
            newModel.deleteText(endOffset - startOffset, this.getLength() - endOffset);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        return newModel;
    }

    public WmiTextModel splitModel(int offset, ArrayList retokenizeList) throws WmiModelIndexOutOfBoundsException, WmiNoReadAccessException, WmiNoWriteAccessException {
        if (((WmiFontAttributeSet)this.getAttributes()).hasStyle(128)) {
            return this;
        }
        WmiTextModel newModel = this;
        if (offset < 0 || offset > this.getLength()) {
            throw new WmiModelIndexOutOfBoundsException(this, offset);
        }
        if (offset > 0 && offset < this.getLength()) {
            WmiCompositeModel myParent;
            newModel = this.createSubModel(offset);
            this.deleteText(offset, this.getLength() - offset);
            if (WmiModelUtil.findAncestorOfClass(this, WmiMathWrapperModel.class) != null) {
                MathInsertUtil.ensureParentMathRow(new WmiModelPosition(this, offset));
            }
            if ((myParent = this.getParent()) != null) {
                int index = myParent.indexOf(this);
                myParent.addChild(newModel, index + 1);
                WmiInlineMathModel inline = new WmiInlineMathModel(this.getDocument());
                inline.addAttribute("Typesetting:-msemantics", "donotprune");
                myParent.addChild(inline, index + 1);
                if (retokenizeList != null) {
                    retokenizeList.add(new WmiModelPosition(myParent.getChild(index), -1));
                    retokenizeList.add(new WmiModelPosition(myParent.getChild(index + 2), 0));
                }
                myParent.removeChild(inline);
                newModel.setParent(myParent);
            }
        }
        return newModel;
    }

    public void setStyleName(String name) throws WmiNoWriteAccessException {
        this.addAttribute("font_style_name", name);
    }

    protected String getContents() throws WmiNoReadAccessException {
        String data = this.contents;
        this.verifyReadLock();
        if (this.usePending() && this.pending instanceof WmiTextModel) {
            data = ((WmiTextModel)this.pending).contents;
        }
        return data;
    }

    @Override
    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    @Override
    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        this.addAttributes(defSet);
    }

    @Override
    public boolean isGlobalVisible() throws WmiNoReadAccessException {
        boolean visible = true;
        WmiMathDocumentModel doc = this.getDocument();
        if (doc != null) {
            visible = !doc.isHidden(this, false);
        }
        return visible;
    }

    @Override
    public void getAllText(StringBuffer buffer) throws WmiNoReadAccessException {
        buffer.append(this.getContents());
    }

    @Override
    public String getAllText() throws WmiNoReadAccessException {
        return this.getContents();
    }

    @Override
    public WmiModelPosition getModelPosition(int offset, boolean before) throws WmiNoReadAccessException {
        return new WmiModelPosition(this, offset);
    }

    public static class WmiTextModelEdit
    implements WmiUndoableEdit {
        protected WmiTextModel model;
        private WmiCompositeModel oldParent = null;
        private WmiCompositeModel newParent = null;
        private WmiAttributeSet oldAttributes = null;
        private WmiAttributeSet newAttributes = null;
        private String oldContents = null;
        private String newContents = null;

        protected WmiTextModelEdit(WmiTextModel model) {
            this.model = model;
        }

        protected void setPreupdateProperties(WmiCompositeModel parent, WmiAttributeSet attributes, String contents) {
            this.oldParent = parent;
            this.oldAttributes = attributes;
            this.oldContents = contents;
        }

        protected void setPostupdateProperties(WmiCompositeModel parent, WmiAttributeSet attributes, String contents) {
            this.newParent = parent;
            this.newAttributes = attributes;
            this.newContents = contents;
        }

        @Override
        public void undo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.oldParent;
            this.model.attributes = this.oldAttributes;
            this.model.contents = this.oldContents;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }

        @Override
        public void redo() throws WmiNoUpdateAccessException {
            this.model.verifyUpdateLock();
            this.model.parent = this.newParent;
            this.model.attributes = this.newAttributes;
            this.model.contents = this.newContents;
            try {
                this.model.getDocument().notifyModelListeners(this.model, 0);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
    }
}

