/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.graphics2d;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoUpdateAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.graphics.GfxArray;
import com.maplesoft.mathdoc.model.graphics2d.G2DAbstractModel;
import java.awt.Rectangle;

public abstract class G2DBoundedModel
extends G2DAbstractModel {
    private Rectangle cachedBounds = null;

    public G2DBoundedModel(WmiMathDocumentModel doc, GfxArray data) {
        super(doc, data);
        this.updateBounds(data);
    }

    @Override
    public Rectangle getBounds() throws WmiNoReadAccessException {
        return this.cachedBounds;
    }

    protected void updateBounds(GfxArray data) {
        this.cachedBounds = new Rectangle(data.getXValueI(0), data.getYValueI(0), data.getXValueI(1), data.getYValueI(1));
    }

    @Override
    public void setDataArray(GfxArray array) throws WmiNoWriteAccessException {
        super.setDataArray(array);
        if (this.pending != null) {
            ((G2DBoundedModel)this.pending).updateBounds(this.gdata);
        }
    }

    @Override
    public void update(String undoName) throws WmiNoUpdateAccessException {
        if (this.pending != null) {
            this.cachedBounds = ((G2DBoundedModel)this.pending).cachedBounds;
        }
        super.update(undoName);
    }
}

