/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiPrecedenceRules;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;

public abstract class WmiBinaryOperatorBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    private static final int LEFT_SIDE = 0;
    private static final int RIGHT_SIDE = 1;

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        Dag dagA = dag.getChild(0);
        Dag dagB = dag.getChild(1);
        WmiMathModel model = this.createModel(dag, dagA, dagB, this.getOperator(context), docModel, context);
        return model;
    }

    public WmiMathModel createModel(Dag dag, Dag left, Dag right, String op, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathSpaceModel space;
        WmiInlineMathModel model = new WmiInlineMathModel(docModel);
        WmiAbstractArrayCompositeModel composite = model;
        this.buildModelForTerm(dag, docModel, context, composite, left);
        if (this.addMSpacePadding(context)) {
            space = new WmiMathSpaceModel(docModel);
            space.addAttribute("width", "0.5em");
            composite.appendChild(space);
        }
        composite.appendChild(WmiMathFactory.createMathOperatorToken(docModel, op, context));
        if (this.addMSpacePadding(context)) {
            space = new WmiMathSpaceModel(docModel);
            space.addAttribute("width", "0.5em");
            composite.appendChild(space);
        }
        this.buildModelForTerm(dag, docModel, context, composite, right);
        model.setSemantics(this);
        return model;
    }

    protected boolean addMSpacePadding(WmiMathContext context) {
        return false;
    }

    protected void buildModelForTerm(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context, WmiAbstractArrayCompositeModel targetParent, Dag childDag) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel childModel = WmiMathFactory.createMath(docModel, childDag, context);
        if (WmiPrecedenceRules.areBracketsRequired(childDag, dag, this.getPrecedenceRule())) {
            childModel = WmiMathFactory.addBrackets(childModel, context);
        }
        targetParent.appendChild(childModel);
    }

    protected abstract String getOperator(WmiMathContext var1);

    protected int getOperationPrecedence(Dag dag) {
        return DagBuilder.getPrecedence(dag);
    }

    protected int getPrecedenceRule() {
        return 0;
    }

    @Override
    public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
        WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
        int size = composite.getChildCount();
        Dag dag = null;
        if (size == 3) {
            WmiMathModel left = (WmiMathModel)composite.getChild(0);
            WmiMathModel right = (WmiMathModel)composite.getChild(2);
            Dag[] children = new Dag[]{left.toDag(), right.toDag()};
            WmiSemanticDagUtil.fillNullDags(children);
            dag = Dag.createDag(this.getDagType(), children, null, false);
        }
        dag = WmiSemanticDagUtil.handleNullDag(dag, model);
        return dag;
    }

    public abstract int getDagType();
}

