/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

public class WmiDimensionUnit {
    public static final String EM_UNIT = "em";
    public static final String EX_UNIT = "ex";
    public static final String PIXEL_UNIT = "px";
    public static final String INCH_UNIT = "in";
    public static final String CENTIMETRE_UNIT = "cm";
    public static final String CM_UNIT = "cm";
    public static final String MILLIMETRE_UNIT = "mm";
    public static final String MM_UNIT = "mm";
    public static final String POINT_UNIT = "pt";
    public static final String PICA_UNIT = "pc";
    public static final String PERCENT_UNIT = "%";
    public static final int PICAS_TO_PIXELS = 12;
    public static final int INCHES_TO_PIXELS = 72;
    public static final float CENTIMETRES_TO_PIXELS = 28.346457f;
    public static final int CM_TO_MM = 10;
    public static final int PERCENT = 100;
    protected float unitsValue = 0.0f;
    protected String unit;
    protected WmiDimensionUnit defaultUnit;

    protected WmiDimensionUnit(float value, String units, WmiDimensionUnit defaultUnit) {
        this.unitsValue = value;
        this.unit = units;
        this.defaultUnit = defaultUnit;
    }

    public static WmiDimensionUnit createDimension(String specification, WmiDimensionUnit defaultUnit) {
        WmiDimensionUnit newUnit = null;
        if (specification != null && specification.length() > 0) {
            String units;
            int lastDigit = 0;
            int strlen = specification.length();
            boolean foundDigit = false;
            int i = 0;
            while (i < strlen) {
                char ch = specification.charAt(i);
                if (Character.isDigit(ch) || ch == '.' || i == 0 && ch == '-') {
                    lastDigit = i;
                    foundDigit = true;
                }
                ++i;
            }
            String digits = specification.substring(0, lastDigit + 1);
            float unitsValue = 0.0f;
            try {
                unitsValue = Float.parseFloat(digits);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (foundDigit) {
                units = specification.substring(lastDigit + 1).trim();
            } else {
                units = specification;
                unitsValue = 1.0f;
            }
            units = units.toLowerCase();
            newUnit = new WmiDimensionUnit(unitsValue, units, defaultUnit);
        }
        return newUnit;
    }

    public float getUnitsValue() {
        return this.unitsValue;
    }

    public String getUnit() {
        return this.unit;
    }

    public WmiDimensionUnit getDefaultUnit() {
        return this.defaultUnit;
    }

    public String toString() {
        StringBuffer val = new StringBuffer();
        val.append(this.unitsValue);
        if (this.unit != null) {
            val.append(this.unit);
        }
        return val.toString();
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (this == obj) {
            equal = true;
        } else if (obj instanceof WmiDimensionUnit) {
            WmiDimensionUnit ref = (WmiDimensionUnit)obj;
            boolean bl = equal = this.unitsValue == ref.unitsValue;
            if (equal) {
                equal = this.unit != null && ref.unit != null ? this.unit.equals(ref.unit) : this.unit == ref.unit;
            }
        }
        return equal;
    }

    public int hashCode() {
        int code = Float.floatToIntBits(this.unitsValue);
        if (this.unit != null) {
            code ^= this.unit.hashCode();
        }
        return code;
    }
}

