/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagConstants;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiProcBuilder;

public class WmiForStatementBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    private static final int FOR_MINIMUM_MODEL_CHILDREN = 3;
    public static final String FOR_KEYWORD = "for";
    public static final String FROM_KEYWORD = "from";
    public static final String BY_KEYWORD = "by";
    public static final String TO_KEYWORD = "to";
    public static final String WHILE_KEYWORD = "while";
    public static final String IN_KEYWORD = "in";
    public static final String DO_KEYWORD = "do";
    public static final String OD_KEYWORD = "od";
    public static final String END_DO_KEYWORD = "end do";
    private static final int LONG_FORM_LENGTH = 6;
    private static final int FOR_MODEL_LENGTH = 5;
    private static final int LONG_FORM_STATEMENT_INDEX = 5;
    private static final int SHORT_FORM_STATEMENT_INDEX = 3;
    private static final int STATEMENT_MODEL_INDEX = 2;
    private static final int FOR_VAR_INDEX = 0;
    private static final int FROM_VAR_INDEX = 1;
    private static final int BY_VAR_INDEX = 2;
    private static final int LIMIT_VAR_INDEX = 3;
    private static final int CONDITIONAL_VAR_INDEX = 4;
    private static final int FOR_LINE_INDEX = 0;
    private static final int DAG_FOR_CLAUSE_INDEX = 0;
    private static final int DAG_TO_INDEX = 3;
    private static final int DAG_FROM_INDEX = 1;
    private static final int DAG_BY_INDEX = 2;
    private static final int DAG_LONG_STATESEQ_INDEX = 5;
    private static final int DAG_SHORT_STATESEQ_INDEX = 3;
    private static final int DAG_LONG_WHILE_INDEX = 4;
    private static final int DAG_SHORT_WHILE_INDEX = 2;
    private static final int DAG_IN_INDEX = 1;

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel forModel = null;
        int dagLength = dag.getLength();
        int statementDagLocation = 0;
        WmiModel[] children = new WmiMathModel[5];
        if (dagLength == 6) {
            children[0] = this.buildFirstLineLong(dag, docModel, context);
            statementDagLocation = 5;
        } else {
            children[0] = this.buildFirstLineShort(dag, docModel, context);
            statementDagLocation = 3;
        }
        children[1] = WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_INC_LINEBREAK_ATTR);
        children[2] = WmiProcBuilder.createStatementSequenceRow(dag.getChild(statementDagLocation), docModel, context, false);
        children[3] = WmiProcBuilder.createLinebreakIndicator(docModel, WmiProcBuilder.PROC_DEC_LINEBREAK_ATTR);
        children[children.length - 1] = WmiMathFactory.createMathOperatorToken(docModel, WmiProcBuilder.getLongDelimProperty(docModel) ? END_DO_KEYWORD : OD_KEYWORD, context);
        try {
            forModel = new WmiInlineMathModel(docModel, children);
            forModel.setSemantics(this);
        }
        catch (WmiInvalidModelInitializationException e1) {
            WmiErrorLog.log(e1);
        }
        return forModel;
    }

    private WmiMathModel buildFirstLineLong(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel forline = null;
        int childSize = 1;
        Dag forVarDag = dag.getChild(0);
        boolean forPresent = !DagUtil.isNull(forVarDag);
        childSize += forPresent ? 4 : 0;
        Dag fromDag = dag.getChild(1);
        boolean fromPresent = !DagUtil.isOne(fromDag);
        childSize += fromPresent ? 4 : 0;
        Dag incDag = dag.getChild(2);
        boolean byPresent = !DagUtil.isOne(incDag);
        childSize += byPresent ? 4 : 0;
        Dag limDag = dag.getChild(3);
        boolean limPresent = !DagUtil.isNull(limDag);
        childSize += limPresent ? 4 : 0;
        Dag conDag = dag.getChild(4);
        boolean conditionPresent = !DagUtil.isName(conDag) || !DagUtil.isTrue(conDag);
        int n = conditionPresent ? 4 : 0;
        int addIndex = 0;
        WmiModel[] children = new WmiMathModel[childSize += n];
        if (forPresent) {
            children[addIndex++] = WmiMathFactory.createMathOperatorToken(docModel, FOR_KEYWORD, context);
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
            children[addIndex++] = WmiProcBuilder.createStatementSequenceRow(forVarDag, docModel, context, false);
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
        }
        if (fromPresent) {
            children[addIndex++] = WmiMathFactory.createMathOperatorToken(docModel, FROM_KEYWORD, context);
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
            children[addIndex++] = WmiProcBuilder.createStatementSequenceRow(fromDag, docModel, context, false);
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
        }
        if (byPresent) {
            children[addIndex++] = WmiMathFactory.createMathOperatorToken(docModel, BY_KEYWORD, context);
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
            children[addIndex++] = WmiProcBuilder.createStatementSequenceRow(incDag, docModel, context, false);
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
        }
        if (limPresent) {
            children[addIndex++] = WmiMathFactory.createMathOperatorToken(docModel, TO_KEYWORD, context);
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
            children[addIndex++] = WmiProcBuilder.createStatementSequenceRow(limDag, docModel, context, false);
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
        }
        if (conditionPresent) {
            children[addIndex++] = WmiMathFactory.createMathOperatorToken(docModel, WHILE_KEYWORD, context);
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
            children[addIndex++] = WmiProcBuilder.createStatementSequenceRow(conDag, docModel, context, false);
            children[addIndex] = new WmiMathSpaceModel(docModel);
            children[addIndex++].addAttribute("width", "0.5em");
        }
        children[addIndex] = WmiMathFactory.createMathOperatorToken(docModel, DO_KEYWORD, context);
        try {
            forline = new WmiInlineMathModel(docModel, children);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return forline;
    }

    private WmiMathModel buildFirstLineShort(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel forline = null;
        Dag forVar = dag.getChild(0);
        Dag inDag = dag.getChild(1);
        Dag whileDag = dag.getChild(2);
        boolean forPresent = !DagUtil.isNull(forVar);
        boolean inDagPresent = !DagUtil.isOne(inDag);
        boolean whilePresent = !DagUtil.isName(whileDag) || !DagUtil.isTrue(whileDag);
        int appendIndex = 0;
        int childSize = 1;
        childSize += forPresent ? 4 : 0;
        childSize += inDagPresent ? 4 : 0;
        WmiModel[] children = new WmiMathModel[childSize += whilePresent ? 4 : 0];
        if (forPresent) {
            children[appendIndex++] = WmiMathFactory.createMathOperatorToken(docModel, FOR_KEYWORD, context);
            children[appendIndex] = new WmiMathSpaceModel(docModel);
            children[appendIndex++].addAttribute("width", "0.5em");
            children[appendIndex++] = WmiProcBuilder.createStatementSequenceRow(forVar, docModel, context, false);
            children[appendIndex] = new WmiMathSpaceModel(docModel);
            children[appendIndex++].addAttribute("width", "0.5em");
        }
        if (inDagPresent) {
            children[appendIndex++] = WmiMathFactory.createMathOperatorToken(docModel, IN_KEYWORD, context);
            children[appendIndex] = new WmiMathSpaceModel(docModel);
            children[appendIndex++].addAttribute("width", "0.5em");
            children[appendIndex++] = WmiProcBuilder.createStatementSequenceRow(inDag, docModel, context, false);
            children[appendIndex] = new WmiMathSpaceModel(docModel);
            children[appendIndex++].addAttribute("width", "0.5em");
        }
        if (whilePresent) {
            children[appendIndex++] = WmiMathFactory.createMathOperatorToken(docModel, WHILE_KEYWORD, context);
            children[appendIndex] = new WmiMathSpaceModel(docModel);
            children[appendIndex++].addAttribute("width", "0.5em");
            children[appendIndex++] = WmiProcBuilder.createStatementSequenceRow(whileDag, docModel, context, false);
            children[appendIndex] = new WmiMathSpaceModel(docModel);
            children[appendIndex++].addAttribute("width", "0.5em");
        }
        children[appendIndex] = WmiMathFactory.createMathOperatorToken(docModel, DO_KEYWORD, context);
        try {
            forline = new WmiInlineMathModel(docModel, children);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return forline;
    }

    @Override
    public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
        WmiInlineMathModel inline;
        Dag producedDag = null;
        WmiModel source = model;
        while (source instanceof WmiInlineMathModel && ((WmiInlineMathModel)source).getChildCount() == 1) {
            source = ((WmiInlineMathModel)source).getChild(0);
        }
        if (source instanceof WmiInlineMathModel && (inline = (WmiInlineMathModel)source).getChildCount() > 3) {
            WmiModel possibleStatSeq;
            Dag[] forDagChildren = this.createDefaultForDagChildren();
            int statementSequenceIndex = 5;
            int whileIndex = 4;
            WmiModel possibleForLine = this.retrieveForLine(inline);
            if (possibleForLine instanceof WmiInlineMathModel) {
                WmiInlineMathModel forLine = (WmiInlineMathModel)possibleForLine;
                int itlength = forLine.getChildCount();
                int inspectionIndex = 0;
                while (inspectionIndex < itlength) {
                    WmiModel child = forLine.getChild(inspectionIndex);
                    if (child instanceof WmiMathOperatorModel) {
                        String name = ((WmiMathOperatorModel)child).getText();
                        if (name.equals(FOR_KEYWORD)) {
                            inspectionIndex = this.populateChild(forDagChildren, forLine, inspectionIndex, 0);
                        } else if (name.equals(IN_KEYWORD)) {
                            child = forLine.getChild(++inspectionIndex);
                            Dag[] newKids = new Dag[4];
                            newKids[0] = forDagChildren[0];
                            newKids[1] = DagUtil.createExpSeqDag(new Dag[0]);
                            if (child instanceof WmiMathModel) {
                                newKids[1] = ((WmiMathModel)child).toDag();
                            }
                            newKids[2] = forDagChildren[4];
                            newKids[3] = DagUtil.createExpSeqDag(new Dag[0]);
                            forDagChildren = newKids;
                            statementSequenceIndex = 3;
                            whileIndex = 2;
                        } else if (name.equals(WHILE_KEYWORD)) {
                            inspectionIndex = this.populateChild(forDagChildren, forLine, inspectionIndex, whileIndex);
                        } else if (name.equals(FROM_KEYWORD)) {
                            inspectionIndex = this.populateChild(forDagChildren, forLine, inspectionIndex, 1);
                        } else if (name.equals(BY_KEYWORD)) {
                            inspectionIndex = this.populateChild(forDagChildren, forLine, inspectionIndex, 2);
                        } else if (name.equals(TO_KEYWORD)) {
                            inspectionIndex = this.populateChild(forDagChildren, forLine, inspectionIndex, 3);
                        }
                    }
                    ++inspectionIndex;
                }
            }
            if ((possibleStatSeq = this.retrieveForStatSeq(inline)) instanceof WmiMathModel) {
                forDagChildren[statementSequenceIndex] = ((WmiMathModel)possibleStatSeq).toDag();
            }
            producedDag = Dag.createDag(42, forDagChildren, null, false);
        }
        return producedDag;
    }

    private int populateChild(Dag[] forDagChildren, WmiInlineMathModel forLine, int inspectionIndex, int dagIndex) throws WmiNoReadAccessException {
        WmiModel child;
        if ((child = forLine.getChild(++inspectionIndex)) instanceof WmiMathModel) {
            forDagChildren[dagIndex] = ((WmiMathModel)child).toDag();
        }
        return inspectionIndex;
    }

    private WmiModel retrieveForStatSeq(WmiInlineMathModel inline) throws WmiNoReadAccessException {
        WmiInlineMathModel possibleStatSeq = null;
        int i = inline.getChildCount();
        while (i > -1 && possibleStatSeq == null) {
            WmiModel child = inline.getChild(i);
            if (child instanceof WmiInlineMathModel) {
                possibleStatSeq = (WmiInlineMathModel)child;
            }
            --i;
        }
        return possibleStatSeq;
    }

    private WmiModel retrieveForLine(WmiInlineMathModel inline) throws WmiNoReadAccessException {
        WmiModel possibleForLine = inline.getChild(0);
        if (WmiModelUtil.isEmptyIdentifierModel(possibleForLine)) {
            possibleForLine = inline.getChild(1);
        }
        return possibleForLine;
    }

    private Dag[] createDefaultForDagChildren() {
        Dag[] defaultDags = new Dag[]{DagUtil.createExpSeqDag(new Dag[0]), DagConstants.ONE, DagConstants.ONE, DagUtil.createExpSeqDag(new Dag[0]), DagConstants.NAME_TRUE, DagUtil.createExpSeqDag(new Dag[0])};
        return defaultDags;
    }
}

