/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeModel;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.math.WmiCollectionBuilder;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiPowerBuilder;
import com.maplesoft.mathdoc.model.math.WmiSemanticDagUtil;
import com.maplesoft.mathdoc.model.math.WmiSpecialFunctionBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiAbsBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiCentralGlyphBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiCompositionBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiConjugateBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiDiffBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiEvalBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiExpBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiFactorialBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiFloatFunctionBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiFunctionSeriesBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiInfixNotationBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiIntegralBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiLimitBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiLowerCaseBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiModpBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiNeutralOpBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiPiecewiseBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiRtableBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiTableBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiTypesettingBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiUnitBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiVectorBuilder;
import com.maplesoft.mathdoc.model.math.specialfunction.WmiVectorDerivativesBuilder;
import java.util.HashMap;
import java.util.HashSet;

public class WmiFunctionBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String APPLY_FUNCTION = "&ApplyFunction;";
    protected static final int NAME_INDEX = 0;
    protected static final int ARGUMENT_INDEX = 1;
    protected static final String NEUTRAL_OP_START = "&";
    protected static final int NUMBER_NEUTRAL_OP_ARGS = 2;
    protected static final int NEUTRAL_OP_LEFT_ARG = 0;
    protected static final int NEUTRAL_OP_RIGHT_ARG = 1;
    private static HashMap specialFunctionMap = new HashMap();
    private static HashSet elisionSet = new HashSet();
    private WmiNeutralOpBuilder neutralOpBuilder = new WmiNeutralOpBuilder();
    private WmiNeutralOpBuilder.WmiNeutralProdOpBuilder neutralProdOpBuilder = new WmiNeutralOpBuilder.WmiNeutralProdOpBuilder();
    private static final String[] functionsNeedingQuotes = new String[]{"-", "+", "/", "*", "^"};

    static {
        specialFunctionMap.put("abs", new WmiAbsBuilder());
        specialFunctionMap.put("conjugate", new WmiConjugateBuilder());
        specialFunctionMap.put("diff", new WmiDiffBuilder());
        specialFunctionMap.put("Diff", new WmiDiffBuilder(true));
        specialFunctionMap.put("exp", new WmiExpBuilder());
        specialFunctionMap.put("factorial", new WmiFactorialBuilder());
        specialFunctionMap.put("Float", new WmiFloatFunctionBuilder());
        specialFunctionMap.put("int", new WmiIntegralBuilder());
        specialFunctionMap.put("Int", new WmiIntegralBuilder(true));
        specialFunctionMap.put("matrix", new WmiTableBuilder());
        specialFunctionMap.put("Matrix", new WmiTableBuilder());
        specialFunctionMap.put("MATRIX", new WmiTableBuilder());
        specialFunctionMap.put("VECTOR", new WmiTableBuilder());
        specialFunctionMap.put("vector", new WmiTableBuilder());
        specialFunctionMap.put("product", new WmiCentralGlyphBuilder.ProductBuilder());
        specialFunctionMap.put("Product", new WmiCentralGlyphBuilder.ProductBuilder(true));
        specialFunctionMap.put("sqrt", new WmiPowerBuilder());
        specialFunctionMap.put("surd", new WmiPowerBuilder());
        specialFunctionMap.put("sum", new WmiCentralGlyphBuilder.SumBuilder());
        specialFunctionMap.put("Sum", new WmiCentralGlyphBuilder.SumBuilder(true));
        specialFunctionMap.put("RTABLE", new WmiRtableBuilder());
        specialFunctionMap.put("TABLE", new WmiLowerCaseBuilder());
        specialFunctionMap.put("<,>", new WmiVectorBuilder());
        specialFunctionMap.put("<|>", new WmiVectorBuilder());
        specialFunctionMap.put("`<,>`", new WmiVectorBuilder());
        specialFunctionMap.put("`<|>`", new WmiVectorBuilder());
        specialFunctionMap.put("Curl", new WmiVectorDerivativesBuilder("\u00d7"));
        specialFunctionMap.put("Gradient", new WmiVectorDerivativesBuilder(" "));
        specialFunctionMap.put("Divergence", new WmiVectorDerivativesBuilder("\u00b7"));
        specialFunctionMap.put("eval", new WmiEvalBuilder());
        specialFunctionMap.put("Eval", new WmiEvalBuilder(true));
        specialFunctionMap.put("$", new WmiInfixNotationBuilder("$", 13, 2, 2, false, 1));
        specialFunctionMap.put("@", new WmiInfixNotationBuilder("@", 4, 2, Integer.MAX_VALUE, false, 1));
        specialFunctionMap.put(".", new WmiInfixNotationBuilder(".", 4, 2, Integer.MAX_VALUE, false, 1));
        specialFunctionMap.put("mod", new WmiInfixNotationBuilder("mod", 7, 2, 2, true, 1));
        specialFunctionMap.put("in", new WmiInfixNotationBuilder("\u2208", 12, 2, 2, true, 1));
        specialFunctionMap.put("intersect", new WmiInfixNotationBuilder("\u2229", 4, 2, 2, true, 1));
        specialFunctionMap.put("union", new WmiInfixNotationBuilder("\u222a", 6, 2, 2, true, 1));
        specialFunctionMap.put("&+-", new WmiInfixNotationBuilder("\u00b1", 6, 2, 2, true, 1));
        specialFunctionMap.put("subset", new WmiInfixNotationBuilder("\u2286", 8, 2, 2, false, 1));
        specialFunctionMap.put("minus", new WmiInfixNotationBuilder("\u2216", 6, 2, Integer.MAX_VALUE, false, 1));
        specialFunctionMap.put("limit", new WmiLimitBuilder());
        specialFunctionMap.put("Limit", new WmiLimitBuilder(true));
        specialFunctionMap.put("PIECEWISE", new WmiPiecewiseBuilder());
        specialFunctionMap.put("@@", new WmiCompositionBuilder());
        specialFunctionMap.put("Unit", new WmiUnitBuilder());
        specialFunctionMap.put("_SERIES", new WmiFunctionSeriesBuilder());
        specialFunctionMap.put("modp1", new WmiModpBuilder());
        specialFunctionMap.put("modp2", new WmiModpBuilder());
        WmiTypesettingBuilder typeSet = new WmiTypesettingBuilder();
        specialFunctionMap.put("Typesetting:-math", typeSet);
        specialFunctionMap.put("Typesetting:-maligngroup", typeSet);
        specialFunctionMap.put("Typesetting:-malignmark", typeSet);
        specialFunctionMap.put("Typesetting:-mambiguous", typeSet);
        specialFunctionMap.put("Typesetting:-menclose", typeSet);
        specialFunctionMap.put("Typesetting:-merror", typeSet);
        specialFunctionMap.put("Typesetting:-mfail", typeSet);
        specialFunctionMap.put("Typesetting:-mfenced", typeSet);
        specialFunctionMap.put("Typesetting:-mfrac", typeSet);
        specialFunctionMap.put("Typesetting:-mglyph", typeSet);
        specialFunctionMap.put("Typesetting:-mi", typeSet);
        specialFunctionMap.put("Typesetting:-mlabeledtr", typeSet);
        specialFunctionMap.put("Typesetting:-mscripts", typeSet);
        specialFunctionMap.put("Typesetting:-mmultiscripts", typeSet);
        specialFunctionMap.put("Typesetting:-mn", typeSet);
        specialFunctionMap.put("Typesetting:-mo", typeSet);
        specialFunctionMap.put("Typesetting:-mover", typeSet);
        specialFunctionMap.put("Typesetting:-mpadded", typeSet);
        specialFunctionMap.put("Typesetting:-mparsed", typeSet);
        specialFunctionMap.put("Typesetting:-mphantom", typeSet);
        specialFunctionMap.put("Typesetting:-mprescripts", typeSet);
        specialFunctionMap.put("Typesetting:-mprintslash", typeSet);
        specialFunctionMap.put("Typesetting:-mroot", typeSet);
        specialFunctionMap.put("Typesetting:-mrow", typeSet);
        specialFunctionMap.put("Typesetting:-msemantics", typeSet);
        specialFunctionMap.put("Typesetting:-mspace", typeSet);
        specialFunctionMap.put("Typesetting:-msqrt", typeSet);
        specialFunctionMap.put("Typesetting:-mstyle", typeSet);
        specialFunctionMap.put("Typesetting:-ms", typeSet);
        specialFunctionMap.put("Typesetting:-msub", typeSet);
        specialFunctionMap.put("Typesetting:-msubsup", typeSet);
        specialFunctionMap.put("Typesetting:-msup", typeSet);
        specialFunctionMap.put("Typesetting:-mtable", typeSet);
        specialFunctionMap.put("Typesetting:-mtd", typeSet);
        specialFunctionMap.put("Typesetting:-mtext", typeSet);
        specialFunctionMap.put("Typesetting:-mtr", typeSet);
        specialFunctionMap.put("Typesetting:-munder", typeSet);
        specialFunctionMap.put("Typesetting:-munderover", typeSet);
        specialFunctionMap.put("Typesetting:-none", typeSet);
        specialFunctionMap.put("Typesetting:-unknown", typeSet);
        specialFunctionMap.put("Typesetting:-maction", typeSet);
        elisionSet.add("INTERFACE_PLOT");
        elisionSet.add("INTERFACE_PLOT3D");
    }

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiMathModel model = null;
        Dag nameDag = dag.getChild(0);
        Dag argDag = dag.getChild(1);
        String functionName = null;
        if (DagUtil.isName(nameDag)) {
            if (nameDag != null) {
                functionName = nameDag.getData();
            }
        } else if (DagUtil.isMember(nameDag)) {
            functionName = DagBuilder.lPrint(nameDag);
        }
        WmiSpecialFunctionBuilder specialTemplate = null;
        if (!context.useProcRules()) {
            specialTemplate = (WmiSpecialFunctionBuilder)specialFunctionMap.get(functionName);
        }
        if (specialTemplate == null && functionName != null && functionName.startsWith(NEUTRAL_OP_START) && argDag.getLength() == 2) {
            WmiNeutralOpBuilder builder = functionName.equals("&*") ? this.neutralProdOpBuilder : this.neutralOpBuilder;
            model = builder.createModel(dag, argDag.getChild(0), argDag.getChild(1), " " + functionName + " ", docModel, context);
        }
        if (specialTemplate != null && specialTemplate.shouldBeUsed(dag, context)) {
            try {
                model = specialTemplate.createSpecialFunctionModel(docModel, functionName, argDag, context);
            }
            catch (WmiInvalidModelInitializationException ie) {
                WmiErrorLog.log(ie);
            }
        }
        if (model == null) {
            model = this.createGenericFunctionModel(docModel, functionName, nameDag, argDag, context);
        }
        return model;
    }

    private boolean requiresQuotes(String name) {
        boolean quotes = false;
        if (name != null) {
            int i = 0;
            while (i < functionsNeedingQuotes.length && !quotes) {
                if (name.equals(functionsNeedingQuotes[i])) {
                    quotes = true;
                }
                ++i;
            }
        }
        return quotes;
    }

    public WmiMathModel createGenericFunctionModel(WmiMathDocumentModel docModel, String functionName, Dag nameDag, Dag argDag, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel model = new WmiInlineMathModel(docModel);
        WmiAbstractArrayCompositeModel composite = model;
        if (this.requiresQuotes(functionName)) {
            functionName = "`" + functionName + "`";
            nameDag = Dag.createDag(8, null, functionName, false);
        }
        if (functionName != null && functionName.startsWith("INTERFACE_PLOT")) {
            nameDag = Dag.createDag(8, null, functionName.substring(10), false);
        }
        WmiMathModel nameModel = WmiMathFactory.createMath(docModel, nameDag, context);
        if (DagBuilder.getPrecedence(nameDag) >= 4) {
            nameModel = WmiMathFactory.addBrackets(nameModel, context);
        }
        if (elisionSet.contains(functionName)) {
            argDag = DagUtil.createNameDag("...");
        }
        WmiMathModel argsModel = WmiMathFactory.createMath(docModel, argDag, context);
        argsModel = WmiMathFactory.addBrackets(argsModel, context);
        argsModel.setSemantics(new WmiCollectionBuilder.WmiArgsModelBuilder());
        WmiMathTokenModel applyFunctionModel = WmiMathFactory.createMathOperatorToken(docModel, APPLY_FUNCTION, context);
        composite.appendChild(nameModel);
        composite.appendChild(applyFunctionModel);
        composite.appendChild(argsModel);
        model.setSemantics(this);
        return model;
    }

    @Override
    public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
        WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
        WmiMathModel functionName = (WmiMathModel)composite.getChild(0);
        WmiMathModel args = (WmiMathModel)composite.getChild(2);
        Dag[] children = new Dag[]{functionName != null ? functionName.toDag() : null, args != null ? args.toDag() : null};
        WmiSemanticDagUtil.fillNullDags(children);
        return Dag.createDag(18, children, null, false);
    }
}

