/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.client.dag.DagBuilder;
import com.maplesoft.client.dag.DagUtil;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiTransferModel;
import com.maplesoft.mathdoc.model.WmiValidForTypeMK;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiAssignedSemantics;
import com.maplesoft.mathdoc.model.math.WmiFractionModel;
import com.maplesoft.mathdoc.model.math.WmiMathActionAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathActionModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFencedModel;
import com.maplesoft.mathdoc.model.math.WmiMathGlyphModel;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathPaddedModel;
import com.maplesoft.mathdoc.model.math.WmiMathPhantomModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;
import com.maplesoft.mathdoc.model.math.WmiMathStringModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import com.maplesoft.mathdoc.model.math.WmiOverModel;
import com.maplesoft.mathdoc.model.math.WmiRootModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;
import com.maplesoft.mathdoc.model.math.WmiUnderModel;
import com.maplesoft.mathdoc.model.math.WmiUnderOverModel;
import com.maplesoft.util.encoder.UnicodeEscapeEncoder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class WmiImpliedSemantics
implements WmiMathSemantics {
    private static final String SHORT_SEMANTICS = "msemantics";
    private static final HashMap TAG_TO_FUNCTION_NAMES = new HashMap();
    private static final HashMap TAG_TO_VALID_ATTRIBUTES = new HashMap();
    private static final HashSet DO_NOT_REPORT_FOR_NON_ATOMIC = new HashSet();
    public static final HashMap ATTRIBUTE_ALIAS_MAP = new HashMap();
    private static final int FUNCTION_DAG_SIZE = 2;
    private static final int FUNCTION_NAME_INDEX = 0;
    private static final int FUNCTION_ARGS_INDEX = 1;
    private static final int BASE_TEXT_MODEL_DAG_SIZE = 1;
    private static final int EQUATION_DAG_SIZE = 2;
    private static final int LHS = 0;
    private static final int RHS = 1;
    private static final int FIRST_DAG_ARGUMENT = 0;
    public static final boolean DO_NOT_USE_MVERBATIM = false;
    public static final boolean USE_MVERBATIM = true;
    public static final boolean FOR_SAVE = true;
    public static final boolean NOT_FOR_SAVE = false;
    private static Dag APPLY_FUNCTION_TYPEMK_DAG;
    private static Dag INVISIBLE_TIMES_TYPEMK_DAG;
    private static Dag EMPTY_TYPEMK_DAG;
    private static Dag[] INVISIBLE_TIMES_DAG_ARRAY;
    private static Dag[] APPLY_FUNCTION_DAG_ARRAY;
    private static KeyValuePair[] attributeDagCache;
    private static Dag TYPESETTING_NAME_ATTRIBUTES_DAG;
    private static Dag EMPTY_EXPRSEQ_DAG;

    static {
        TAG_TO_FUNCTION_NAMES.put(WmiModelTag.MATH_NONE, "none");
        WmiImpliedSemantics.storeAttributeList("mfrac", WmiFractionModel.WmiFractionAttributeSet.ATTR_NAMES);
        WmiImpliedSemantics.storeAttributeList("mrow", WmiMathAttributeSet.EXTENDED_KEYS);
        WmiImpliedSemantics.storeAttributeList("mfenced", WmiMathFencedModel.WmiFencedAttributeSet.EXTENDED_KEYS_FENCE);
        WmiImpliedSemantics.storeAttributeList("mambiguous", null);
        WmiImpliedSemantics.storeAttributeList("mroot", WmiRootModel.ATTRS);
        WmiImpliedSemantics.storeAttributeList("msqrt", WmiRootModel.ATTRS);
        WmiImpliedSemantics.storeAttributeList("msup", WmiSuperscriptModel.WmiSuperscriptAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("msub", WmiSubscriptModel.WmiSubscriptAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("munderover", WmiUnderOverModel.WmiUnderOverAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("mover", WmiOverModel.WmiOverAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("munder", WmiUnderModel.WmiUnderAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("msubsup", WmiSubSupModel.WmiSubSupAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("mo", WmiMathOperatorModel.WmiMathOperatorAttributeSet.EXTENDED_KEYS_OPERATOR);
        WmiImpliedSemantics.storeAttributeList("mi", WmiMathAttributeSet.EXTENDED_KEYS);
        WmiImpliedSemantics.storeAttributeList("mglyph", WmiMathGlyphModel.WmiMathGlyphAttributeSet.EXTENDED_KEYS);
        WmiImpliedSemantics.storeAttributeList("mpadded", WmiMathPaddedModel.WmiMathPaddedAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("mphantom", WmiMathPhantomModel.WmiMathPhantomAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("mproxy", null);
        WmiImpliedSemantics.storeAttributeList("mspace", WmiMathSpaceModel.WmiMathSpaceAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("mstyle", WmiMathAttributeSet.EXTENDED_KEYS);
        WmiImpliedSemantics.storeAttributeList("mtext", WmiMathAttributeSet.EXTENDED_KEYS);
        WmiImpliedSemantics.storeAttributeList("merror", WmiMathAttributeSet.EXTENDED_KEYS);
        WmiImpliedSemantics.storeAttributeList("ms", WmiMathStringModel.WmiMathStringAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("mtable", WmiMathTableModel.WmiMathTableAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("mtr", WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("mlabeledtr", WmiMathTableModel.WmiMathTableRowModel.WmiMathTableRowAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("mtd", WmiMathTableModel.WmiMathTableDataModel.WmiMathTableDataAttributeSet.ATTRIBUTES);
        WmiImpliedSemantics.storeAttributeList("mn", WmiMathAttributeSet.EXTENDED_KEYS);
        WmiImpliedSemantics.storeAttributeList("maction", WmiMathActionAttributeSet.MACTION_ATTRIBUTE_KEY_SET);
        WmiImpliedSemantics.storeAttributeList("mmultiscripts", null);
        WmiImpliedSemantics.storeAttributeList("mprescripts", null);
        WmiImpliedSemantics.storeAttributeList("none", null);
        ATTRIBUTE_ALIAS_MAP.put("fontfamily", "family");
        ATTRIBUTE_ALIAS_MAP.put("mathcolor", "foreground");
        ATTRIBUTE_ALIAS_MAP.put("mathbackground", "background");
        ATTRIBUTE_ALIAS_MAP.put("mathsize", "size");
        int i = 0;
        while (i < WmiMathAttributeSet.EXTENDED_KEYS.length) {
            DO_NOT_REPORT_FOR_NON_ATOMIC.add(WmiMathAttributeSet.EXTENDED_KEYS[i]);
            ++i;
        }
        APPLY_FUNCTION_TYPEMK_DAG = null;
        INVISIBLE_TIMES_TYPEMK_DAG = null;
        EMPTY_TYPEMK_DAG = null;
        INVISIBLE_TIMES_DAG_ARRAY = null;
        APPLY_FUNCTION_DAG_ARRAY = null;
        attributeDagCache = new KeyValuePair[30];
        TYPESETTING_NAME_ATTRIBUTES_DAG = null;
        EMPTY_EXPRSEQ_DAG = Dag.createDag(29, null, null, false);
    }

    @Override
    public Dag toDag(WmiMathModel model) throws WmiNoReadAccessException {
        return WmiImpliedSemantics.getDag(model);
    }

    public static Dag getDag(WmiMathModel model) throws WmiNoReadAccessException {
        return WmiImpliedSemantics.getDag(model, true, false);
    }

    public static Dag getDag(WmiMathModel model, boolean useMVerbatim, boolean forSave) throws WmiNoReadAccessException {
        return WmiImpliedSemantics.getDag(model, useMVerbatim, forSave, false);
    }

    public static Dag getDag(WmiMathModel model, boolean useMVerbatim, boolean forSave, boolean useSemantics) throws WmiNoReadAccessException {
        WmiAssignedSemantics assignedSemantics;
        WmiModel child;
        Dag finalDag = null;
        String funcName = WmiImpliedSemantics.prepareFunctionName(model);
        if (funcName.equals("math") && (child = ((WmiCompositeModel)((Object)model)).getChild(0)) instanceof WmiMathModel) {
            model = (WmiMathModel)child;
            funcName = WmiImpliedSemantics.prepareFunctionName(model);
        }
        WmiMathSemantics semantics = model.getSemantics();
        boolean stale = false;
        if (semantics instanceof WmiAssignedSemantics && (assignedSemantics = (WmiAssignedSemantics)semantics).isStale() && !forSave) {
            stale = true;
        }
        Dag dag = null;
        if (useSemantics && (model instanceof WmiTransferModel || model instanceof WmiMathActionModel)) {
            if (model instanceof WmiTransferModel && model.getSemantics() instanceof WmiAssignedSemantics) {
                dag = ((WmiAssignedSemantics)model.getSemantics()).toDag(model);
            }
            if (model instanceof WmiMathActionModel && model.getAttributesForRead().getAttribute("actiontype").equals("maplesoft:numeric_formatting")) {
                WmiMathModel child2 = (WmiMathModel)((WmiCompositeModel)((Object)model)).getChild(0);
                dag = ((WmiAssignedSemantics)model.getSemantics()).toDag(child2);
            }
            if (model instanceof WmiMathActionModel && model.getAttributesForRead().getAttribute("actiontype").equals("browsertable")) {
                dag = ((WmiAssignedSemantics)model.getSemantics()).toDag(model);
            }
        }
        if (dag != null) {
            try {
                WmiMathModel newchild = WmiMathFactory.createMath(model.getDocument(), dag, new WmiMathContext(new WmiFontAttributeSet("2D Output")));
                funcName = WmiImpliedSemantics.prepareFunctionName(newchild);
                AttributeTargetList attrList = (AttributeTargetList)TAG_TO_VALID_ATTRIBUTES.get(funcName);
                if (attrList == null) {
                    throw new IllegalArgumentException("Attempted to convert model " + funcName + " to typesetting.");
                }
                attrList = attrList.copy();
                finalDag = WmiImpliedSemantics.createTypesetting(newchild, funcName, attrList, useMVerbatim, forSave, useSemantics);
            }
            catch (WmiNoReadAccessException e) {
                e.printStackTrace();
            }
            catch (WmiNoWriteAccessException e) {
                e.printStackTrace();
            }
        } else if (useMVerbatim && model.getSemantics() != null && !(model.getSemantics() instanceof WmiImpliedSemantics) && !WmiImpliedSemantics.searchForProvidesOwnTypeMK(model) && !stale) {
            finalDag = WmiImpliedSemantics.createMVerbatim(model.getSemantics(), model);
        } else {
            AttributeTargetList attrList = (AttributeTargetList)TAG_TO_VALID_ATTRIBUTES.get(funcName);
            if (attrList == null) {
                throw new IllegalArgumentException("Attempted to convert model " + funcName + " to typesetting.");
            }
            attrList = attrList.copy();
            finalDag = WmiImpliedSemantics.createTypesetting(model, funcName, attrList, useMVerbatim, forSave, useSemantics);
        }
        return finalDag;
    }

    public static Dag getDag(WmiMathModel model, boolean useMVerbatim) throws WmiNoReadAccessException {
        return WmiImpliedSemantics.getDag(model, useMVerbatim, false);
    }

    private static boolean searchForProvidesOwnTypeMK(WmiModel model) throws WmiNoReadAccessException {
        boolean result = false;
        if (model instanceof WmiValidForTypeMK) {
            result = ((WmiValidForTypeMK)((Object)model)).suppliesOwnTypeMK();
        }
        if (!result && model instanceof WmiCompositeModel) {
            WmiCompositeModel comp = (WmiCompositeModel)model;
            int itlength = comp.getChildCount();
            int i = 0;
            while (i < itlength && !result) {
                result = WmiImpliedSemantics.searchForProvidesOwnTypeMK(comp.getChild(i));
                ++i;
            }
        }
        return result;
    }

    private static Dag createTypesetting(WmiMathModel model, String funcName, AttributeTargetList attrList, boolean useMVerbatim, boolean forSave, boolean useSemantics) throws WmiNoReadAccessException {
        WmiAttributeSet wrapperAttributes;
        WmiAttributeSet attributesObj = model.getAttributesForRead();
        WmiMathWrapperModel wrapper = (WmiMathWrapperModel)WmiModelUtil.findAncestorOfTag((WmiModel)model, WmiModelTag.MATH);
        WmiAttributeSet wmiAttributeSet = wrapperAttributes = wrapper != null ? wrapper.getAttributesForRead() : null;
        if (wrapperAttributes != null) {
            String styleName = (String)wrapperAttributes.getAttribute("font_style_name");
            wrapperAttributes = model.getDocument().getFontStyle(styleName);
        }
        boolean modelReportsAttributes = false;
        if (funcName.equals("mstyle") || funcName.equals("mfenced")) {
            modelReportsAttributes = true;
        } else {
            boolean bl = modelReportsAttributes = WmiMathAttributeSet.testForAtomic(model) && !WmiModelUtil.isEmptyIdentifierModel(model);
        }
        if (attrList != null) {
            Iterator atIt = attrList.iterator();
            while (atIt.hasNext()) {
                Object compare;
                Object key = atIt.next();
                boolean removed = false;
                Object value = attributesObj.getAttribute(key);
                if (value == null) {
                    atIt.remove();
                    removed = true;
                } else if (wrapperAttributes != null && value.equals(wrapperAttributes.getAttribute(key)) && !model.forceSave(key, value)) {
                    atIt.remove();
                    removed = true;
                }
                if (!removed && value.equals(compare = attributesObj.getAttribute(ATTRIBUTE_ALIAS_MAP.get(key.toString())))) {
                    atIt.remove();
                    removed = true;
                }
                if (forSave || modelReportsAttributes || !DO_NOT_REPORT_FOR_NON_ATOMIC.contains(key) || removed) continue;
                atIt.remove();
            }
        }
        Dag[] children = null;
        if (model instanceof WmiCompositeModel) {
            children = WmiImpliedSemantics.constructDagArrayForComposite(model, attrList, useMVerbatim, forSave, useSemantics);
        } else if (model instanceof WmiAbstractMathTokenModel && model.getTag() != WmiModelTag.MATH_SPACE) {
            children = WmiImpliedSemantics.getDagArrayForToken(model, attrList, forSave);
        } else {
            children = new Dag[attrList.getSize()];
            WmiImpliedSemantics.fillAttributes(attributesObj, children, 0, attrList);
        }
        Dag finalDag = WmiImpliedSemantics.getTypeMkFunction(funcName, children);
        return finalDag;
    }

    private static Dag createMVerbatim(WmiMathSemantics semantics, WmiMathModel model) throws WmiNoReadAccessException {
        Dag createdDag = null;
        Dag modelDag = semantics.toDag(model);
        if (modelDag != null) {
            String dotm = DagBuilder.createDotm(modelDag, false);
            Dag stringDotmDag = DagUtil.createStringDag(dotm);
            Dag[] args = new Dag[]{stringDotmDag};
            createdDag = WmiImpliedSemantics.getTypeMkFunction("mverbatim", args);
        }
        return createdDag;
    }

    public static Dag getTypeMkFunction(String funcName, Dag[] arguments) {
        Dag dag = null;
        if (arguments != null && arguments.length > 0 && arguments[0].getType() == 7) {
            String firstArg = arguments[0].getData();
            if (firstArg.length() == 0 && !funcName.equals("mspace") && !funcName.equals("ms")) {
                if (EMPTY_TYPEMK_DAG == null) {
                    EMPTY_TYPEMK_DAG = WmiImpliedSemantics.createTypeMkFunction(funcName, arguments);
                }
                dag = EMPTY_TYPEMK_DAG;
            } else if (firstArg.equals("&ApplyFunction;")) {
                if (APPLY_FUNCTION_TYPEMK_DAG == null) {
                    APPLY_FUNCTION_TYPEMK_DAG = WmiImpliedSemantics.createTypeMkFunction(funcName, arguments);
                }
                dag = APPLY_FUNCTION_TYPEMK_DAG;
            } else if (firstArg.equals("&InvisibleTimes;")) {
                if (INVISIBLE_TIMES_TYPEMK_DAG == null) {
                    INVISIBLE_TIMES_TYPEMK_DAG = WmiImpliedSemantics.createTypeMkFunction(funcName, arguments);
                }
                dag = INVISIBLE_TIMES_TYPEMK_DAG;
            }
        }
        if (dag == null) {
            dag = WmiImpliedSemantics.createTypeMkFunction(funcName, arguments);
        }
        return dag;
    }

    private static Dag createTypeMkFunction(String funcName, Dag[] arguments) {
        Dag[] topLevelChildren = new Dag[2];
        topLevelChildren[0] = Dag.createDag(8, null, funcName, true);
        topLevelChildren[0].setAttributes(WmiImpliedSemantics.getTypesettingNameAttributes());
        topLevelChildren[1] = Dag.createDag(29, arguments, null, false);
        Dag finalDag = Dag.createDag(18, topLevelChildren, null, false);
        return finalDag;
    }

    private static Dag[] constructDagArrayForComposite(WmiMathModel model, AttributeTargetList attrList, boolean useMVerbatim, boolean forSave, boolean useSemantics) throws WmiNoReadAccessException {
        Dag[] children = null;
        Dag[] finalDags = null;
        WmiCompositeModel composite = (WmiCompositeModel)((Object)model);
        int modelChildren = composite.getChildCount();
        int usedChildren = WmiImpliedSemantics.countValidChildren(composite);
        children = new Dag[usedChildren + attrList.getSize()];
        int countKids = 0;
        int i = 0;
        while (i < modelChildren) {
            if (composite.getChild(i) instanceof WmiValidForTypeMK) {
                WmiValidForTypeMK child = (WmiValidForTypeMK)((Object)composite.getChild(i));
                if (child.suppliesOwnTypeMK()) {
                    Dag newTypeMK = child.getTypeMk();
                    if (newTypeMK != null) {
                        children[countKids++] = newTypeMK;
                    }
                } else if (child instanceof WmiMathModel) {
                    if (WmiImpliedSemantics.isValidForTypeMK((WmiModel)((Object)child))) {
                        children[countKids++] = WmiImpliedSemantics.getDag((WmiMathModel)((Object)child), useMVerbatim, forSave, useSemantics);
                    }
                } else {
                    children[countKids++] = WmiImpliedSemantics.createFillDagOnError();
                }
            } else {
                children[countKids++] = WmiImpliedSemantics.createFillDagOnError();
            }
            ++i;
        }
        WmiImpliedSemantics.fillAttributes(model.getAttributes(), children, countKids, attrList);
        int nonNulls = 0;
        int i2 = 0;
        while (i2 < children.length) {
            if (children[i2] != null) {
                ++nonNulls;
            }
            ++i2;
        }
        if (nonNulls > 0 && nonNulls != children.length) {
            finalDags = new Dag[nonNulls];
            int finalIndex = 0;
            int i3 = 0;
            while (i3 < children.length) {
                if (children[i3] != null) {
                    finalDags[finalIndex++] = children[i3];
                }
                ++i3;
            }
        } else {
            finalDags = children;
        }
        return finalDags;
    }

    private static Dag[] getDagArrayForToken(WmiMathModel model, AttributeTargetList attrList, boolean forSave) throws WmiNoReadAccessException {
        Dag[] children = null;
        String text = ((WmiAbstractMathTokenModel)model).getSemanticLabel();
        if (text != null) {
            if (forSave) {
                text = UnicodeEscapeEncoder.convertUnicodeToEscapeSequence(text, false);
            }
            WmiAttributeSet attributes = model.getAttributesForRead();
            if (text.equals("&ApplyFunction;")) {
                if (APPLY_FUNCTION_DAG_ARRAY == null) {
                    APPLY_FUNCTION_DAG_ARRAY = WmiImpliedSemantics.createDagArrayForToken(attributes, text, attrList);
                }
                children = APPLY_FUNCTION_DAG_ARRAY;
            } else if (text.equals("&InvisibleTimes;")) {
                if (INVISIBLE_TIMES_DAG_ARRAY == null) {
                    INVISIBLE_TIMES_DAG_ARRAY = WmiImpliedSemantics.createDagArrayForToken(attributes, text, attrList);
                }
                children = INVISIBLE_TIMES_DAG_ARRAY;
            } else {
                children = WmiImpliedSemantics.createDagArrayForToken(attributes, text, attrList);
            }
        }
        return children;
    }

    private static Dag[] createDagArrayForToken(WmiAttributeSet attributes, String text, AttributeTargetList attrList) throws WmiNoReadAccessException {
        Dag[] children = new Dag[1 + attrList.getSize()];
        children[0] = Dag.createDag(7, null, text, true);
        children[0].setAttributes(EMPTY_EXPRSEQ_DAG);
        WmiImpliedSemantics.fillAttributes(attributes, children, 1, attrList);
        return children;
    }

    private static void fillAttributes(WmiAttributeSet attributes, Dag[] children, int attributePosition, AttributeTargetList attrList) throws WmiNoReadAccessException {
        if (attrList != null) {
            Iterator atIt = attrList.iterator();
            while (atIt.hasNext()) {
                Object key = atIt.next();
                Object value = attributes.getAttribute(key);
                children[attributePosition++] = WmiImpliedSemantics.getAttributeDag(key, value);
            }
        }
    }

    private static Dag getAttributeDag(Object key, Object value) {
        int i = 0;
        while (i < attributeDagCache.length) {
            if (attributeDagCache[i] == null) break;
            if (key.equals(attributeDagCache[i].getKey()) && value.equals(attributeDagCache[i].getValue())) {
                return attributeDagCache[i].getDag();
            }
            ++i;
        }
        Dag keyDag = null;
        if (key != null && "Typesetting:-msemantics".equals(key.toString())) {
            keyDag = Dag.createDag(8, null, SHORT_SEMANTICS, true);
            keyDag.setAttributes(WmiImpliedSemantics.getTypesettingNameAttributes());
        } else {
            keyDag = Dag.createDag(8, null, key, false);
        }
        Dag valDag = Dag.createDag(7, null, value, false);
        Dag eqDag = WmiImpliedSemantics.produceEquationDag(keyDag, valDag);
        if (i < attributeDagCache.length) {
            WmiImpliedSemantics.attributeDagCache[i] = new KeyValuePair(key, value, eqDag);
        }
        return eqDag;
    }

    private static String prepareFunctionName(WmiMathModel model) {
        String funcName = null;
        WmiModelTag functionTag = model.getTag();
        if (TAG_TO_FUNCTION_NAMES.containsKey(functionTag)) {
            funcName = (String)TAG_TO_FUNCTION_NAMES.get(functionTag);
        } else {
            funcName = functionTag.toString().toLowerCase();
            TAG_TO_FUNCTION_NAMES.put(functionTag, funcName);
        }
        return funcName;
    }

    public static int countValidChildren(WmiCompositeModel model) throws WmiNoReadAccessException {
        int total;
        int rtotal = total = model.getChildCount();
        int i = 0;
        while (i < total) {
            if (!WmiImpliedSemantics.isValidForTypeMK(model.getChild(i))) {
                --rtotal;
            }
            ++i;
        }
        return rtotal;
    }

    public static boolean isValidForTypeMK(WmiModel model) throws WmiNoReadAccessException {
        return true;
    }

    private static Dag createFillDagOnError() {
        Dag[] kids = new Dag[2];
        kids[0] = Dag.createDag(8, null, "mi", true);
        kids[0].setAttributes(WmiImpliedSemantics.getTypesettingNameAttributes());
        kids[1] = Dag.createDag(29, new Dag[]{Dag.createDag(7, null, "", false)}, null, false);
        Dag finalDag = Dag.createDag(18, kids, null, false);
        return finalDag;
    }

    private static Dag produceEquationDag(Dag lhs, Dag rhs) {
        Dag[] equationDagChildren = new Dag[]{lhs, rhs};
        Dag created = Dag.createDag(20, equationDagChildren, null, false);
        return created;
    }

    private static Dag getTypesettingNameAttributes() {
        if (TYPESETTING_NAME_ATTRIBUTES_DAG == null) {
            Dag[] attrDags = new Dag[1];
            Dag moduleNameKey = Dag.createDag(8, null, "modulename", true);
            moduleNameKey.setAttributes(EMPTY_EXPRSEQ_DAG);
            Dag typesettingValue = Dag.createDag(8, null, "Typesetting", true);
            Dag syslibAttr = Dag.createDag(8, null, "_syslib", true);
            syslibAttr.setAttributes(EMPTY_EXPRSEQ_DAG);
            typesettingValue.setAttributes(syslibAttr);
            attrDags[0] = WmiImpliedSemantics.produceEquationDag(moduleNameKey, typesettingValue);
            TYPESETTING_NAME_ATTRIBUTES_DAG = Dag.createDag(29, attrDags, null, false);
        }
        return TYPESETTING_NAME_ATTRIBUTES_DAG;
    }

    private static void storeAttributeList(String key, Object[] attrKeys) {
        TAG_TO_VALID_ATTRIBUTES.put(key, new AttributeTargetList(attrKeys));
    }

    public static Dag getDagFromModel(WmiModel model) throws WmiNoReadAccessException {
        WmiValidForTypeMK vtmkModel;
        Dag dag = null;
        if (model instanceof WmiMathModel) {
            dag = ((WmiMathModel)model).toDag();
        } else if (model instanceof WmiValidForTypeMK && (vtmkModel = (WmiValidForTypeMK)((Object)model)).suppliesOwnTypeMK()) {
            dag = vtmkModel.getTypeMk();
        }
        if (dag == null) {
            throw new IllegalArgumentException("toDag attempted with " + model + " which can't be turned into a Dag.");
        }
        return dag;
    }

    private static class AttributeTargetList {
        private static String SEMANTICS_KEY = "Typesetting:-msemantics";
        private static String[] DEFAULT_KEYS = new String[]{SEMANTICS_KEY};
        protected Object[] keys;

        public AttributeTargetList(Object[] keys) {
            if (keys != null) {
                boolean semanticsSeen = false;
                int i = 0;
                while (i < keys.length) {
                    if (keys[i] != null && keys[i].toString().equals(SEMANTICS_KEY)) {
                        semanticsSeen = true;
                        break;
                    }
                    ++i;
                }
                if (semanticsSeen) {
                    this.keys = keys;
                } else {
                    this.keys = new Object[keys.length + 1];
                    System.arraycopy(keys, 0, this.keys, 0, keys.length);
                    this.keys[this.keys.length - 1] = SEMANTICS_KEY;
                }
            } else {
                this.keys = DEFAULT_KEYS;
            }
        }

        protected AttributeTargetList(AttributeTargetList other) {
            if (other != null) {
                this.keys = other.keys;
            }
        }

        public Iterator iterator() {
            throw new UnsupportedOperationException("Can't iterate on a base attr target list. Make a copy first.");
        }

        public AttributeTargetList copy() {
            return this.keys != null && this.keys.length > 0 ? new IterableAttributeTargetList(this) : new NullIterableAttributeTargetList();
        }

        public int getSize() {
            return this.keys.length;
        }

        public String toString() {
            StringBuffer buffy = new StringBuffer();
            buffy.append('[');
            if (this.keys != null) {
                int i = 0;
                while (i < this.keys.length) {
                    buffy.append(this.keys[i]);
                    if (i < this.keys.length - 1) {
                        buffy.append(", ");
                    }
                    ++i;
                }
            }
            buffy.append(']');
            return buffy.toString();
        }

        private static class IterableAttributeTargetList
        extends AttributeTargetList
        implements Iterator,
        Cloneable {
            private BitSet bitset;
            private int iterIndex;
            private int currIndex;

            private IterableAttributeTargetList(AttributeTargetList list) {
                super(list);
                this.bitset = new BitSet(this.keys.length);
                this.iterIndex = 0;
            }

            @Override
            public Iterator iterator() {
                this.iterIndex = this.currIndex = this.bitset.nextClearBit(0);
                return this;
            }

            @Override
            public int getSize() {
                return this.keys.length - this.bitset.cardinality();
            }

            @Override
            public boolean hasNext() {
                return this.iterIndex >= 0 && this.iterIndex < this.keys.length && this.bitset.nextClearBit(this.iterIndex) >= 0;
            }

            public Object next() {
                Object o = this.keys[this.iterIndex];
                this.currIndex = this.iterIndex;
                this.iterIndex = this.bitset.nextClearBit(this.iterIndex + 1);
                return o;
            }

            @Override
            public void remove() {
                this.bitset.set(this.currIndex);
            }

            @Override
            public String toString() {
                return String.valueOf(this.bitset.toString()) + super.toString();
            }
        }

        private static class NullIterableAttributeTargetList
        extends AttributeTargetList
        implements Iterator,
        Cloneable {
            private NullIterableAttributeTargetList() {
                super((AttributeTargetList)null);
            }

            @Override
            public Iterator iterator() {
                return this;
            }

            @Override
            public int getSize() {
                return 0;
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                return null;
            }

            @Override
            public void remove() {
            }
        }
    }

    private static class KeyValuePair
    implements Comparable {
        private Object key;
        private Object value;
        private Dag dag;

        public KeyValuePair(Object key, Object value, Dag dag) {
            this.key = key;
            this.value = value;
            this.dag = dag;
        }

        public int compareTo(Object arg0) {
            if (arg0 == null) {
                return -1;
            }
            String okey = ((KeyValuePair)arg0).key.toString();
            int res = this.key.toString().compareTo(okey);
            if (res == 0) {
                String ovalue = ((KeyValuePair)arg0).value.toString();
                res = this.value.toString().compareTo(ovalue);
            }
            return res;
        }

        public Dag getDag() {
            return this.dag;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

