/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelBuilder;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathSpaceModel;

public class WmiKeyWordBuilder
implements WmiMathModelBuilder,
WmiMathSemantics {
    public static final String SAVE_KEYWORD = "save";
    public static final String READ_KEYWORD = "read";
    public static final String STOP_KEYWORD = "stop";
    public static final String BREAK_KEYWORD = "break";
    public static final String NEXT_KEYWORD = "next";
    public static final String RETURN_KEYWORD = "return";
    public static final String ERROR_KEYWORD = "error";
    private String keyword;

    public WmiKeyWordBuilder(String keyword) {
        this.keyword = keyword;
    }

    @Override
    public WmiMathModel createModel(Dag dag, WmiMathDocumentModel docModel, WmiMathContext context) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiInlineMathModel keywordRow = null;
        int dagLength = dag.getLength();
        int size = dagLength > 0 ? 2 + dagLength : 1;
        WmiModel[] children = new WmiMathModel[size];
        children[0] = WmiMathFactory.createMathOperatorToken(docModel, this.getKeyword(), context);
        if (size > 1) {
            children[1] = new WmiMathSpaceModel(docModel);
            children[1].addAttribute("width", "0.5em");
        }
        int i = 0;
        while (i < dagLength) {
            children[i + 2] = WmiMathFactory.createMath(docModel, dag.getChild(i), context);
            ++i;
        }
        try {
            keywordRow = new WmiInlineMathModel(docModel, children);
        }
        catch (WmiInvalidModelInitializationException e) {
            WmiErrorLog.log(e);
        }
        return keywordRow;
    }

    @Override
    public Dag toDag(WmiMathModel model) {
        return null;
    }

    public String getKeyword() {
        return this.keyword;
    }
}

