/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiMetadataContainer;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathActionAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathWrapperModel;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.StringTokenizer;

public class WmiMathActionModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel {
    public static ActionTable actionTable = new ActionTable();
    public static BuilderTable specialActions = new BuilderTable();
    public static final String DOUBLE_CLICK = "double-click";
    public static final String MOUSE_ENTER = "0-enter-0";
    public static final String MOUSE_EXIT = "0-exit-0";
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private WmiMathSemantics semantics = null;

    public WmiMathActionModel() {
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathActionModel(WmiMathDocumentModel doc) {
        super(doc);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathActionModel(WmiMathDocumentModel doc, WmiModel child) {
        super(doc);
        try {
            this.appendChild(child);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathActionModel(WmiMathDocumentModel doc, WmiModel[] children) throws WmiInvalidModelInitializationException {
        super(doc, children);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public static WmiMathActionModel createTaskWrapper(WmiMathDocumentModel doc, WmiModelPath begin, WmiModelPath end, WmiMetadataContainer tag) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiMathActionModel wrapper = new WmiMathActionModel(doc);
        wrapper.addAttribute("actiontype", "maplesoft:task-placeholder");
        WmiMathActionModel.populateWrapper(doc, begin, end, tag, wrapper);
        return wrapper;
    }

    public static void createAnnotationWrapper(WmiMathDocumentModel doc, WmiModelPath begin, WmiModelPath end, WmiMetadataContainer tag) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiMathActionModel wrapper = new WmiMathActionModel(doc);
        wrapper.addAttribute("actiontype", "maplesoft:annotation-placeholder");
        wrapper.addAttribute("tagID", tag.getId());
        WmiMathActionModel.populateWrapper(doc, begin, end, tag, wrapper);
    }

    protected static void populateWrapper(WmiMathDocumentModel doc, WmiModelPath begin, WmiModelPath end, WmiMetadataContainer tag, WmiMathActionModel wrapper) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        WmiModelPath parentPath = WmiModelPath.commonParent(begin, end);
        WmiModelPosition modelPos = parentPath.getModelPosition(doc);
        WmiModel parentCandidate = modelPos.getModel();
        WmiCompositeModel parentModel = parentCandidate instanceof WmiCompositeModel ? (WmiCompositeModel)parentCandidate : parentCandidate.getParent();
        WmiModelPosition beginPos = begin.getModelPosition(doc);
        WmiModelPosition endPos = end.getModelPosition(doc);
        int startIndex = parentModel.indexOf(beginPos.getModel());
        int endIndex = parentModel.indexOf(endPos.getModel());
        WmiInlineMathModel inlineModel = new WmiInlineMathModel(wrapper.getDocument());
        if (startIndex < 0 || endIndex < 0) {
            WmiCompositeModel grandparentModel = parentModel.getParent();
            if (grandparentModel != null) {
                if (!(grandparentModel instanceof WmiMathWrapperModel)) {
                    startIndex = grandparentModel.indexOf(parentModel);
                    inlineModel.addChild(parentModel, inlineModel.getChildCount());
                    grandparentModel.removeChild(startIndex);
                    parentModel = grandparentModel;
                } else {
                    int i = 0;
                    while (i < parentModel.getChildCount()) {
                        inlineModel.appendChild(parentModel.getChild(i));
                        ++i;
                    }
                    parentModel.removeChildren(0, parentModel.getChildCount());
                    startIndex = 0;
                }
            }
        } else {
            int i = startIndex;
            while (i <= endIndex) {
                inlineModel.addChild(parentModel.getChild(i), inlineModel.getChildCount());
                ++i;
            }
            parentModel.removeChildren(startIndex, endIndex - startIndex + 1);
        }
        wrapper.addChild(inlineModel, 0);
        int i = 0;
        while (i < wrapper.getChildCount()) {
            WmiMathActionModel.dropChildPlaceholderWrappers(wrapper.getChild(i));
            ++i;
        }
        parentModel.addChild(wrapper, startIndex);
        WmiCompositeModel editParentForSemantics = parentModel.getParent();
        while (editParentForSemantics instanceof WmiMathModel) {
            ((WmiMathModel)((Object)editParentForSemantics)).setSemantics(null);
            editParentForSemantics = editParentForSemantics.getParent();
        }
    }

    protected static void dropChildPlaceholderWrappers(WmiModel parent) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        if (parent instanceof WmiMathActionModel) {
            WmiMathActionModel mathActionModel = (WmiMathActionModel)parent;
            WmiMathActionAttributeSet attrs = (WmiMathActionAttributeSet)mathActionModel.getAttributes();
            if (attrs.getAttribute("actiontype") == "maplesoft:task-placeholder") {
                WmiMathActionModel.removeWrapper(mathActionModel);
            }
        } else {
            WmiModel foundWrapper = WmiModelUtil.findFirstDescendantOfTag(parent, WmiModelTag.MATH_ACTION);
            while (foundWrapper != null) {
                WmiMathActionModel mathActionModel = (WmiMathActionModel)foundWrapper;
                WmiMathActionAttributeSet attrs = (WmiMathActionAttributeSet)mathActionModel.getAttributes();
                if (attrs.getAttribute("actiontype") == "maplesoft:task-placeholder") {
                    WmiMathActionModel.removeWrapper(mathActionModel);
                }
                foundWrapper = WmiModelUtil.findFirstDescendantOfTag(parent, WmiModelTag.METATAG_WRAPPER);
            }
        }
    }

    public static void removeWrapper(WmiMathActionModel wrapper) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
        int pi;
        WmiCompositeModel wrapperParent = wrapper.getParent();
        if (wrapperParent != null && (pi = wrapperParent.indexOf(wrapper)) >= 0) {
            wrapperParent.removeChild(pi);
            WmiInlineMathModel inlineModel = (WmiInlineMathModel)wrapper.getChild(0);
            int nKids = 0;
            ArrayList<WmiModel> kids = new ArrayList<WmiModel>();
            int k = 0;
            while (k < inlineModel.getChildCount()) {
                WmiModel child = inlineModel.getChild(k);
                if (!WmiModelUtil.isEmptyIdentifierModel(child)) {
                    kids.add(child);
                    ++nKids;
                }
                ++k;
            }
            wrapperParent.addChildren(kids.toArray(new WmiModel[nKids]), pi);
        }
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathActionAttributeSet();
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_ACTION;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        boolean visible = true;
        WmiMathDocumentModel doc = this.getDocument();
        if (doc != null) {
            visible = !doc.isHidden(this);
        }
        return visible;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return false;
    }

    public static class ActionTable {
        private HashMap actionTypeToTriggers = new HashMap();
        private HashMap actionTypeToCode = new HashMap();

        public void addMapping(String actionType, String triggers, String code) {
            this.actionTypeToTriggers.put(actionType, triggers);
            this.actionTypeToCode.put(actionType, code);
        }

        public boolean isKnownAction(String actionType) {
            return this.actionTypeToCode.containsKey(actionType);
        }

        public boolean isTrigger(String action, String triggerType) {
            Object triggerSet = this.actionTypeToTriggers.get(action);
            HashSet<String> triggers = null;
            if (triggerSet instanceof String) {
                StringTokenizer tok = new StringTokenizer((String)triggerSet);
                triggers = new HashSet<String>();
                while (tok.hasMoreTokens()) {
                    triggers.add(tok.nextToken());
                }
                this.actionTypeToTriggers.put(action, triggers);
            } else {
                triggers = (HashSet<String>)triggerSet;
            }
            return triggers.contains(triggerType);
        }

        public WmiMathActionCommand getActionCode(String action) {
            WmiMathActionCommand command = null;
            try {
                Class<?> c = Class.forName((String)this.actionTypeToCode.get(action));
                command = (WmiMathActionCommand)c.newInstance();
            }
            catch (InstantiationException e) {
                WmiErrorLog.log(e);
            }
            catch (IllegalAccessException e) {
                WmiErrorLog.log(e);
            }
            catch (ClassNotFoundException e) {
                WmiErrorLog.log(e);
            }
            return command;
        }
    }

    public static class BuilderTable {
        private HashMap builders = new HashMap();

        public void addBuilder(String key, WmiSpecialActionBuilder builder) {
            this.builders.put(key, builder);
        }

        public WmiSpecialActionBuilder getBuilder(String key) {
            String tKey = key;
            if (key != null && key.indexOf("(") > -1) {
                tKey = key.substring(0, key.indexOf("("));
            }
            return (WmiSpecialActionBuilder)this.builders.get(tKey);
        }

        public boolean hasBuilder(String key) {
            String tKey = key;
            if (key != null && key.indexOf("(") > -1) {
                tKey = key.substring(0, key.indexOf("("));
            }
            return this.builders.containsKey(tKey);
        }
    }

    public static interface WmiMathActionCommand {
        public void execute(MouseEvent var1, WmiMathActionModel var2, int var3);
    }

    public static interface WmiSpecialActionBuilder {
        public WmiModel buildModel(Dag[] var1, WmiMathDocumentModel var2) throws WmiNoWriteAccessException;
    }
}

