/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiFontLabelRecord;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathFormatOperation;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathTableModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiSubexpressionProxyModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class WmiMathContext {
    private static final String LABEL_PREFIX = "%";
    private static WmiMathFormatOperation[] labelFormatters = new WmiMathFormatOperation[]{new WmiMathFormatOperation.WmiIdentifierFormat(), new WmiMathFormatOperation.WmiKeywordIdentifierFormat(), new WmiMathFormatOperation.WmiNumericFormat(), new WmiMathFormatOperation.WmiOperatorFormat(), new WmiMathFormatOperation.WmiKeywordOperatorFormat(), new WmiMathFormatOperation.WmiBracketOpFormat(), new WmiMathFormatOperation.WmiStringFormat()};
    private static final String ASSUMPTION_TEXT = "With assumptions on ";
    public static final String DEFAULT_IMAGINARY_UNIT = "I";
    public static final int UNKNOWN = 0;
    public static final int OUTPUT = 1;
    public static final int INPUT_2D = 2;
    public static final int TEXT_2D = 3;
    private static HashMap styleMap = new HashMap();
    private static WmiFontLabelRecord defaultRecord = new WmiFontLabelRecord();
    private RuntimeException recoverableErrorPresent;
    private WmiFontAttributeSet style = null;
    private int procCounter = 0;
    private int typesettingCounter = 0;
    private boolean maple11OrLater = true;
    private boolean inOperatorProc;
    private boolean labellingAllowed = false;
    private HashSet assumedVariableSet = new HashSet();
    private Set subexpressionSet = new LinkedHashSet();
    private int labelCount = 0;
    private Map dagToLabelId = new LinkedHashMap();
    private Map idToModel = new LinkedHashMap();
    private boolean splitModel = false;
    private boolean enableMapleSyntaxMapping = true;
    private boolean enableOperatorPadding = true;
    private String formatMask;
    private boolean applyInteger = false;
    private boolean applyRational = false;
    private boolean engineeringNotation = false;
    private boolean inRational = false;
    private boolean applyNumericFormattingOnBuild = false;

    public WmiMathContext(WmiFontAttributeSet style) {
        this.style = style;
        this.labellingAllowed = WmiMathFactory.isSubexpressionLabellingOn();
    }

    public WmiMathModel reportSubexpressions(WmiMathDocumentModel docModel) {
        Iterator keyIt = this.idToModel.keySet().iterator();
        WmiMathTableModel table = new WmiMathTableModel(docModel);
        while (keyIt.hasNext()) {
            Integer id = (Integer)keyIt.next();
            WmiModel[] entryKids = new WmiMathModel[3];
            WmiMathModel proxied = (WmiMathModel)this.idToModel.get(id);
            try {
                entryKids[0] = new WmiSubexpressionProxyModel(docModel, LABEL_PREFIX + id.toString(), proxied, this);
                entryKids[1] = WmiMathFactory.createMathOperatorToken(docModel, "=", this);
                entryKids[2] = proxied;
                WmiMathTableModel.WmiMathTableDataModel entry = new WmiMathTableModel.WmiMathTableDataModel(docModel, new WmiInlineMathModel(docModel, entryKids));
                WmiMathTableModel.WmiMathTableRowModel row = new WmiMathTableModel.WmiMathTableRowModel(docModel, entry);
                table.appendChild(row);
            }
            catch (WmiInvalidModelInitializationException e) {
                WmiErrorLog.log(e);
            }
            catch (WmiNoWriteAccessException e) {
                WmiErrorLog.log(e);
            }
        }
        return table;
    }

    public boolean isSubexpressionLabellingActive() {
        return this.labellingAllowed;
    }

    public boolean needsSubexpressionLabelDetails() {
        return this.idToModel.size() > 0;
    }

    public void addDuplicate(Dag dag) {
        this.subexpressionSet.add(dag);
    }

    public boolean shouldSubExpressionLabel(WmiMathModel model, Dag dag) {
        boolean shouldLabel;
        boolean bl = shouldLabel = this.isSubexpressionLabellingActive() && this.subexpressionSet.contains(dag);
        if (shouldLabel) {
            try {
                int modelWidth = this.estimateModelWidth(model, 0);
                shouldLabel = modelWidth >= WmiMathFactory.getLabelWidth();
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
                shouldLabel = false;
            }
        }
        return shouldLabel;
    }

    private int estimateModelWidth(WmiMathModel model, int width) throws WmiNoReadAccessException {
        if (model instanceof WmiTextModel) {
            width += ((WmiTextModel)((Object)model)).getLength();
        } else if (model instanceof WmiCompositeModel) {
            WmiCompositeModel comp = (WmiCompositeModel)((Object)model);
            int kcount = comp.getChildCount();
            int i = 0;
            while (i < kcount) {
                width = this.estimateModelWidth((WmiMathModel)comp.getChild(i), width);
                ++i;
            }
        }
        return width;
    }

    public WmiMathModel createSubexpressionLabel(WmiMathModel model, Dag dag) {
        Integer id = null;
        if (this.dagToLabelId.containsKey(dag)) {
            id = (Integer)this.dagToLabelId.get(dag);
        }
        if (id == null) {
            id = new Integer(++this.labelCount);
            this.dagToLabelId.put(dag, id);
            this.idToModel.put(id, model);
        }
        return new WmiSubexpressionProxyModel(model.getDocument(), LABEL_PREFIX + id.toString(), model, this);
    }

    public void makeAssumption(String varName) {
        this.assumedVariableSet.add(varName);
    }

    public boolean needsAssumptionSummary() {
        return this.assumedVariableSet.size() > 0;
    }

    public WmiMathModel reportAssumptions(WmiMathDocumentModel doc) {
        StringBuffer assumed = new StringBuffer(ASSUMPTION_TEXT);
        Iterator aIt = this.assumedVariableSet.iterator();
        while (aIt.hasNext()) {
            assumed.append(aIt.next());
            if (!aIt.hasNext()) continue;
            assumed.append(", ");
        }
        WmiMathTokenModel assumptions = WmiMathFactory.createMathIdentifierToken(doc, assumed.toString(), this);
        this.assumedVariableSet.clear();
        return assumptions;
    }

    public WmiFontAttributeSet getStyle() {
        return this.style;
    }

    public boolean isInProc() {
        return this.procCounter > 0;
    }

    public void enableSyntaxMapping(boolean state) {
        this.enableMapleSyntaxMapping = state;
    }

    public void enableOperatorPadding(boolean state) {
        this.enableOperatorPadding = state;
    }

    public boolean isSyntaxMappingEnabled() {
        return this.enableMapleSyntaxMapping;
    }

    public boolean isOperatorPaddingEnabled() {
        return this.enableOperatorPadding;
    }

    public WmiMathAttributeSet createAttributes(int type) {
        WmiMathAttributeSet attrsForType;
        WmiFontLabelRecord rec;
        WmiFontLabelRecord wmiFontLabelRecord = rec = this.style != null ? (WmiFontLabelRecord)styleMap.get(this.style) : defaultRecord;
        if (rec == null) {
            rec = new WmiFontLabelRecord();
            styleMap.put(this.style, rec);
        }
        if (type < 0 || type >= 7) {
            type = 0;
        }
        if ((attrsForType = rec.getAttributesForType(type)) == null) {
            attrsForType = this.style != null ? new WmiMathAttributeSet(this.style) : new WmiMathAttributeSet();
            attrsForType.addAttribute("Typesetting:-msemantics", null);
            labelFormatters[type].format(attrsForType);
            WmiAbstractArrayAttributeSet cached = attrsForType.pack();
            if (cached instanceof WmiMathAttributeSet) {
                attrsForType = (WmiMathAttributeSet)cached;
            }
            rec.setAttributesForType(type, attrsForType);
        }
        return attrsForType;
    }

    public String getImaginaryUnit() {
        return DEFAULT_IMAGINARY_UNIT;
    }

    public void incrementProcCounter() {
        ++this.procCounter;
    }

    public void decrementProcCounter() {
        if (this.procCounter > 0) {
            --this.procCounter;
        }
    }

    public int getProcCount() {
        return this.procCounter;
    }

    public void incrementTypesettingCounter() {
        ++this.typesettingCounter;
    }

    public void decrementTypesettingCounter() {
        if (this.typesettingCounter > 0) {
            --this.typesettingCounter;
        }
    }

    public int getTypesettingCount() {
        return this.typesettingCounter;
    }

    public void setOperatorProc(boolean inOpProc) {
        this.inOperatorProc = inOpProc;
    }

    public boolean isInOperatorProc() {
        return this.inOperatorProc;
    }

    public boolean useProcRules() {
        return this.isInProc() && (!this.isInOperatorProc() || this.procCounter != 1);
    }

    public int getRenderMode() {
        if (this.style == null) {
            return 0;
        }
        String type = this.style.getFontStyleName();
        if ("2D Output".equals(type)) {
            return 1;
        }
        if ("2D Input".equals(type)) {
            return 2;
        }
        return 0;
    }

    public boolean hasRecoverableErrorOccured() {
        return this.recoverableErrorPresent != null;
    }

    public void recordRecoverableError(RuntimeException error) {
        this.recoverableErrorPresent = error;
    }

    public RuntimeException getRecoverableError() {
        RuntimeException toReturn = this.recoverableErrorPresent;
        this.recoverableErrorPresent = null;
        return toReturn;
    }

    public void setSplitModel(boolean split) {
        this.splitModel = split;
    }

    public boolean isSplittingModel() {
        return this.splitModel;
    }

    public String getFormatMask() {
        return this.formatMask;
    }

    public void setFormatMask(String formatMask) {
        this.formatMask = formatMask;
    }

    public boolean isApplyInteger() {
        return this.applyInteger;
    }

    public void setApplyInteger(boolean applyInteger) {
        this.applyInteger = applyInteger;
    }

    public boolean isApplyRational() {
        return this.applyRational;
    }

    public void setApplyRational(boolean applyRational) {
        this.applyRational = applyRational;
    }

    public boolean isInRational() {
        return this.inRational;
    }

    public void setInRational(boolean inRational) {
        this.inRational = inRational;
    }

    public boolean isEngineeringNotation() {
        return this.engineeringNotation;
    }

    public void setEngineeringNotation(boolean engineeringNotation) {
        this.engineeringNotation = engineeringNotation;
    }

    public void setStyle(WmiFontAttributeSet style) {
        this.style = style;
    }

    public boolean isApplyNumericFormattingOnBuild() {
        return this.applyNumericFormattingOnBuild;
    }

    public void setApplyNumericFormattingOnBuild(boolean applyNumericFormattingOnBuild) {
        this.applyNumericFormattingOnBuild = applyNumericFormattingOnBuild;
    }

    public boolean isMaple11OrLater() {
        return this.maple11OrLater;
    }

    public void setMaple11OrLater(boolean maple11OrLater) {
        this.maple11OrLater = maple11OrLater;
    }
}

