/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import java.util.HashMap;

public class WmiMathEncloseModel
extends WmiInlineMathModel {
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiMathEncloseModel(WmiMathDocumentModel doc) {
        super(doc);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathEncloseModel(WmiMathDocumentModel doc, WmiModel[] contents, WmiAttributeSet attributes) throws WmiInvalidModelInitializationException {
        super(doc, contents);
        try {
            this.setAttributes(attributes);
        }
        catch (WmiNoWriteAccessException wae) {
            WmiErrorLog.log(wae);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_ENCLOSE;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathEncloseAttributeSet();
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics == null ? null : this.semantics.toDag(this);
    }

    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        this.addAttributes(defSet);
    }

    @Override
    public boolean useScriptSize(WmiModel child) {
        return false;
    }

    @Override
    public boolean forceSave(Object key, Object value) {
        return false;
    }

    @Override
    public Dag getTypeMk() {
        return null;
    }

    @Override
    public boolean suppliesOwnTypeMK() {
        return false;
    }

    public static class WmiMathEncloseAttributeSet
    extends WmiMathAttributeSet {
        public static final String LONGDIV = "longdiv";
        public static final String ACTUARIAL = "actuarial";
        public static final String RADICAL = "radical";
        public static final String BOX = "box";
        public static final String ROUNDEDBOX = "roundedbox";
        public static final String CIRCLE = "circle";
        public static final String LEFT = "left";
        public static final String RIGHT = "right";
        public static final String TOP = "top";
        public static final String BOTTOM = "bottom";
        public static final String UPDIAGONALSTRIKE = "updiagonalstrike";
        public static final String DOWNDIAGONALSTRIKE = "downdiagonalstrike";
        public static final String VERTICALSTRIKE = "verticalstrike";
        public static final String HORIZONTALSTRIKE = "horizontalstrike";
        private static HashMap keyMap = null;
        public static final String NOTATION = "notation";
        public static final String[] ATTRIBUTES = new String[]{"notation"};
        public static final WmiAttributeKey[] ENCLOSE_KEYS = new WmiAttributeKey[]{new NotationKey()};
        private String notation = "longdiv";
        private boolean isRadical = false;

        public WmiMathEncloseAttributeSet() {
        }

        public WmiMathEncloseAttributeSet(WmiMathEncloseAttributeSet source) {
            this.notation = source.notation;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return ENCLOSE_KEYS;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiMathEncloseAttributeSet(this);
        }

        public String getNotation() {
            return this.notation;
        }

        public boolean isRadical() {
            return this.isRadical;
        }

        @Override
        public void addAttribute(Object key, Object value) {
            if (NOTATION.equals(key)) {
                this.notation = value.toString();
            }
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiMathEncloseAttributeSet) {
                WmiMathEncloseAttributeSet source = (WmiMathEncloseAttributeSet)set;
                this.notation = source.notation;
            }
        }

        public static class NotationKey
        extends WmiStringAttributeKey {
            public NotationKey() {
                super(WmiMathEncloseAttributeSet.NOTATION, "");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathEncloseAttributeSet)set).notation;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathEncloseAttributeSet)set).notation = value;
                if (value.indexOf(WmiMathEncloseAttributeSet.RADICAL) >= 0) {
                    ((WmiMathEncloseAttributeSet)set).isRadical = true;
                }
            }
        }
    }
}

