/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTextModel;
import java.awt.Color;

public class WmiMathErrorModel
extends WmiInlineMathModel {
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiMathErrorModel(WmiMathDocumentModel doc) {
        super(doc);
        this.setForegroundToRed();
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathErrorModel(WmiMathDocumentModel doc, String error) {
        super(doc);
        this.setForegroundToRed();
        this.setSemantics(IMPLIED_SEMANTICS);
        try {
            WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)this.getAttributesForRead());
            WmiMathTextModel text = new WmiMathTextModel(doc, error, context);
            this.appendChild(text);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    private void setForegroundToRed() {
        try {
            WmiFontAttributeSet defSet = (WmiFontAttributeSet)this.getAttributes();
            defSet.addAttribute("foreground", Color.RED);
            this.addAttributes(defSet);
        }
        catch (WmiNoWriteAccessException nwae) {
            WmiErrorLog.log(nwae);
        }
        catch (WmiNoReadAccessException nrae) {
            WmiErrorLog.log(nrae);
        }
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics == null ? null : this.semantics.toDag(this);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_ERROR;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return false;
    }
}

