/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAbstractMathDeleteHandler;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelPath;
import com.maplesoft.mathdoc.model.WmiModelPosition;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathModelUtil;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import java.util.ArrayList;
import java.util.HashMap;

public class WmiMathFencedModel
extends WmiInlineMathModel
implements WmiFontAttributeSource {
    public static final String OPEN = "open";
    public static final String CLOSE = "close";
    public static final String SEPARATORS = "separators";
    public static final int POS_BEFORE_OPEN_BRACKET = 0;
    public static final int POS_AFTER_OPEN_BRACKET = 1;
    public static final int POS_BEFORE_CLOSE_BRACKET = 2;
    public static final int POS_AFTER_CLOSE_BRACKET = 3;
    public static final int POS_UNCHANGED = 4;
    protected WmiMathContext savedContext;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    protected WmiMathTokenModel leftModel;
    protected WmiMathTokenModel rightModel;
    protected WmiMathTokenModel[] sepModel;

    public WmiMathFencedModel(WmiMathDocumentModel doc, WmiModel[] children, WmiMathContext context) throws WmiInvalidModelInitializationException {
        super(doc, children);
        try {
            this.savedContext = context;
            WmiAttributeSet attrs = this.createCompatibleAttributeSet();
            WmiMathAttributeSet style = context.createAttributes(5);
            attrs.addAttributes(style);
            this.setAttributes(attrs);
        }
        catch (WmiNoWriteAccessException nwa) {
            WmiErrorLog.log(nwa);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_FENCED;
    }

    @Override
    public void setAttributes(WmiAttributeSet set) throws WmiNoWriteAccessException {
        super.setAttributes(set);
        try {
            WmiMathOperatorModel right;
            WmiMathOperatorModel left = (WmiMathOperatorModel)this.getModelForLeft();
            if (left != null) {
                left.setAttributes(set);
                this.updateFenceDelimiter(left, set.getAttribute(OPEN), "(");
            }
            if ((right = (WmiMathOperatorModel)this.getModelForRight()) != null) {
                right.setAttributes(set);
                this.updateFenceDelimiter(right, set.getAttribute(CLOSE), ")");
            }
            this.getModelForSeparator(0);
            if (this.sepModel != null) {
                Object sep = set.getAttribute(SEPARATORS);
                String sepString = sep != null ? sep.toString() : null;
                boolean rebuild = false;
                if (sepString == null && this.sepModel.length != 1 || sepString != null && this.sepModel.length != sepString.length()) {
                    this.sepModel = null;
                    this.getModelForSeparator(0);
                    rebuild = true;
                }
                if (rebuild && this.sepModel.length == 1) {
                    this.sepModel[0].setAttributes(set);
                    this.updateFenceDelimiter((WmiMathOperatorModel)this.sepModel[0], sepString, ",");
                } else if (rebuild && this.sepModel.length > 1) {
                    int i = 0;
                    while (i < this.sepModel.length) {
                        this.sepModel[i].setAttributes(set);
                        String separator = Character.toString(sepString.charAt(i));
                        this.updateFenceDelimiter((WmiMathOperatorModel)this.sepModel[i], separator, ",");
                        ++i;
                    }
                }
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public void setAttributes(WmiAttributeSet set, HashMap styleAttrs) throws WmiNoWriteAccessException {
        super.setAttributes(set, styleAttrs);
        try {
            WmiMathOperatorModel right;
            WmiMathOperatorModel left = (WmiMathOperatorModel)this.getModelForLeft();
            if (left != null) {
                left.setAttributes(set);
            }
            if ((right = (WmiMathOperatorModel)this.getModelForRight()) != null) {
                right.setAttributes(set);
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    private void updateFenceDelimiter(WmiMathOperatorModel delimiter, Object value, String defaultValue) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (value == null) {
            value = defaultValue;
        }
        try {
            delimiter.replaceText(value.toString(), 0, delimiter.getLength());
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    public void addAttribute(Object key, Object value) throws WmiNoWriteAccessException {
        super.addAttribute(key, value);
        try {
            String keyLabel = key.toString();
            if (keyLabel != null && keyLabel.equals(OPEN)) {
                this.leftModel = null;
            } else {
                WmiMathModel left = this.getModelForLeft();
                if (left != null) {
                    left.addAttribute(key, value);
                }
            }
            if (keyLabel != null && keyLabel.equals(CLOSE)) {
                this.rightModel = null;
            } else {
                WmiMathModel right = this.getModelForRight();
                if (right != null) {
                    right.addAttribute(key, value);
                }
            }
            if (keyLabel != null && keyLabel.equals(SEPARATORS)) {
                this.sepModel = null;
            } else {
                this.getModelForSeparator(0);
                if (this.sepModel != null) {
                    int i = 0;
                    while (i < this.sepModel.length) {
                        this.sepModel[i].addAttribute(key, value);
                        ++i;
                    }
                }
            }
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        WmiFencedAttributeSet set = new WmiFencedAttributeSet();
        set.setAssociatedModel(this);
        return set;
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    public WmiMathModel getModelForRight() throws WmiNoReadAccessException {
        WmiMathTokenModel model = this.rightModel;
        if (this.rightModel == null) {
            WmiFencedAttributeSet set = (WmiFencedAttributeSet)this.getAttributesForRead();
            this.rightModel = model = this.constructModel(")", set.rightFence);
        }
        return model;
    }

    public WmiMathModel getModelForLeft() throws WmiNoReadAccessException {
        WmiMathTokenModel model = this.leftModel;
        if (this.leftModel == null) {
            WmiFencedAttributeSet set = (WmiFencedAttributeSet)this.getAttributesForRead();
            this.leftModel = model = this.constructModel("(", set.leftFence);
        }
        return model;
    }

    public WmiMathModel getModelForSeparator(int separatorIndex) throws WmiNoReadAccessException {
        if (this.sepModel == null) {
            WmiFencedAttributeSet set = (WmiFencedAttributeSet)this.getAttributesForRead();
            String separator = set.separator;
            if (separator == null) {
                this.sepModel = new WmiMathTokenModel[1];
                this.sepModel[0] = this.constructModel(",", ",");
            } else if (separator.length() > 0) {
                ArrayList<CharSequence> separatorList = new ArrayList<CharSequence>();
                int index = 0;
                boolean isEntity = false;
                StringBuffer sep = new StringBuffer();
                while (index < separator.length()) {
                    char c = separator.charAt(index);
                    if (c == ' ') {
                        ++index;
                        continue;
                    }
                    if (c == '&') {
                        int semicolonIndex = separator.indexOf(";", index);
                        int nextAmpersandIndex = separator.indexOf("&", index + 1);
                        if (semicolonIndex != -1 && semicolonIndex > index + 1 && (nextAmpersandIndex == -1 || nextAmpersandIndex > semicolonIndex)) {
                            isEntity = true;
                        }
                        if (separator.length() > index + 1 && separator.charAt(index + 1) == ' ') {
                            isEntity = false;
                        }
                    }
                    if (!isEntity) {
                        separatorList.add(String.valueOf(c));
                    } else {
                        sep.append(c);
                    }
                    if (c == ';' && isEntity) {
                        separatorList.add(sep);
                        sep = new StringBuffer();
                        isEntity = false;
                    }
                    ++index;
                }
                this.sepModel = new WmiMathTokenModel[separatorList.size()];
                int i = 0;
                while (i < separatorList.size()) {
                    this.sepModel[i] = this.constructModel(separatorList.get(i).toString(), separatorList.get(i).toString());
                    ++i;
                }
            } else {
                this.sepModel = new WmiMathTokenModel[1];
                this.sepModel[0] = this.constructModel("", "");
            }
        }
        return separatorIndex >= this.sepModel.length ? this.sepModel[this.sepModel.length - 1] : this.sepModel[separatorIndex];
    }

    private WmiMathTokenModel constructModel(String defaultStr, String fenceVal) {
        WmiMathTokenModel model = null;
        WmiMathDocumentModel doc = this.getDocument();
        String op = fenceVal == null ? defaultStr : fenceVal;
        try {
            model = WmiMathFactory.createMathOperatorToken(doc, op, this.savedContext);
            model.setParent(this);
            WmiAttributeSet opAtts = model.getAttributes();
            opAtts.addAttributes(this.getAttributesForRead());
            model.setAttributes(opAtts);
        }
        catch (WmiNoReadAccessException nra) {
            WmiErrorLog.log(nra);
        }
        catch (WmiNoWriteAccessException nwa) {
            WmiErrorLog.log(nwa);
        }
        return model;
    }

    @Override
    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    @Override
    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        this.addAttributes(defSet);
        if (this.leftModel != null) {
            this.leftModel.addAttributes(defSet);
        }
        if (this.rightModel != null) {
            this.rightModel.addAttributes(defSet);
        }
    }

    @Override
    public WmiDeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = new WmiMathFencedDeleteHandler(this);
        }
        return this.deleteHandler;
    }

    @Override
    protected void guaranteeInsertPoints() throws WmiNoReadAccessException, WmiNoWriteAccessException {
        if (this.getChildCount() == 0) {
            this.appendChild(new WmiInlineMathModel(this.getDocument()));
        }
    }

    public WmiModelPosition convertToInlineMath(int posIndex) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiModelPosition pos = null;
        int size = this.getChildCount();
        WmiAttributeSet attributes = this.getAttributesForRead();
        WmiMathModel leftFence = null;
        WmiMathModel rightFence = null;
        WmiModel[] separators = new WmiModel[size];
        WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)this.getAttributesForRead());
        if (attributes instanceof WmiFencedAttributeSet) {
            leftFence = this.getModelForLeft();
            rightFence = this.getModelForRight();
            int i = 0;
            while (i < size - 1) {
                separators[i] = this.getModelForSeparator(i);
                ++i;
            }
        }
        int newSize = 2 * size - 1;
        if (leftFence != null) {
            ++newSize;
        }
        if (rightFence != null) {
            ++newSize;
        }
        int i = 0;
        while (i < size) {
            WmiModel child = this.getChild(i);
            if (child.getTag() == WmiModelTag.MATH_ROW) {
                newSize += ((WmiCompositeModel)child).getChildCount() - 1;
            }
            ++i;
        }
        WmiModel[] replacement = new WmiModel[newSize];
        int n = 0;
        if (leftFence != null) {
            String text = ((WmiTextModel)((Object)leftFence)).getText();
            replacement[n++] = new WmiMathOperatorModel(this.getDocument(), text, text, context);
        }
        int i2 = 0;
        while (i2 < size) {
            WmiModel child = this.getChild(i2);
            if (child.getTag() == WmiModelTag.MATH_ROW) {
                WmiCompositeModel comp = (WmiCompositeModel)child;
                int childSize = comp.getChildCount();
                int j = 0;
                while (j < childSize) {
                    replacement[n++] = comp.getChild(j);
                    ++j;
                }
            } else {
                replacement[n++] = this.getChild(i2);
            }
            if (i2 < size - 1) {
                String text = ((WmiTextModel)separators[i2]).getText();
                replacement[n++] = new WmiMathOperatorModel(this.getDocument(), text, text, context);
            }
            ++i2;
        }
        if (rightFence != null) {
            String text = ((WmiTextModel)((Object)rightFence)).getText();
            replacement[n++] = new WmiMathOperatorModel(this.getDocument(), text, text, context);
        }
        WmiCompositeModel parent = this.getParent();
        int index = parent.indexOf(this);
        try {
            if (parent.getTag() == WmiModelTag.MATH_ROW) {
                parent.replaceChildren(replacement, index, 1);
            } else {
                WmiInlineMathModel mrow = new WmiInlineMathModel(this.getDocument());
                parent.replaceChild(mrow, index);
                mrow.addChildren(replacement, 0);
            }
            WmiModel model = null;
            boolean positionBefore = true;
            switch (posIndex) {
                case 0: {
                    model = replacement[0];
                    break;
                }
                case 1: {
                    model = replacement[0];
                    if (leftFence == null) break;
                    positionBefore = false;
                    break;
                }
                case 2: {
                    WmiModel wmiModel = model = replacement.length > 0 ? replacement[replacement.length - 1] : replacement[0];
                    if (rightFence != null) break;
                    positionBefore = false;
                    break;
                }
                case 3: {
                    model = replacement.length > 0 ? replacement[replacement.length - 1] : replacement[0];
                    positionBefore = false;
                }
            }
            while (model instanceof WmiCompositeModel) {
                WmiCompositeModel comp = (WmiCompositeModel)model;
                int compSize = comp.getChildCount();
                if (compSize <= 0) break;
                model = comp.getChild(positionBefore ? 0 : compSize - 1);
            }
            int offset = 0;
            if (!positionBefore && model instanceof WmiTextModel) {
                offset = ((WmiTextModel)model).getLength();
            }
            pos = new WmiModelPosition(model, offset);
        }
        catch (WmiModelIndexOutOfBoundsException e) {
            WmiErrorLog.log(e);
        }
        return pos;
    }

    public static class CloseKey
    extends WmiStringAttributeKey {
        public CloseKey() {
            super(WmiMathFencedModel.CLOSE, null);
        }

        @Override
        public String getStringValue(WmiAttributeSet set) {
            return ((WmiFencedAttributeSet)set).rightFence;
        }

        @Override
        public void setStringValue(WmiAttributeSet set, String value) {
            ((WmiFencedAttributeSet)set).rightFence = ")".equals(value) ? null : value;
        }
    }

    public static class OpenKey
    extends WmiStringAttributeKey {
        public OpenKey() {
            super(WmiMathFencedModel.OPEN, null);
        }

        @Override
        public String getStringValue(WmiAttributeSet set) {
            return ((WmiFencedAttributeSet)set).leftFence;
        }

        @Override
        public void setStringValue(WmiAttributeSet set, String value) {
            ((WmiFencedAttributeSet)set).leftFence = "(".equals(value) ? null : value;
        }
    }

    public static class SeparatorKey
    extends WmiStringAttributeKey {
        public SeparatorKey() {
            super(WmiMathFencedModel.SEPARATORS, null);
        }

        @Override
        public String getStringValue(WmiAttributeSet set) {
            return ((WmiFencedAttributeSet)set).separator;
        }

        @Override
        public void setStringValue(WmiAttributeSet set, String value) {
            ((WmiFencedAttributeSet)set).separator = ",".equals(value) ? null : value;
        }
    }

    public static class WmiFencedAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"open", "close", "separators", "Typesetting:-msemantics"};
        public static final WmiAttributeKey[] FENCED_KEYS = new WmiAttributeKey[]{new OpenKey(), new CloseKey(), new SeparatorKey(), new WmiMathAttributeSet.SemanticsKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS_FENCE = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.getMathKeys(), FENCED_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        private String leftFence = null;
        private String rightFence = null;
        private String separator = null;

        public WmiFencedAttributeSet() {
        }

        public WmiFencedAttributeSet(WmiFencedAttributeSet source) {
            super(source);
            this.rightFence = source.rightFence;
            this.leftFence = source.leftFence;
            this.separator = source.separator;
            this.setSemantics(source.getSemantics());
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiFencedAttributeSet(this);
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiFencedAttributeSet) {
                WmiFencedAttributeSet source = (WmiFencedAttributeSet)set;
                this.rightFence = source.rightFence;
                this.leftFence = source.leftFence;
                this.separator = source.separator;
                this.setSemantics(source.getSemantics());
            }
        }

        protected void setAssociatedModel(WmiMathFencedModel model) {
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiFencedAttributeSet) {
                WmiFencedAttributeSet ref = (WmiFencedAttributeSet)obj;
                equals = true;
                if (this.leftFence != null) {
                    equals = this.leftFence.equals(ref.leftFence);
                }
                if (equals && this.rightFence != null) {
                    equals = this.rightFence.equals(ref.rightFence);
                }
                if (equals && this.separator != null) {
                    equals = this.separator.equals(ref.separator);
                }
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            if (this.leftFence != null) {
                code ^= this.leftFence.hashCode();
            }
            if (this.rightFence != null) {
                code ^= this.rightFence.hashCode();
            }
            if (this.separator != null) {
                code ^= this.separator.hashCode();
            }
            return code;
        }

        public String getLeftFence() {
            return this.leftFence;
        }

        public String getRightFence() {
            return this.rightFence;
        }

        public String getSeparator() {
            return this.separator;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_FENCE;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }
    }

    public static class WmiMathFencedDeleteHandler
    extends WmiAbstractMathDeleteHandler {
        private static final int ON_THE_LEFT = 1;
        private static final int UNSPECIFIED_DELETE = 0;

        private WmiMathFencedDeleteHandler(WmiMathFencedModel arg) {
            this.model = arg;
        }

        @Override
        public void processRestructure(WmiDeleteManager manager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            boolean fenceRemoved = false;
            while (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                WmiModel kid;
                int pos = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                WmiDeletePlaceholderModel placeholder = (WmiDeletePlaceholderModel)this.model.getChild(pos);
                WmiModel deleted = placeholder.getReplacedModel();
                boolean removeOccured = false;
                if (deleted instanceof WmiMathOperatorModel && ((WmiMathOperatorModel)deleted).getText().equals(",") && WmiModelUtil.isEmptyIdentifierModel(kid = this.model.getChild(pos - 1))) {
                    this.model.removeChild(pos - 1);
                    removeOccured = true;
                }
                if (!removeOccured) {
                    this.model.removeChild(pos);
                }
                WmiMathFencedModel fence = (WmiMathFencedModel)this.model;
                WmiMathOperatorModel leftBrace = (WmiMathOperatorModel)fence.getModelForLeft();
                WmiMathOperatorModel rightBrace = (WmiMathOperatorModel)fence.getModelForRight();
                if (deleted == leftBrace) {
                    fenceRemoved = this.processLeftBracketRemoved(manager);
                    continue;
                }
                if (deleted == rightBrace) {
                    fenceRemoved = this.processRightBracketRemoved(manager);
                    continue;
                }
                this.repositionForElementDelete(manager, pos);
            }
            if (!fenceRemoved && this.model.getChildCount() == 0) {
                this.processFenceRemoved(manager);
            }
            this.markParentForDeletion(manager);
        }

        private WmiModel[] createChildrenArray(WmiCompositeModel theModel) throws WmiNoReadAccessException {
            return this.createChildrenArray(theModel, 0);
        }

        private WmiModel[] createChildrenArray(WmiCompositeModel theModel, int type) throws WmiNoReadAccessException {
            WmiCompositeModel fence;
            int count;
            int arraySize = count = theModel.getChildCount();
            if (type == 1) {
                ++arraySize;
            }
            WmiModel[] children = new WmiModel[arraySize];
            int i = 0;
            while (i < count) {
                children[i] = theModel.getChild(i);
                ++i;
            }
            if (type == 1 && theModel.getParent() instanceof WmiMathFencedModel && (fence = theModel.getParent()) instanceof WmiMathFencedModel) {
                children[arraySize - 1] = ((WmiMathFencedModel)fence).getModelForRight();
            }
            return children;
        }

        private WmiModel[] createChildrenListArray(WmiMathOperatorModel firstBracket) throws WmiNoReadAccessException {
            WmiMathFencedModel fence = (WmiMathFencedModel)this.model;
            WmiModel[] children = this.createChildrenArray(this.model);
            int newSize = children.length * 2;
            int currentPos = 0;
            if (firstBracket == null) {
                --newSize;
            }
            WmiModel[] listArray = new WmiModel[newSize];
            if (firstBracket != null) {
                listArray[currentPos++] = firstBracket;
            }
            int childCount = children.length;
            int i = 0;
            while (i < childCount) {
                listArray[currentPos++] = children[i];
                if (i < childCount - 1) {
                    WmiMathOperatorModel seperator = (WmiMathOperatorModel)fence.getModelForSeparator(i);
                    listArray[currentPos++] = seperator;
                }
                ++i;
            }
            return listArray;
        }

        private boolean processLeftBracketRemoved(WmiDeleteManager manager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiMathOperatorModel opKid;
            WmiModel child;
            WmiMathModel insideModel;
            WmiCompositeModel parent = this.model.getParent();
            int index = parent.indexOf(this.model);
            int childCount = this.model.getChildCount();
            WmiModel[] children = null;
            children = childCount == 1 ? ((insideModel = (WmiMathModel)this.model.getChild(0)) instanceof WmiInlineMathModel ? this.createChildrenArray((WmiInlineMathModel)insideModel, 1) : new WmiModel[]{insideModel}) : this.createChildrenListArray(null);
            if (WmiMathModelUtil.requiresMRow(parent)) {
                try {
                    WmiInlineMathModel mrow = new WmiInlineMathModel(parent.getDocument(), children);
                    parent.replaceChild(mrow, index);
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
            } else {
                parent.replaceChildren(children, index, 1);
            }
            if (index > 1 && (child = parent.getChild(index - 1)) instanceof WmiMathOperatorModel && (opKid = (WmiMathOperatorModel)child).getSemanticLabel().equals("&ApplyFunction;")) {
                parent.removeChild(index - 1);
            }
            manager.setModelToReposition(new WmiModelPosition(children[0], 0));
            return true;
        }

        private boolean processRightBracketRemoved(WmiDeleteManager manager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiCompositeModel parent = this.model.getParent();
            int index = parent.indexOf(this.model);
            WmiMathFencedModel fence = (WmiMathFencedModel)this.model;
            WmiMathOperatorModel leftBrace = (WmiMathOperatorModel)fence.getModelForLeft();
            int childCount = this.model.getChildCount();
            WmiModel[] children = null;
            if (childCount == 1) {
                WmiMathModel insideModel = (WmiMathModel)this.model.getChild(0);
                if (insideModel instanceof WmiInlineMathModel) {
                    ((WmiInlineMathModel)insideModel).addChild(leftBrace, 0);
                    children = this.createChildrenArray((WmiInlineMathModel)insideModel);
                } else {
                    children = new WmiModel[]{leftBrace, insideModel};
                }
            } else {
                children = this.createChildrenListArray(leftBrace);
            }
            WmiModel lastChild = null;
            WmiModelPosition repositionTo = null;
            if (WmiMathModelUtil.requiresMRow(parent)) {
                try {
                    WmiInlineMathModel mrow = new WmiInlineMathModel(parent.getDocument(), children);
                    parent.replaceChild(mrow, index);
                }
                catch (WmiInvalidModelInitializationException e) {
                    WmiErrorLog.log(e);
                }
            } else {
                parent.replaceChildren(children, index, 1);
            }
            int numberChildren = children.length;
            lastChild = children[numberChildren - 1];
            if (lastChild instanceof WmiCompositeModel) {
                WmiModelPath endPath = WmiModelUtil.mapEndOfCompositeModel((WmiCompositeModel)lastChild);
                repositionTo = endPath.getModelPosition(this.model.getDocument());
            } else {
                int textLength = 0;
                if (lastChild instanceof WmiTextModel) {
                    textLength = ((WmiTextModel)lastChild).getLength();
                }
                repositionTo = new WmiModelPosition(lastChild, textLength);
            }
            if (repositionTo != null) {
                manager.setModelToReposition(repositionTo);
            }
            return true;
        }

        private void repositionForElementDelete(WmiDeleteManager manager, int index) throws WmiNoReadAccessException {
            if (this.model.getChildCount() > 0) {
                WmiModelPosition reposition = null;
                if (index == 0) {
                    WmiModel newPos = this.model.getChild(0);
                    reposition = new WmiModelPosition(newPos, 0);
                } else {
                    WmiModel newPos = this.model.getChild(index - 1);
                    if (newPos instanceof WmiCompositeModel) {
                        WmiModelPath path = WmiModelUtil.mapEndOfCompositeModel((WmiCompositeModel)newPos);
                        reposition = path.getModelPosition(this.model.getDocument());
                    } else if (newPos instanceof WmiTextModel) {
                        int length = ((WmiTextModel)newPos).getLength();
                        reposition = new WmiModelPosition(newPos, length);
                    }
                }
                if (reposition != null) {
                    manager.setModelToReposition(reposition);
                }
            }
        }

        private void processFenceRemoved(WmiDeleteManager manager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiCompositeModel parent = this.model.getParent();
            int index = parent.indexOf(this.model);
            WmiFontAttributeSet attribs = this.model.getAttributes() instanceof WmiFontAttributeSet ? (WmiFontAttributeSet)this.model.getAttributes() : new WmiMathAttributeSet();
            WmiMathContext context = new WmiMathContext(attribs);
            WmiMathTokenModel identifier = WmiMathFactory.createMathIdentifierToken(this.model.getDocument(), "", context);
            parent.replaceChild(identifier, index);
            manager.setModelToReposition(new WmiModelPosition(identifier, 0));
        }

        @Override
        public boolean forceDeleteHandling() {
            return true;
        }

        @Override
        protected void replaceNonEmptyPlaceholders(WmiDeleteManager manager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            WmiModel replaced;
            WmiModel child;
            if (this.model.getChildCount() == 1 && (child = this.model.getChild(0)) instanceof WmiDeletePlaceholderModel && !WmiModelUtil.isEmptyIdentifierModel(replaced = ((WmiDeletePlaceholderModel)child).getReplacedModel())) {
                this.replaceWithEmptyIdentifier(manager, 0);
            }
        }

        private void markParentForDeletion(WmiDeleteManager manager) throws WmiNoReadAccessException {
            if (this.model.getParent() instanceof WmiInlineMathModel) {
                WmiCompositeModel parent = this.model.getParent();
                manager.mark(parent);
            }
        }
    }
}

