/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.font.WmiFontResolver;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiFontAttributeSource;
import com.maplesoft.mathdoc.model.WmiIntAttributeKey;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiStringAttributeKey;
import com.maplesoft.mathdoc.model.WmiValidForTypeMK;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import java.util.Arrays;
import java.util.HashMap;

public class WmiMathGlyphModel
extends WmiAbstractMathTokenModel
implements WmiMathTokenModel,
WmiFontAttributeSource,
WmiValidForTypeMK {
    private WmiMathSemantics semantics = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    private WmiAbstractMathTokenModel glyphParent = null;

    public WmiMathGlyphModel(WmiMathDocumentModel doc) throws WmiNoWriteAccessException {
        super(doc, " ");
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathGlyphModel(WmiMathDocumentModel doc, String contents, WmiAttributeSet attributes) {
        super(doc, contents);
        try {
            this.setAttributes(attributes);
        }
        catch (WmiNoWriteAccessException wae) {
            WmiErrorLog.log(wae);
        }
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    public int getLength() throws WmiNoReadAccessException {
        WmiMathGlyphAttributeSet attrs = (WmiMathGlyphAttributeSet)this.getAttributesForRead();
        if (attrs.getFontFamily().equals("")) {
            return attrs.getAlt().length();
        }
        return 1;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_GLYPH;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        return true;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathGlyphAttributeSet();
    }

    @Override
    public String getTokenContents() throws WmiNoReadAccessException {
        return null;
    }

    public void setGlyphParent(WmiAbstractMathTokenModel model) throws WmiNoWriteAccessException {
        this.glyphParent = model;
    }

    public WmiAbstractMathTokenModel getGlyphParent() {
        return this.glyphParent;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics == null ? null : this.semantics.toDag(this);
    }

    @Override
    public String getNamedFontStyle() throws WmiNoReadAccessException {
        Object nameObj;
        String name = null;
        WmiAttributeSet attrs = this.getAttributesForRead();
        if (attrs != null && (nameObj = attrs.getAttribute("font_style_name")) != null) {
            name = nameObj.toString();
        }
        return name;
    }

    @Override
    public void updateFontStyle(String name) throws WmiNoReadAccessException, WmiNoWriteAccessException {
        WmiFontAttributeSet defSet = new WmiFontAttributeSet();
        defSet.setNamedFontStyle(name, this.getDocument());
        this.addAttributes(defSet);
    }

    @Override
    public boolean useScriptSize(WmiModel child) {
        return false;
    }

    @Override
    public boolean forceSave(Object key, Object value) {
        return false;
    }

    @Override
    public Dag getTypeMk() {
        return null;
    }

    @Override
    public boolean suppliesOwnTypeMK() {
        return false;
    }

    public static class WmiMathGlyphAttributeSet
    extends WmiMathAttributeSet {
        private static HashMap keyMap = null;
        public static final String ALT = "alt";
        public static final String INDEX = "index";
        public static final String[] ATTRIBUTES = new String[]{"alt", "index"};
        public static final WmiAttributeKey[] GLYPH_KEYS = new WmiAttributeKey[]{new AltKey(), new IndexKey(), new FontFamilyKey()};
        public static final WmiAttributeKey[] EXTENDED_KEYS = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.EXTENDED_KEYS, GLYPH_KEYS);
        private String alt = null;
        private Integer index = new Integer(-1);

        public WmiMathGlyphAttributeSet() {
        }

        public WmiMathGlyphAttributeSet(WmiMathGlyphAttributeSet source) {
            super(source);
            this.alt = source.alt;
            this.index = source.index;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS;
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiMathGlyphAttributeSet(this);
        }

        public String getAlt() {
            return this.alt;
        }

        public String getFontFamily() {
            return (String)this.getAttribute("fontfamily");
        }

        public int getIndex() {
            return this.index != null ? this.index : -1;
        }

        @Override
        public void addAttribute(Object key, Object value) {
            if (ALT.equals(key)) {
                this.alt = value.toString();
            } else if (INDEX.equals(key)) {
                this.index = Integer.decode(value.toString());
            } else {
                super.addAttribute(key, value);
            }
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiMathGlyphAttributeSet) {
                WmiMathGlyphAttributeSet source = (WmiMathGlyphAttributeSet)set;
                this.alt = source.alt;
                this.index = source.index;
            }
        }

        public static class AltKey
        extends WmiStringAttributeKey {
            public AltKey() {
                super(WmiMathGlyphAttributeSet.ALT, "");
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiMathGlyphAttributeSet)set).alt;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                ((WmiMathGlyphAttributeSet)set).alt = value;
            }
        }

        public static class FontFamilyKey
        extends WmiMathAttributeSet.FontFamilyKey {
            @Override
            public String getStringValue(WmiAttributeSet set) {
                return ((WmiFontAttributeSet)set).getFamily();
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                Object[] fonts = WmiFontResolver.getAvailableFontFamilyNames();
                if (Arrays.binarySearch(fonts, value) >= 0) {
                    ((WmiFontAttributeSet)set).setFamily(value);
                } else {
                    ((WmiFontAttributeSet)set).setFamily("");
                }
            }
        }

        public static class IndexKey
        extends WmiIntAttributeKey {
            public IndexKey() {
                super(WmiMathGlyphAttributeSet.INDEX, -1);
            }

            @Override
            public int getIntValue(WmiAttributeSet set) {
                return ((WmiMathGlyphAttributeSet)set).index != null ? ((WmiMathGlyphAttributeSet)set).index.intValue() : this.getDefaultValue();
            }

            @Override
            public void setIntValue(WmiAttributeSet set, int value) {
                ((WmiMathGlyphAttributeSet)set).index = new Integer(value);
            }
        }
    }
}

