/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiInvalidModelInitializationException;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayCompositeMathModel;
import com.maplesoft.mathdoc.model.WmiAbstractMathDeleteHandler;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiDeleteHandler;
import com.maplesoft.mathdoc.model.WmiDeleteManager;
import com.maplesoft.mathdoc.model.WmiDeletePlaceholderModel;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiModelUtil;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiInlineMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathFactory;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiSubSupModel;
import com.maplesoft.mathdoc.model.math.WmiSubscriptModel;
import com.maplesoft.mathdoc.model.math.WmiSuperscriptModel;

public class WmiMathMultiscriptModel
extends WmiAbstractArrayCompositeMathModel
implements WmiMathModel {
    private WmiMathSemantics semantics;
    protected WmiDeleteHandler deleteHandler = null;
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();

    public WmiMathMultiscriptModel(WmiMathDocumentModel doc) {
        super(doc);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathMultiscriptModel(WmiMathDocumentModel doc, WmiModel[] children) throws WmiInvalidModelInitializationException {
        super(doc, children);
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        return new WmiMathAttributeSet();
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_MULTISCRIPTS;
    }

    @Override
    public boolean isVisible() throws WmiNoReadAccessException {
        boolean visible = true;
        WmiMathDocumentModel doc = this.getDocument();
        if (doc != null) {
            visible = !doc.isHidden(this);
        }
        return visible;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return null;
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public WmiDeleteHandler getDeleteHandler() {
        if (this.deleteHandler == null) {
            this.deleteHandler = new WmiMathMultiscriptDeleteHandler(this);
        }
        return this.deleteHandler;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return this.getChildCount() > 0 ? child != this.getChild(0) : false;
    }

    @Override
    public WmiModel getChildInTraversalOrder(int index) throws WmiNoReadAccessException {
        int lengthPrescript;
        int prescriptIndex = this.getPrescriptModelIndex();
        WmiModel returnModel = prescriptIndex > 0 && index > 0 ? (index <= (lengthPrescript = this.getChildCount() - prescriptIndex - 1) ? this.getChild(index + prescriptIndex) : (index < this.getChildCount() ? this.getChild(index - lengthPrescript) : this.getChild(index))) : this.getChild(index);
        return returnModel;
    }

    @Override
    public int indexOfInTraversalOrder(WmiModel child) throws WmiNoReadAccessException {
        int returnIndex;
        int prescriptIndex = this.getPrescriptModelIndex();
        int actualIndex = this.indexOf(child);
        if (prescriptIndex > 0 && actualIndex > 0) {
            int lengthPrescript = this.getChildCount() - prescriptIndex - 1;
            int lengthPostscript = prescriptIndex - 1;
            returnIndex = actualIndex <= lengthPostscript + 1 ? actualIndex + lengthPrescript : (actualIndex < this.getChildCount() ? actualIndex - prescriptIndex : actualIndex);
        } else {
            returnIndex = actualIndex;
        }
        return returnIndex;
    }

    private int getPrescriptModelIndex() throws WmiNoReadAccessException {
        int i = 0;
        while (i < this.children.length) {
            if (this.getChild(i) instanceof WmiMathPrescriptModel) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void appendChild(WmiModel model) throws WmiNoWriteAccessException {
        WmiModel[] add = new WmiModel[]{model};
        try {
            int position = this.getChildCount();
            if (position == 3 && model instanceof WmiMathNoneModel) {
                add[0] = new WmiMathPrescriptModel(model.getDocument());
            }
            if (position == 6) {
                WmiModel[] moveChild = new WmiModel[]{this.getChild(5)};
                this.replaceChildren(moveChild, 4, 1);
                this.replaceChildren(add, 5, 1);
            } else {
                this.replaceChildren(add, position, 0);
            }
        }
        catch (WmiNoReadAccessException readE) {
            readE.printStackTrace();
        }
        catch (WmiModelIndexOutOfBoundsException boundsE) {
            boundsE.printStackTrace();
        }
    }

    public static class WmiMathMultiscriptDeleteHandler
    extends WmiAbstractMathDeleteHandler {
        private WmiMathMultiscriptDeleteHandler(WmiMathMultiscriptModel arg) {
            this.model = arg;
        }

        @Override
        protected void processRestructure(WmiDeleteManager manager) throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            boolean convertToMRow = false;
            if (this.model.getChild(0) instanceof WmiDeletePlaceholderModel) {
                convertToMRow = true;
                this.model.removeChild(0);
            }
            while (WmiModelUtil.getDeletedChildCount(this.model) > 0) {
                int position = WmiModelUtil.getFirstDeletePlaceHolderPosition(this.model);
                WmiDeletePlaceholderModel deleted = (WmiDeletePlaceholderModel)this.model.getChild(position);
                WmiModel replaced = deleted.getReplacedModel();
                if (replaced instanceof WmiMathNoneModel) {
                    this.model.removeChild(position);
                    continue;
                }
                this.model.replaceChild(new WmiMathNoneModel(this.model.getDocument()), position);
            }
            this.processCleanup(manager);
            if (convertToMRow) {
                this.buildMRow();
            } else {
                this.rebuildPrescripts();
            }
        }

        /*
         * Unable to fully structure code
         */
        private void buildMRow() throws WmiNoReadAccessException, WmiNoWriteAccessException {
            scripts = new WmiInlineMathModel[4];
            doc = this.model.getDocument();
            i = 0;
            while (i < 4) {
                scripts[i] = new WmiInlineMathModel(doc);
                ++i;
            }
            size = this.model.getChildCount();
            index = 0;
            i = 0;
            while (i < size) {
                child = this.model.getChild(i);
                if (child instanceof WmiMathNoneModel) ** GOTO lbl18
                if (child instanceof WmiMathPrescriptModel) {
                    index = 2;
                } else {
                    scripts[index].appendChild(child);
lbl18:
                    // 2 sources

                    index = index % 2 == 0 ? ++index : --index;
                }
                ++i;
            }
            pre = this.processScripts(scripts[2], scripts[3]);
            post = this.processScripts(scripts[0], scripts[1]);
            if (pre != null || post != null) {
                inline = new WmiInlineMathModel(doc);
                if (pre != null) {
                    inline.appendChild(pre);
                }
                if (post != null) {
                    inline.appendChild(post);
                }
                parent = this.model.getParent();
                index = parent.indexOf(this.model);
                try {
                    parent.replaceChild(inline, index);
                }
                catch (WmiModelIndexOutOfBoundsException e) {
                    WmiErrorLog.log(e);
                }
            }
        }

        private WmiModel processScripts(WmiCompositeModel sub, WmiCompositeModel sup) throws WmiNoReadAccessException {
            WmiCompositeModel build = null;
            int subCount = sub.getChildCount();
            int supCount = sup.getChildCount();
            if (subCount > 0 && supCount > 0) {
                WmiMathDocumentModel doc = sub.getDocument();
                WmiAttributeSet attribs = sub.getAttributesForRead();
                if (!(attribs instanceof WmiFontAttributeSet)) {
                    attribs = new WmiMathAttributeSet();
                }
                WmiMathContext context = new WmiMathContext((WmiFontAttributeSet)attribs);
                WmiMathTokenModel base = WmiMathFactory.createMathIdentifierToken(doc, "", context);
                build = new WmiSubSupModel(doc, base, sub, sup, context);
            } else if (subCount > 0) {
                build = sub;
            } else if (supCount > 0) {
                build = sup;
            }
            return build;
        }

        private void rebuildPrescripts() throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            if (WmiModelUtil.getDeletedChildCount(this.model) == 0) {
                int prescriptIndex = ((WmiMathMultiscriptModel)this.model).getPrescriptModelIndex();
                if (this.model.getChildCount() == 2) {
                    WmiCompositeModel parent = this.model.getParent();
                    int index = parent.indexOf(this.model);
                    WmiModel base = this.model.getChild(0);
                    parent.replaceChild(base, index);
                } else if (this.model.getChildCount() == 4 && prescriptIndex == 3) {
                    this.buildSubSupModels();
                } else {
                    if (this.model.getChildCount() == prescriptIndex + 1) {
                        this.model.appendChild(new WmiMathNoneModel(this.model.getDocument()));
                        this.model.appendChild(new WmiMathNoneModel(this.model.getDocument()));
                    }
                    if (prescriptIndex == 1) {
                        this.model.addChild(new WmiMathNoneModel(this.model.getDocument()), 1);
                        this.model.addChild(new WmiMathNoneModel(this.model.getDocument()), 1);
                    }
                }
            }
        }

        private void processCleanup(WmiDeleteManager manager) throws WmiNoReadAccessException, WmiNoWriteAccessException, WmiModelIndexOutOfBoundsException {
            int prescriptIndex = ((WmiMathMultiscriptModel)this.model).getPrescriptModelIndex();
            if (prescriptIndex < 0) {
                int i = 1;
                while (i < this.model.getChildCount()) {
                    if (this.model.getChild(i) instanceof WmiMathNoneModel && this.model.getChild(i + 1) instanceof WmiMathNoneModel) {
                        this.model.replaceChild(new WmiDeletePlaceholderModel(this.model.getChild(i)), i);
                        this.model.replaceChild(new WmiDeletePlaceholderModel(this.model.getChild(i + 1)), i + 1);
                        manager.mark(this.model);
                    }
                    i += 2;
                }
                this.model.appendChild(new WmiMathPrescriptModel(this.model.getDocument()));
            } else {
                int i = prescriptIndex + 1;
                while (i < this.model.getChildCount()) {
                    if (this.model.getChild(i) instanceof WmiMathNoneModel && this.model.getChild(i + 1) instanceof WmiMathNoneModel) {
                        this.model.replaceChild(new WmiDeletePlaceholderModel(this.model.getChild(i)), i);
                        this.model.replaceChild(new WmiDeletePlaceholderModel(this.model.getChild(i + 1)), i + 1);
                        manager.mark(this.model);
                    }
                    i += 2;
                }
                i = 1;
                while (i < prescriptIndex) {
                    if (this.model.getChild(i) instanceof WmiMathNoneModel && this.model.getChild(i + 1) instanceof WmiMathNoneModel) {
                        this.model.replaceChild(new WmiDeletePlaceholderModel(this.model.getChild(i)), i);
                        this.model.replaceChild(new WmiDeletePlaceholderModel(this.model.getChild(i + 1)), i + 1);
                        manager.mark(this.model);
                    }
                    i += 2;
                }
            }
        }

        @Override
        protected boolean isNonEmptyPlaceholder(WmiModel testModel) throws WmiNoReadAccessException {
            boolean nonEmptyPlaceholder = false;
            if (testModel instanceof WmiDeletePlaceholderModel) {
                WmiDeletePlaceholderModel placeHolder = (WmiDeletePlaceholderModel)testModel;
                WmiModel replaced = placeHolder.getReplacedModel();
                nonEmptyPlaceholder = !WmiModelUtil.isEmptyIdentifierModel(replaced) && !(replaced instanceof WmiMathNoneModel);
            }
            return nonEmptyPlaceholder;
        }

        private void buildSubSupModels() throws WmiNoWriteAccessException, WmiNoReadAccessException, WmiModelIndexOutOfBoundsException {
            WmiCompositeModel myParent = this.model.getParent();
            int index = myParent.indexOf(this.model);
            WmiModel restructured = null;
            if (!(this.model.getChild(1) instanceof WmiMathNoneModel) && !(this.model.getChild(2) instanceof WmiMathNoneModel)) {
                WmiFontAttributeSet fontAttrib = new WmiFontAttributeSet();
                if (this.model.getAttributes() instanceof WmiFontAttributeSet) {
                    fontAttrib = (WmiFontAttributeSet)this.model.getAttributes();
                }
                WmiMathContext context = new WmiMathContext(fontAttrib);
                restructured = new WmiSubSupModel(this.model.getDocument(), this.model.getChild(0), this.model.getChild(1), this.model.getChild(2), context);
            } else {
                restructured = !(this.model.getChild(1) instanceof WmiMathNoneModel) ? new WmiSubscriptModel(this.model.getDocument(), this.model.getChild(0), this.model.getChild(1), null) : (!(this.model.getChild(2) instanceof WmiMathNoneModel) ? new WmiSuperscriptModel(this.model.getDocument(), this.model.getChild(0), this.model.getChild(2), null) : this.model.getChild(0));
            }
            myParent.replaceChild(restructured, index);
        }
    }

    public static class WmiMathNoneModel
    extends WmiAbstractArrayCompositeMathModel
    implements WmiMathModel {
        public WmiMathNoneModel(WmiMathDocumentModel doc) {
            super(doc);
        }

        @Override
        public WmiModelTag getTag() {
            return WmiModelTag.MATH_NONE;
        }

        @Override
        public boolean isVisible() throws WmiNoReadAccessException {
            boolean visible = true;
            WmiMathDocumentModel doc = this.getDocument();
            if (doc != null) {
                visible = !doc.isHidden(this);
            }
            return visible;
        }

        @Override
        public Dag toDag() throws WmiNoReadAccessException {
            return null;
        }

        @Override
        public void setSemantics(WmiMathSemantics semantics) {
        }

        @Override
        public WmiMathSemantics getSemantics() {
            return null;
        }

        @Override
        public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
            return false;
        }
    }

    public static class WmiMathPrescriptModel
    extends WmiAbstractArrayCompositeMathModel
    implements WmiMathModel {
        public WmiMathPrescriptModel(WmiMathDocumentModel doc) {
            super(doc);
        }

        @Override
        public WmiModelTag getTag() {
            return WmiModelTag.MATH_PRESCRIPTS;
        }

        @Override
        public boolean isVisible() throws WmiNoReadAccessException {
            boolean visible = true;
            WmiMathDocumentModel doc = this.getDocument();
            if (doc != null) {
                visible = !doc.isHidden(this);
            }
            return visible;
        }

        @Override
        public Dag toDag() throws WmiNoReadAccessException {
            return null;
        }

        @Override
        public void setSemantics(WmiMathSemantics semantics) {
        }

        @Override
        public WmiMathSemantics getSemantics() {
            return null;
        }

        @Override
        public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
            return true;
        }
    }
}

