/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorModel;
import com.maplesoft.util.MathMLEntityMap;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class WmiMathOperatorDictionary {
    private static final int FORM = 0;
    private static final int FENCE = 1;
    private static final int SEPARATOR = 2;
    private static final int LSPACE = 3;
    private static final int RSPACE = 4;
    private static final int STRETCHY = 5;
    private static final int SYMMETRIC = 6;
    private static final int MAXSIZE = 7;
    private static final int MINSIZE = 8;
    private static final int LARGEOP = 9;
    private static final int MOVABLELIMITS = 10;
    private static final int ACCENT = 11;
    private static final int ATTRIBUTE_COUNT = 12;
    private static final String[] ATTRIBUTES = new String[]{"form", "fence", "separator", "lspace", "rspace", "stretchy", "symmetric", "maxsize", "minsize", "largeop", "movablelimits", "accent"};
    public static final int FORM_PREFIX = 0;
    public static final int FORM_INFIX = 1;
    public static final int FORM_POSTFIX = 2;
    private static final String[] FORMS = new String[]{"prefix", "infix", "postfix"};
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private static final int SPACE_ZERO = 0;
    private static final int SPACE_VERYVERYTHIN = 1;
    private static final int SPACE_VERYTHIN = 2;
    private static final int SPACE_THIN = 3;
    private static final int SPACE_MEDIUM = 4;
    private static final int SPACE_THICK = 5;
    private static final int SPACE_VERYTHICK = 6;
    private static final String[] SPACES = new String[]{"0em", "veryverythinmathspace", "verythinmathspace", "thinmathspace", "mediummathspace", "thickmathspace", "verythickmathspace"};
    private static final String RESOURCES = "com/maplesoft/mathdoc/model/math/resources/operator_dictionary";
    private static Map infix = null;
    private static Map prefix = null;
    private static Map postfix = null;

    static {
        Map nameToIndexMap = WmiMathOperatorDictionary.createNameToIndexMap();
        WmiMathOperatorDictionary.buildOperatorDictionary(nameToIndexMap);
    }

    private static Map createNameToIndexMap() {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("form", new Integer(0));
        m.put("fence", new Integer(1));
        m.put("separator", new Integer(2));
        m.put("lspace", new Integer(3));
        m.put("rspace", new Integer(4));
        m.put("stretchy", new Integer(5));
        m.put("symmetric", new Integer(6));
        m.put("maxsize", new Integer(7));
        m.put("minsize", new Integer(8));
        m.put("largeop", new Integer(9));
        m.put("movablelimits", new Integer(10));
        m.put("accent", new Integer(11));
        m.put("infix", new Integer(1));
        m.put("prefix", new Integer(0));
        m.put("postfix", new Integer(2));
        m.put("0em", new Integer(0));
        m.put("veryverythinmathspace", new Integer(1));
        m.put("verythinmathspace", new Integer(2));
        m.put("thinmathspace", new Integer(3));
        m.put("mediummathspace", new Integer(4));
        m.put("thickmathspace", new Integer(5));
        m.put("verythickmathspace", new Integer(6));
        return m;
    }

    private static void buildOperatorDictionary(Map nameToIndexMap) {
        ResourceBundle b = ResourceBundle.getBundle(RESOURCES);
        infix = new HashMap();
        prefix = new HashMap();
        postfix = new HashMap();
        Enumeration<String> keys = b.getKeys();
        while (keys.hasMoreElements()) {
            String op = keys.nextElement();
            String attribs = b.getString(op);
            String[] attribArray = attribs.split(",");
            int i = 0;
            while (i < attribArray.length) {
                char ch;
                String singleFormAttrib = attribArray[i].trim();
                DictionaryEntry entry = WmiMathOperatorDictionary.parseAttributes(singleFormAttrib, nameToIndexMap);
                Map dictionary = null;
                switch (entry.getAttribute(0)) {
                    case 0: {
                        dictionary = prefix;
                        break;
                    }
                    case 2: {
                        dictionary = postfix;
                        break;
                    }
                    default: {
                        dictionary = infix;
                    }
                }
                if (op != null && op.length() > 0 && ((ch = op.charAt(0)) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') && !op.equals("lim") && !op.equals("max") && !op.equals("min")) {
                    op = String.valueOf('&') + op + ';';
                }
                dictionary.put(op, entry);
                ++i;
            }
        }
    }

    private static DictionaryEntry parseAttributes(String attribs, Map nameToIndexMap) {
        int[] attrArray = new int[12];
        boolean[] setArray = new boolean[12];
        Arrays.fill(attrArray, 0);
        Arrays.fill(setArray, false);
        String[] pairs = attribs.split(" ");
        int i = 0;
        while (i < pairs.length) {
            String[] keyValue = pairs[i].split("=");
            Integer j = (Integer)nameToIndexMap.get(keyValue[0]);
            if (j != null) {
                int valueForDict;
                int attrIndex = j;
                attrArray[attrIndex] = valueForDict = WmiMathOperatorDictionary.translateToDictionaryValue(attrIndex, keyValue[1], nameToIndexMap);
                setArray[attrIndex] = true;
            }
            ++i;
        }
        return new DictionaryEntry(attrArray, setArray);
    }

    private WmiMathOperatorDictionary() {
    }

    public static boolean installAttributes(WmiMathOperatorModel model) throws WmiNoWriteAccessException {
        return WmiMathOperatorDictionary.installAttributes(model, null);
    }

    public static boolean installAttributes(WmiMathOperatorModel model, WmiAttributeSet set) throws WmiNoWriteAccessException {
        boolean found = WmiMathOperatorDictionary.installAttributes(model, 1, set);
        if (!found) {
            found = WmiMathOperatorDictionary.installAttributes(model, 0, set);
        }
        if (!found) {
            found = WmiMathOperatorDictionary.installAttributes(model, 2, set);
        }
        return found;
    }

    public static boolean installAttributes(WmiMathOperatorModel model, int whichfix) throws WmiNoWriteAccessException {
        return WmiMathOperatorDictionary.installAttributes(model, whichfix, null);
    }

    public static boolean installAttributes(WmiMathOperatorModel model, int whichfix, WmiAttributeSet set) throws WmiNoWriteAccessException {
        boolean found = false;
        try {
            String text = model.getTokenContents();
            String sem = model.getSemanticLabel();
            Map dictionary = null;
            switch (whichfix) {
                case 0: {
                    dictionary = prefix;
                    break;
                }
                case 2: {
                    dictionary = postfix;
                    break;
                }
                default: {
                    dictionary = infix;
                }
            }
            DictionaryEntry entry = (DictionaryEntry)dictionary.get(sem);
            if (entry == null) {
                entry = (DictionaryEntry)dictionary.get(text);
            }
            if (entry == null && text.length() == 1 && sem == null) {
                String entity = "&" + MathMLEntityMap.getMathMLName(text.charAt(0)) + ";";
                entry = (DictionaryEntry)dictionary.get(entity);
            }
            if (entry == null || sem != null && sem.equals("&ApplyFunction;")) {
                entry = (DictionaryEntry)dictionary.get(sem);
            }
            if (entry != null) {
                boolean retrieveSet = false;
                if (set == null) {
                    set = model.getAttributes();
                    retrieveSet = true;
                }
                WmiMathOperatorDictionary.copyAttributes(entry, set);
                if (retrieveSet) {
                    model.setAttributes(set);
                }
                found = true;
            }
        }
        catch (WmiNoReadAccessException nrae) {
            found = false;
            nrae.printStackTrace();
        }
        return found;
    }

    public static boolean isNameForOperator(String name) {
        if (!name.startsWith("&")) {
            name = "&" + name + ";";
        }
        return infix.containsKey(name) || prefix.containsKey(name) || postfix.containsKey(name);
    }

    private static void copyAttributes(DictionaryEntry entry, WmiAttributeSet set) throws WmiNoWriteAccessException {
        int i = 0;
        while (i < 12) {
            if (entry.isSet(i)) {
                int valueFromDict = entry.getAttribute(i);
                Object valueForAttribs = WmiMathOperatorDictionary.translateToAttributeSetValue(i, valueFromDict);
                set.addAttribute(ATTRIBUTES[i], valueForAttribs);
            }
            ++i;
        }
    }

    private static final int translateToDictionaryValue(int key, String value, Map nameToIndexMap) {
        int valueForDict = 0;
        switch (key) {
            case 0: 
            case 3: 
            case 4: {
                valueForDict = (Integer)nameToIndexMap.get(value);
                break;
            }
            case 7: 
            case 8: {
                valueForDict = Integer.parseInt(value);
                break;
            }
            default: {
                valueForDict = Boolean.valueOf(value) != false ? 1 : 0;
            }
        }
        return valueForDict;
    }

    private static final Object translateToAttributeSetValue(int key, int value) {
        Object valueForAttribs = null;
        switch (key) {
            case 0: {
                valueForAttribs = FORMS[value];
                break;
            }
            case 3: 
            case 4: {
                valueForAttribs = SPACES[value];
                break;
            }
            case 7: 
            case 8: {
                valueForAttribs = String.valueOf(Integer.toString(value)) + " pt";
                break;
            }
            default: {
                valueForAttribs = value != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return valueForAttribs;
    }

    private static class DictionaryEntry {
        private static final int[] SHIFTS = new int[]{14, 13, 12, 9, 6, 5, 4, 24, 16, 3, 2, 1};
        private static final int[] MASKS = new int[]{3, 1, 1, 7, 7, 1, 1, 255, 255, 1, 1, 1};
        private int set = 0;
        private int info = 0;

        public DictionaryEntry(int[] attribs, boolean[] setFlags) {
            int i = 0;
            while (i < setFlags.length) {
                if (setFlags[i]) {
                    this.setAttribute(i, attribs[i]);
                    this.set |= 1 << i;
                }
                ++i;
            }
        }

        private void setAttribute(int attr, int value) {
            this.info |= value << SHIFTS[attr];
        }

        public boolean isSet(int attr) {
            return (this.set & 1 << attr) != 0;
        }

        public int getAttribute(int attr) {
            return this.info >> SHIFTS[attr] & MASKS[attr];
        }
    }
}

