/*
 * Decompiled with CFR 0.152.
 */
package com.maplesoft.mathdoc.model.math;

import com.maplesoft.client.dag.Dag;
import com.maplesoft.mathdoc.exception.WmiErrorLog;
import com.maplesoft.mathdoc.exception.WmiModelIndexOutOfBoundsException;
import com.maplesoft.mathdoc.exception.WmiNoReadAccessException;
import com.maplesoft.mathdoc.exception.WmiNoWriteAccessException;
import com.maplesoft.mathdoc.model.WmiAbstractArrayAttributeSet;
import com.maplesoft.mathdoc.model.WmiAttributeKey;
import com.maplesoft.mathdoc.model.WmiAttributeSet;
import com.maplesoft.mathdoc.model.WmiBooleanAttributeKey;
import com.maplesoft.mathdoc.model.WmiCompositeModel;
import com.maplesoft.mathdoc.model.WmiFloatAttributeKey;
import com.maplesoft.mathdoc.model.WmiFontAttributeSet;
import com.maplesoft.mathdoc.model.WmiMathDocumentModel;
import com.maplesoft.mathdoc.model.WmiModel;
import com.maplesoft.mathdoc.model.WmiModelTag;
import com.maplesoft.mathdoc.model.WmiTextModel;
import com.maplesoft.mathdoc.model.math.WmiAbstractMathTokenModel;
import com.maplesoft.mathdoc.model.math.WmiImpliedSemantics;
import com.maplesoft.mathdoc.model.math.WmiMathAttributeSet;
import com.maplesoft.mathdoc.model.math.WmiMathContext;
import com.maplesoft.mathdoc.model.math.WmiMathModel;
import com.maplesoft.mathdoc.model.math.WmiMathOperatorDictionary;
import com.maplesoft.mathdoc.model.math.WmiMathSemantics;
import com.maplesoft.util.WmiStringParseTools;
import java.util.HashMap;
import java.util.HashSet;

public class WmiMathOperatorModel
extends WmiAbstractMathTokenModel
implements WmiMathModel {
    private static HashSet normalStyleOperators = new HashSet();
    private static HashSet keywordStyleOperators = new HashSet();
    private static HashSet infixKeywords = new HashSet();
    public static final String FORM = "form";
    public static final String FENCE = "fence";
    public static final String SEPARATOR = "separator";
    public static final String LSPACE = "lspace";
    public static final String RSPACE = "rspace";
    public static final String STRETCHY = "stretchy";
    public static final String SYMMETRIC = "symmetric";
    public static final String MAXSIZE = "maxsize";
    public static final String MINSIZE = "minsize";
    public static final String LARGEOP = "largeop";
    public static final String MOVABLELIMITS = "movablelimits";
    public static final String ACCENT = "accent";
    private static final float ZERO_SPACE_VALUE = 0.0f;
    private static final float VERYVERYTHIN_SPACE_VALUE = 0.0555556f;
    private static final float VERYTHIN_SPACE_VALUE = 0.1111111f;
    private static final float THIN_SPACE_VALUE = 0.1666667f;
    private static final float MEDIUM_SPACE_VALUE = 0.2222222f;
    private static final float THICK_SPACE_VALUE = 0.2777778f;
    private static final float VERYTHICK_SPACE_VALUE = 0.3333333f;
    public static final String PREFIX = "prefix";
    public static final String INFIX = "infix";
    public static final String POSTFIX = "postfix";
    public static final String ZERO_SPACE = "0em";
    public static final String VERYVERYTHIN_SPACE = "veryverythinmathspace";
    public static final String VERYTHIN_SPACE = "verythinmathspace";
    public static final String THIN_SPACE = "thinmathspace";
    public static final String MEDIUM_SPACE = "mediummathspace";
    public static final String THICK_SPACE = "thickmathspace";
    public static final String VERYTHICK_SPACE = "verythickmathspace";
    private static final WmiImpliedSemantics IMPLIED_SEMANTICS = new WmiImpliedSemantics();
    public static boolean disableStretchyOps = false;
    private WmiMathSemantics semantics = null;

    static {
        WmiMathOperatorModel.createNormalStyleMappings();
        WmiMathOperatorModel.createKeywordStyleMappings();
    }

    private static void createNormalStyleMappings() {
        normalStyleOperators.add("[");
        normalStyleOperators.add("]");
        normalStyleOperators.add("{");
        normalStyleOperators.add("}");
        normalStyleOperators.add("(");
        normalStyleOperators.add(")");
        normalStyleOperators.add("&verbar;");
        normalStyleOperators.add("&verbar;");
    }

    private static void createKeywordStyleMappings() {
        keywordStyleOperators.add("and");
        keywordStyleOperators.add("not");
        keywordStyleOperators.add("or");
        keywordStyleOperators.add("xor");
        keywordStyleOperators.add("&DoubleRightArrow;");
        keywordStyleOperators.add("implies");
        keywordStyleOperators.add("local");
        keywordStyleOperators.add("global");
        keywordStyleOperators.add("description");
        keywordStyleOperators.add("option");
        keywordStyleOperators.add("proc");
        keywordStyleOperators.add("module");
        keywordStyleOperators.add("end");
        keywordStyleOperators.add("if");
        keywordStyleOperators.add("then");
        keywordStyleOperators.add("elif");
        keywordStyleOperators.add("else");
        keywordStyleOperators.add("fi");
        keywordStyleOperators.add("for");
        keywordStyleOperators.add("in");
        keywordStyleOperators.add("from");
        keywordStyleOperators.add("by");
        keywordStyleOperators.add("to");
        keywordStyleOperators.add("while");
        keywordStyleOperators.add("do");
        keywordStyleOperators.add("od");
        keywordStyleOperators.add("end do");
        keywordStyleOperators.add("read");
        keywordStyleOperators.add("save");
        keywordStyleOperators.add("stop");
        keywordStyleOperators.add("error");
        keywordStyleOperators.add("try");
        keywordStyleOperators.add("catch");
        keywordStyleOperators.add("finally");
        keywordStyleOperators.add("return");
        keywordStyleOperators.add("break");
        keywordStyleOperators.add("next");
        keywordStyleOperators.add("moddef");
        keywordStyleOperators.add("export");
        keywordStyleOperators.add("use");
        keywordStyleOperators.add("end if");
        keywordStyleOperators.add("end proc");
        keywordStyleOperators.add("end try");
        keywordStyleOperators.add("end use");
        keywordStyleOperators.add("end module");
        keywordStyleOperators.add("union");
        keywordStyleOperators.add("intersect");
        keywordStyleOperators.add("subset");
        keywordStyleOperators.add("minus");
        keywordStyleOperators.add("in");
        keywordStyleOperators.add("intersect");
        keywordStyleOperators.add("iff");
        keywordStyleOperators.add("nand");
        keywordStyleOperators.add("nor");
        keywordStyleOperators.add("mod");
        keywordStyleOperators.add("union");
        keywordStyleOperators.add("options");
    }

    public WmiMathOperatorModel(WmiMathDocumentModel doc, String display, String semantics, WmiMathContext context, WmiCompositeModel parent) {
        this(doc, display, semantics, context);
        this.parent = parent;
    }

    public WmiMathOperatorModel(WmiMathDocumentModel doc, String display, String semantics, WmiMathContext context) {
        super(doc, semantics, context);
        this.attributes = this.createCompatibleAttributeSet();
        ((WmiMathOperatorAttributeSet)this.attributes).enablePadding(context.isOperatorPaddingEnabled());
        boolean dictionaryOperator = false;
        try {
            dictionaryOperator = WmiMathOperatorDictionary.installAttributes(this, this.attributes);
        }
        catch (WmiNoWriteAccessException e) {
            WmiErrorLog.log(e);
        }
        int type = WmiMathOperatorModel.getType(semantics);
        WmiMathAttributeSet styleFromContext = context.createAttributes(type);
        if (styleFromContext != null) {
            ((WmiMathAttributeSet)this.attributes).copyMathAttributes(styleFromContext);
        }
        this.attributes = ((WmiMathOperatorAttributeSet)this.attributes).pack();
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    public WmiMathOperatorModel(WmiMathDocumentModel doc, String display, String semantics, WmiAttributeSet set) {
        super(doc, semantics);
        this.attributes = this.createCompatibleAttributeSet();
        this.attributes.addAttributes(set);
        this.attributes = ((WmiMathOperatorAttributeSet)this.attributes).pack();
        this.setSemantics(IMPLIED_SEMANTICS);
    }

    @Override
    protected boolean enableMapleSyntaxMapping() {
        return false;
    }

    @Override
    public void replaceText(String text, int offset, int span) throws WmiModelIndexOutOfBoundsException, WmiNoWriteAccessException {
        super.replaceText(text, offset, span);
        try {
            WmiAttributeSet set = this.getAttributes();
            WmiMathOperatorDictionary.installAttributes(this, set);
            this.setAttributes(set);
        }
        catch (WmiNoReadAccessException e) {
            WmiErrorLog.log(e);
        }
    }

    public static int getType(String content) {
        int type = 3;
        if (normalStyleOperators.contains(content)) {
            type = 5;
        } else if (keywordStyleOperators.contains(content)) {
            type = 4;
        }
        return type;
    }

    @Override
    public WmiModelTag getTag() {
        return WmiModelTag.MATH_OPERATOR;
    }

    @Override
    public Dag toDag() throws WmiNoReadAccessException {
        return this.semantics != null ? this.semantics.toDag(this) : null;
    }

    @Override
    protected WmiTextModel createSubModel(int offset) throws WmiNoReadAccessException {
        return new WmiMathOperatorModel(this.getDocument(), this.getText().substring(offset), this.getText().substring(offset), new WmiMathContext((WmiFontAttributeSet)this.getAttributes()));
    }

    @Override
    public void setSemantics(WmiMathSemantics semantics) {
        this.semantics = semantics;
    }

    @Override
    public WmiMathSemantics getSemantics() {
        return this.semantics;
    }

    @Override
    protected WmiAttributeSet createCompatibleAttributeSet() {
        WmiMathOperatorAttributeSet set = new WmiMathOperatorAttributeSet();
        return set;
    }

    @Override
    public boolean isCrossBoundarySubselectable() {
        return false;
    }

    @Override
    public boolean isSubselectable() {
        return true;
    }

    @Override
    public boolean useScriptSize(WmiModel child) throws WmiNoReadAccessException {
        return false;
    }

    @Override
    protected boolean checkForQuotes() {
        return false;
    }

    @Override
    public boolean forceSave(Object key, Object value) {
        boolean save = false;
        if (key.toString().equals("bold") && value.toString().equals("false")) {
            try {
                String content = this.getAllText();
                save = keywordStyleOperators.contains(content);
            }
            catch (WmiNoReadAccessException e) {
                WmiErrorLog.log(e);
            }
        }
        return save;
    }

    public static class WmiMathOperatorAttributeSet
    extends WmiMathAttributeSet {
        public static final String[] ATTRIBUTES = new String[]{"fence", "separator", "lspace", "rspace", "stretchy", "symmetric", "largeop", "movablelimits", "accent", "font_style_name", "size", "foreground", "background"};
        public static final int FENCE_STYLE = 1;
        public static final int SEPARATOR_STYLE = 2;
        public static final int STRETCHY_STYLE = 4;
        public static final int SYMMETRIC_STYLE = 8;
        public static final int LARGEOP_STYLE = 16;
        public static final int MOVABLE_LIMITS_STYLE = 32;
        public static final int ACCENT_STYLE = 64;
        public static final int FENCE_UNSET_STYLE = 128;
        public static final int SEPARATOR_UNSET_STYLE = 256;
        public static final int STRETCHY_UNSET_STYLE = 512;
        public static final int SYMMETRIC_UNSET_STYLE = 1024;
        public static final int LARGEOP_UNSET_STYLE = 2048;
        public static final int MOVABLE_UNSET_LIMITS_STYLE = 4096;
        public static final int ACCENT_UNSET_STYLE = 8192;
        public static final int PT_PADDING_STYLE = 16384;
        public static final int UNSET_FACTOR = 128;
        public static final WmiAttributeKey[] OPERATOR_KEYS = new WmiAttributeKey[]{new FenceKey(), new SeparatorKey(), new StretchyKey(), new SymmetricKey(), new LargeOpKey(), new MovableLimitsKey(), new AccentKey(), new LSpaceKey(), new RSpaceKey()};
        private static final float SPACE_TOLERANCE = 1.0E-6f;
        public static final WmiAttributeKey[] EXTENDED_KEYS_OPERATOR = WmiAbstractArrayAttributeSet.createExtendedKeySet(WmiMathAttributeSet.EXTENDED_KEYS, OPERATOR_KEYS);
        private static HashMap keyMap = null;
        private static HashMap cache = new HashMap();
        protected float lspace = 0.0f;
        protected float rspace = 0.0f;
        protected int operatorStyle = 0;
        protected boolean operatorPadding = true;

        public WmiMathOperatorAttributeSet() {
        }

        public WmiMathOperatorAttributeSet(WmiMathOperatorAttributeSet source) {
            super(source);
            this.lspace = source.lspace;
            this.rspace = source.rspace;
            this.operatorStyle = source.operatorStyle;
            this.operatorPadding = source.operatorPadding;
        }

        @Override
        public void addAttributes(WmiAttributeSet set) {
            super.addAttributes(set);
            if (set instanceof WmiMathOperatorAttributeSet) {
                WmiMathOperatorAttributeSet source = (WmiMathOperatorAttributeSet)set;
                this.lspace = source.lspace;
                this.rspace = source.rspace;
                this.operatorStyle = source.operatorStyle;
                this.operatorPadding = source.operatorPadding;
            }
        }

        public void enablePadding(boolean state) {
            this.operatorPadding = state;
        }

        public void resetDefaultOperatorDictionaryAttributes() {
            this.lspace = 0.0f;
            this.rspace = 0.0f;
            this.operatorStyle = 0;
        }

        @Override
        public WmiAttributeSet copyAttributes() {
            return new WmiMathOperatorAttributeSet(this);
        }

        public boolean isFence() {
            return this.hasOperatorStyle(1);
        }

        public boolean isSeparator() {
            return this.hasOperatorStyle(2);
        }

        public float getLSpace() {
            return this.operatorPadding ? this.lspace : 0.0f;
        }

        public float getRSpace() {
            return this.operatorPadding ? this.rspace : 0.0f;
        }

        public boolean isStretchy() {
            return this.hasOperatorStyle(4);
        }

        public boolean isSymmetric() {
            return this.hasOperatorStyle(8);
        }

        public boolean isLargeOp() {
            return this.hasOperatorStyle(16);
        }

        public boolean hasMovableLimits() {
            return this.hasOperatorStyle(32);
        }

        public boolean isAccent() {
            return this.hasOperatorStyle(64);
        }

        public boolean hasOperatorStyle(int style) {
            return (this.operatorStyle & style) != 0;
        }

        public void setOperatorStyle(int style, int state) {
            this.operatorStyle = state == 1 ? (this.operatorStyle |= style) : (state == 0 ? (this.operatorStyle &= ~style) : (this.operatorStyle |= style * 128));
        }

        @Override
        public boolean equals(Object obj) {
            boolean equals = false;
            if (this == obj) {
                equals = true;
            } else if (super.equals(obj) && obj instanceof WmiMathOperatorAttributeSet) {
                WmiMathOperatorAttributeSet ref = (WmiMathOperatorAttributeSet)obj;
                boolean bl = equals = ref.operatorStyle == this.operatorStyle;
                if (Math.abs(this.lspace - ref.lspace) > 1.0E-6f) {
                    equals = false;
                } else if (Math.abs(this.rspace - ref.rspace) > 1.0E-6f) {
                    equals = false;
                }
            }
            return equals;
        }

        @Override
        public int hashCode() {
            int code = super.hashCode();
            code ^= this.operatorStyle;
            code ^= (int)(this.lspace * 100000.0f);
            return code ^= (int)(this.rspace * 100000.0f);
        }

        @Override
        protected HashMap getKeyMap() {
            return keyMap;
        }

        @Override
        public WmiAttributeKey[] getKeys() {
            return EXTENDED_KEYS_OPERATOR;
        }

        @Override
        protected void setKeyMap(HashMap map) {
            keyMap = map;
        }

        @Override
        public HashMap getCache() {
            return cache;
        }

        public static class AccentKey
        extends OperatorStyleKey {
            public AccentKey() {
                super(WmiMathOperatorModel.ACCENT, 64);
            }
        }

        public static class FenceKey
        extends OperatorStyleKey {
            public FenceKey() {
                super(WmiMathOperatorModel.FENCE, 1);
            }
        }

        public static class LSpaceKey
        extends PaddingKey {
            public LSpaceKey() {
                super(WmiMathOperatorModel.LSPACE, 0.2777778f);
            }

            @Override
            public float getFloatValue(WmiAttributeSet set) {
                return ((WmiMathOperatorAttributeSet)set).lspace;
            }

            @Override
            public void setFloatValue(WmiAttributeSet set, float value) {
                ((WmiMathOperatorAttributeSet)set).lspace = ((WmiMathOperatorAttributeSet)set).operatorPadding ? value : 0.0f;
            }
        }

        public static class LargeOpKey
        extends OperatorStyleKey {
            public LargeOpKey() {
                super(WmiMathOperatorModel.LARGEOP, 16);
            }
        }

        public static class MovableLimitsKey
        extends OperatorStyleKey {
            public MovableLimitsKey() {
                super(WmiMathOperatorModel.MOVABLELIMITS, 32);
            }
        }

        public static class OperatorStyleKey
        extends WmiBooleanAttributeKey {
            private int styleBit;
            private static final int FALSE_VALUE = 0;
            private static final int TRUE_VALUE = 1;
            private static final int UNSET_VALUE = 2;
            public static final String UNSET = "unset";

            public OperatorStyleKey(String name, int styleBit) {
                super(name, false);
                this.styleBit = styleBit;
            }

            @Override
            public boolean getBooleanValue(WmiAttributeSet set) {
                return set instanceof WmiMathOperatorAttributeSet ? ((WmiMathOperatorAttributeSet)set).hasOperatorStyle(this.styleBit) : false;
            }

            @Override
            public Object getValue(WmiAttributeSet set) {
                if (((WmiMathOperatorAttributeSet)set).hasOperatorStyle(this.styleBit)) {
                    return "true";
                }
                if (((WmiMathOperatorAttributeSet)set).hasOperatorStyle(this.styleBit * 128)) {
                    return UNSET;
                }
                return "false";
            }

            @Override
            public void setBooleanValue(WmiAttributeSet set, boolean value) {
                if (set instanceof WmiMathOperatorAttributeSet) {
                    if (value) {
                        ((WmiMathOperatorAttributeSet)set).setOperatorStyle(this.styleBit, 1);
                    } else {
                        ((WmiMathOperatorAttributeSet)set).setOperatorStyle(this.styleBit, 0);
                    }
                }
            }

            public void setBooleanValue(WmiAttributeSet set, int value) {
                if (set instanceof WmiMathOperatorAttributeSet) {
                    ((WmiMathOperatorAttributeSet)set).setOperatorStyle(this.styleBit, value);
                }
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                if (value != null) {
                    if (value.compareToIgnoreCase("true") == 0) {
                        this.setBooleanValue(set, 1);
                    } else if (value.compareToIgnoreCase("false") == 0) {
                        this.setBooleanValue(set, 0);
                    } else if (value.compareToIgnoreCase(UNSET) == 0) {
                        this.setBooleanValue(set, 2);
                    } else {
                        this.setBooleanValue(set, this.defaultValue);
                    }
                } else {
                    this.setBooleanValue(set, this.defaultValue);
                }
            }
        }

        public static class PaddingKey
        extends WmiFloatAttributeKey {
            public static final int PICAS_TO_PIXELS = 12;
            public static final int INCHES_TO_PIXELS = 72;
            public static final float CENTIMETRES_TO_PIXELS = 28.346457f;
            public static final float MM_TO_PIXELS = 283.46457f;
            public static final float EX_TO_EM = 0.65f;
            public static final float PERCENT_TO_EM = 0.01f;
            static HashMap nameMap = new HashMap();

            protected PaddingKey(String name, float defaultValue) {
                super(name, defaultValue);
            }

            @Override
            public Object getValue(WmiAttributeSet set) {
                return this.getStringValue(set);
            }

            @Override
            public String getStringValue(WmiAttributeSet set) {
                float value = this.getFloatValue(set);
                String suffix = "em";
                if (set instanceof WmiMathOperatorAttributeSet && (((WmiMathOperatorAttributeSet)set).operatorStyle & 0x4000) != 0) {
                    suffix = "pt";
                }
                return String.valueOf(Float.toString(value)) + suffix;
            }

            @Override
            public void setStringValue(WmiAttributeSet set, String value) {
                if (nameMap.size() == 0) {
                    nameMap.put(WmiMathOperatorModel.VERYVERYTHIN_SPACE, new Float(0.0555556f));
                    nameMap.put(WmiMathOperatorModel.VERYTHIN_SPACE, new Float(0.1111111f));
                    nameMap.put(WmiMathOperatorModel.THIN_SPACE, new Float(0.1666667f));
                    nameMap.put(WmiMathOperatorModel.MEDIUM_SPACE, new Float(0.2222222f));
                    nameMap.put(WmiMathOperatorModel.THICK_SPACE, new Float(0.2777778f));
                    nameMap.put(WmiMathOperatorModel.VERYTHICK_SPACE, new Float(0.3333333f));
                }
                WmiMathOperatorAttributeSet opSet = null;
                if (set instanceof WmiMathOperatorAttributeSet) {
                    opSet = (WmiMathOperatorAttributeSet)set;
                }
                float fvalue = 0.0f;
                Object obj = nameMap.get(value);
                if (obj instanceof Float) {
                    fvalue = ((Float)obj).floatValue();
                    if (opSet != null) {
                        opSet.operatorStyle &= 0xFFFFBFFF;
                    }
                } else if (value.length() > 2) {
                    int suffixLength = value.endsWith("%") ? 1 : 2;
                    try {
                        fvalue = WmiStringParseTools.parseFloat(value, 0, value.length() - suffixLength);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (value.endsWith("em")) {
                        if (opSet != null) {
                            opSet.operatorStyle &= 0xFFFFBFFF;
                        }
                    } else if (value.endsWith("ex")) {
                        fvalue *= 0.65f;
                        if (opSet != null) {
                            opSet.operatorStyle &= 0xFFFFBFFF;
                        }
                    } else if (value.endsWith("%")) {
                        fvalue *= 0.01f;
                        if (opSet != null) {
                            opSet.operatorStyle &= 0xFFFFBFFF;
                        }
                    } else {
                        if (opSet != null) {
                            opSet.operatorStyle |= 0x4000;
                        }
                        if (value.endsWith("cm")) {
                            fvalue *= 28.346457f;
                        } else if (value.endsWith("mm")) {
                            fvalue *= 283.46457f;
                        } else if (value.endsWith("in")) {
                            fvalue *= 72.0f;
                        } else if (value.endsWith("pc")) {
                            fvalue *= 12.0f;
                        } else if (!value.endsWith("pt") && !value.endsWith("px")) {
                            fvalue = 0.0f;
                        }
                    }
                }
                this.setFloatValue(set, fvalue);
            }
        }

        public static class RSpaceKey
        extends PaddingKey {
            public RSpaceKey() {
                super(WmiMathOperatorModel.RSPACE, 0.2777778f);
            }

            @Override
            public float getFloatValue(WmiAttributeSet set) {
                return ((WmiMathOperatorAttributeSet)set).rspace;
            }

            @Override
            public void setFloatValue(WmiAttributeSet set, float value) {
                ((WmiMathOperatorAttributeSet)set).rspace = ((WmiMathOperatorAttributeSet)set).operatorPadding ? value : 0.0f;
            }
        }

        public static class SeparatorKey
        extends OperatorStyleKey {
            public SeparatorKey() {
                super(WmiMathOperatorModel.SEPARATOR, 2);
            }
        }

        public static class StretchyKey
        extends OperatorStyleKey {
            public StretchyKey() {
                super(WmiMathOperatorModel.STRETCHY, 4);
            }
        }

        public static class SymmetricKey
        extends OperatorStyleKey {
            public SymmetricKey() {
                super(WmiMathOperatorModel.SYMMETRIC, 8);
            }
        }
    }
}

